// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The resource representing a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
 */
public class ServerlessCacheSnapshot private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The total size of a serverless cache snapshot, in bytes. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val bytesUsedForCache: kotlin.String? = builder.bytesUsedForCache
    /**
     * The date and time that the source serverless cache's metadata and cache data set was obtained for the snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The time that the serverless cache snapshot will expire. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val expiryTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expiryTime
    /**
     * The ID of the Amazon Web Services Key Management Service (KMS) key of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The configuration of the serverless cache, at the time the snapshot was taken. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val serverlessCacheConfiguration: aws.sdk.kotlin.services.elasticache.model.ServerlessCacheConfiguration? = builder.serverlessCacheConfiguration
    /**
     * The identifier of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val serverlessCacheSnapshotName: kotlin.String? = builder.serverlessCacheSnapshotName
    /**
     * The type of snapshot of serverless cache. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val snapshotType: kotlin.String? = builder.snapshotType
    /**
     * The current status of the serverless cache. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.ServerlessCacheSnapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerlessCacheSnapshot(")
        append("arn=$arn,")
        append("bytesUsedForCache=$bytesUsedForCache,")
        append("createTime=$createTime,")
        append("expiryTime=$expiryTime,")
        append("kmsKeyId=$kmsKeyId,")
        append("serverlessCacheConfiguration=$serverlessCacheConfiguration,")
        append("serverlessCacheSnapshotName=$serverlessCacheSnapshotName,")
        append("snapshotType=$snapshotType,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (bytesUsedForCache?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (expiryTime?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (serverlessCacheConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverlessCacheSnapshotName?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerlessCacheSnapshot

        if (arn != other.arn) return false
        if (bytesUsedForCache != other.bytesUsedForCache) return false
        if (createTime != other.createTime) return false
        if (expiryTime != other.expiryTime) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (serverlessCacheConfiguration != other.serverlessCacheConfiguration) return false
        if (serverlessCacheSnapshotName != other.serverlessCacheSnapshotName) return false
        if (snapshotType != other.snapshotType) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.ServerlessCacheSnapshot = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var arn: kotlin.String? = null
        /**
         * The total size of a serverless cache snapshot, in bytes. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var bytesUsedForCache: kotlin.String? = null
        /**
         * The date and time that the source serverless cache's metadata and cache data set was obtained for the snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that the serverless cache snapshot will expire. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var expiryTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the Amazon Web Services Key Management Service (KMS) key of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The configuration of the serverless cache, at the time the snapshot was taken. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var serverlessCacheConfiguration: aws.sdk.kotlin.services.elasticache.model.ServerlessCacheConfiguration? = null
        /**
         * The identifier of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var serverlessCacheSnapshotName: kotlin.String? = null
        /**
         * The type of snapshot of serverless cache. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var snapshotType: kotlin.String? = null
        /**
         * The current status of the serverless cache. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.ServerlessCacheSnapshot) : this() {
            this.arn = x.arn
            this.bytesUsedForCache = x.bytesUsedForCache
            this.createTime = x.createTime
            this.expiryTime = x.expiryTime
            this.kmsKeyId = x.kmsKeyId
            this.serverlessCacheConfiguration = x.serverlessCacheConfiguration
            this.serverlessCacheSnapshotName = x.serverlessCacheSnapshotName
            this.snapshotType = x.snapshotType
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.ServerlessCacheSnapshot = ServerlessCacheSnapshot(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.ServerlessCacheConfiguration] inside the given [block]
         */
        public fun serverlessCacheConfiguration(block: aws.sdk.kotlin.services.elasticache.model.ServerlessCacheConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessCacheConfiguration = aws.sdk.kotlin.services.elasticache.model.ServerlessCacheConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
