// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration settings for horizontal or vertical scaling operations on Memcached clusters.
 */
public class ScaleConfig private constructor(builder: Builder) {
    /**
     * The time interval in seconds between scaling operations when performing gradual scaling for a Memcached cluster.
     */
    public val scaleIntervalMinutes: kotlin.Int? = builder.scaleIntervalMinutes
    /**
     * The percentage by which to scale the Memcached cluster, either horizontally by adding nodes or vertically by increasing resources.
     */
    public val scalePercentage: kotlin.Int? = builder.scalePercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.ScaleConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScaleConfig(")
        append("scaleIntervalMinutes=$scaleIntervalMinutes,")
        append("scalePercentage=$scalePercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = scaleIntervalMinutes ?: 0
        result = 31 * result + (scalePercentage ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScaleConfig

        if (scaleIntervalMinutes != other.scaleIntervalMinutes) return false
        if (scalePercentage != other.scalePercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.ScaleConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time interval in seconds between scaling operations when performing gradual scaling for a Memcached cluster.
         */
        public var scaleIntervalMinutes: kotlin.Int? = null
        /**
         * The percentage by which to scale the Memcached cluster, either horizontally by adding nodes or vertically by increasing resources.
         */
        public var scalePercentage: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.ScaleConfig) : this() {
            this.scaleIntervalMinutes = x.scaleIntervalMinutes
            this.scalePercentage = x.scalePercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.ScaleConfig = ScaleConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
