// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input of a `RemoveTagsFromResource` operation.
 */
public class RemoveTagsFromResourceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example `arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster` or `arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot`.
     *
     * For more information about ARNs, see [Amazon Resource Names (ARNs) and Amazon Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * A list of `TagKeys` identifying the tags you want removed from the named resource.
     */
    public val tagKeys: List<String>? = builder.tagKeys

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.RemoveTagsFromResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RemoveTagsFromResourceRequest(")
        append("resourceName=$resourceName,")
        append("tagKeys=$tagKeys")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceName?.hashCode() ?: 0
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RemoveTagsFromResourceRequest

        if (resourceName != other.resourceName) return false
        if (tagKeys != other.tagKeys) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.RemoveTagsFromResourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example `arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster` or `arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot`.
         *
         * For more information about ARNs, see [Amazon Resource Names (ARNs) and Amazon Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
         */
        public var resourceName: kotlin.String? = null
        /**
         * A list of `TagKeys` identifying the tags you want removed from the named resource.
         */
        public var tagKeys: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.RemoveTagsFromResourceRequest) : this() {
            this.resourceName = x.resourceName
            this.tagKeys = x.tagKeys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.RemoveTagsFromResourceRequest = RemoveTagsFromResourceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
