// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A group of settings that are applied to the cluster in the future, or that are currently being applied.
 */
public class PendingModifiedValues private constructor(builder: Builder) {
    /**
     * The auth token status
     */
    public val authTokenStatus: aws.sdk.kotlin.services.elasticache.model.AuthTokenUpdateStatus? = builder.authTokenStatus
    /**
     * A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a 4-digit numeric identifier (0001, 0002, etc.).
     */
    public val cacheNodeIdsToRemove: List<String>? = builder.cacheNodeIdsToRemove
    /**
     * The cache node type that this cluster or replication group is scaled to.
     */
    public val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * The new cache engine version that the cluster runs.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The log delivery configurations being modified
     */
    public val logDeliveryConfigurations: List<PendingLogDeliveryConfiguration>? = builder.logDeliveryConfigurations
    /**
     * The new number of cache nodes for the cluster.
     *
     * For clusters running Valkey or Redis OSS, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
     */
    public val numCacheNodes: kotlin.Int? = builder.numCacheNodes
    /**
     * The scaling configuration changes that are pending for the Memcached cluster.
     */
    public val scaleConfig: aws.sdk.kotlin.services.elasticache.model.ScaleConfig? = builder.scaleConfig
    /**
     * A flag that enables in-transit encryption when set to true.
     */
    public val transitEncryptionEnabled: kotlin.Boolean? = builder.transitEncryptionEnabled
    /**
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     */
    public val transitEncryptionMode: aws.sdk.kotlin.services.elasticache.model.TransitEncryptionMode? = builder.transitEncryptionMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PendingModifiedValues(")
        append("authTokenStatus=$authTokenStatus,")
        append("cacheNodeIdsToRemove=$cacheNodeIdsToRemove,")
        append("cacheNodeType=$cacheNodeType,")
        append("engineVersion=$engineVersion,")
        append("logDeliveryConfigurations=$logDeliveryConfigurations,")
        append("numCacheNodes=$numCacheNodes,")
        append("scaleConfig=$scaleConfig,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled,")
        append("transitEncryptionMode=$transitEncryptionMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authTokenStatus?.hashCode() ?: 0
        result = 31 * result + (cacheNodeIdsToRemove?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeType?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfigurations?.hashCode() ?: 0)
        result = 31 * result + (numCacheNodes ?: 0)
        result = 31 * result + (scaleConfig?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PendingModifiedValues

        if (authTokenStatus != other.authTokenStatus) return false
        if (cacheNodeIdsToRemove != other.cacheNodeIdsToRemove) return false
        if (cacheNodeType != other.cacheNodeType) return false
        if (engineVersion != other.engineVersion) return false
        if (logDeliveryConfigurations != other.logDeliveryConfigurations) return false
        if (numCacheNodes != other.numCacheNodes) return false
        if (scaleConfig != other.scaleConfig) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false
        if (transitEncryptionMode != other.transitEncryptionMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The auth token status
         */
        public var authTokenStatus: aws.sdk.kotlin.services.elasticache.model.AuthTokenUpdateStatus? = null
        /**
         * A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a 4-digit numeric identifier (0001, 0002, etc.).
         */
        public var cacheNodeIdsToRemove: List<String>? = null
        /**
         * The cache node type that this cluster or replication group is scaled to.
         */
        public var cacheNodeType: kotlin.String? = null
        /**
         * The new cache engine version that the cluster runs.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The log delivery configurations being modified
         */
        public var logDeliveryConfigurations: List<PendingLogDeliveryConfiguration>? = null
        /**
         * The new number of cache nodes for the cluster.
         *
         * For clusters running Valkey or Redis OSS, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
         */
        public var numCacheNodes: kotlin.Int? = null
        /**
         * The scaling configuration changes that are pending for the Memcached cluster.
         */
        public var scaleConfig: aws.sdk.kotlin.services.elasticache.model.ScaleConfig? = null
        /**
         * A flag that enables in-transit encryption when set to true.
         */
        public var transitEncryptionEnabled: kotlin.Boolean? = null
        /**
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         */
        public var transitEncryptionMode: aws.sdk.kotlin.services.elasticache.model.TransitEncryptionMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues) : this() {
            this.authTokenStatus = x.authTokenStatus
            this.cacheNodeIdsToRemove = x.cacheNodeIdsToRemove
            this.cacheNodeType = x.cacheNodeType
            this.engineVersion = x.engineVersion
            this.logDeliveryConfigurations = x.logDeliveryConfigurations
            this.numCacheNodes = x.numCacheNodes
            this.scaleConfig = x.scaleConfig
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
            this.transitEncryptionMode = x.transitEncryptionMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues = PendingModifiedValues(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.ScaleConfig] inside the given [block]
         */
        public fun scaleConfig(block: aws.sdk.kotlin.services.elasticache.model.ScaleConfig.Builder.() -> kotlin.Unit) {
            this.scaleConfig = aws.sdk.kotlin.services.elasticache.model.ScaleConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
