// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Node group (shard) configuration options. Each node group (shard) configuration has the following: `Slots`, `PrimaryAvailabilityZone`, `ReplicaAvailabilityZones`, `ReplicaCount`.
 */
public class NodeGroupConfiguration private constructor(builder: Builder) {
    /**
     * Either the ElastiCache supplied 4-digit id or a user supplied id for the node group these configuration values apply to.
     */
    public val nodeGroupId: kotlin.String? = builder.nodeGroupId
    /**
     * The Availability Zone where the primary node of this node group (shard) is launched.
     */
    public val primaryAvailabilityZone: kotlin.String? = builder.primaryAvailabilityZone
    /**
     * The outpost ARN of the primary node.
     */
    public val primaryOutpostArn: kotlin.String? = builder.primaryOutpostArn
    /**
     * A list of Availability Zones to be used for the read replicas. The number of Availability Zones in this list must match the value of `ReplicaCount` or `ReplicasPerNodeGroup` if not specified.
     */
    public val replicaAvailabilityZones: List<String>? = builder.replicaAvailabilityZones
    /**
     * The number of read replica nodes in this node group (shard).
     */
    public val replicaCount: kotlin.Int? = builder.replicaCount
    /**
     * The outpost ARN of the node replicas.
     */
    public val replicaOutpostArns: List<String>? = builder.replicaOutpostArns
    /**
     * A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The string is in the format `startkey-endkey`.
     *
     * Example: `"0-3999"`
     */
    public val slots: kotlin.String? = builder.slots

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeGroupConfiguration(")
        append("nodeGroupId=$nodeGroupId,")
        append("primaryAvailabilityZone=$primaryAvailabilityZone,")
        append("primaryOutpostArn=$primaryOutpostArn,")
        append("replicaAvailabilityZones=$replicaAvailabilityZones,")
        append("replicaCount=$replicaCount,")
        append("replicaOutpostArns=$replicaOutpostArns,")
        append("slots=$slots")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = nodeGroupId?.hashCode() ?: 0
        result = 31 * result + (primaryAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (primaryOutpostArn?.hashCode() ?: 0)
        result = 31 * result + (replicaAvailabilityZones?.hashCode() ?: 0)
        result = 31 * result + (replicaCount ?: 0)
        result = 31 * result + (replicaOutpostArns?.hashCode() ?: 0)
        result = 31 * result + (slots?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeGroupConfiguration

        if (nodeGroupId != other.nodeGroupId) return false
        if (primaryAvailabilityZone != other.primaryAvailabilityZone) return false
        if (primaryOutpostArn != other.primaryOutpostArn) return false
        if (replicaAvailabilityZones != other.replicaAvailabilityZones) return false
        if (replicaCount != other.replicaCount) return false
        if (replicaOutpostArns != other.replicaOutpostArns) return false
        if (slots != other.slots) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Either the ElastiCache supplied 4-digit id or a user supplied id for the node group these configuration values apply to.
         */
        public var nodeGroupId: kotlin.String? = null
        /**
         * The Availability Zone where the primary node of this node group (shard) is launched.
         */
        public var primaryAvailabilityZone: kotlin.String? = null
        /**
         * The outpost ARN of the primary node.
         */
        public var primaryOutpostArn: kotlin.String? = null
        /**
         * A list of Availability Zones to be used for the read replicas. The number of Availability Zones in this list must match the value of `ReplicaCount` or `ReplicasPerNodeGroup` if not specified.
         */
        public var replicaAvailabilityZones: List<String>? = null
        /**
         * The number of read replica nodes in this node group (shard).
         */
        public var replicaCount: kotlin.Int? = null
        /**
         * The outpost ARN of the node replicas.
         */
        public var replicaOutpostArns: List<String>? = null
        /**
         * A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The string is in the format `startkey-endkey`.
         *
         * Example: `"0-3999"`
         */
        public var slots: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration) : this() {
            this.nodeGroupId = x.nodeGroupId
            this.primaryAvailabilityZone = x.primaryAvailabilityZone
            this.primaryOutpostArn = x.primaryOutpostArn
            this.replicaAvailabilityZones = x.replicaAvailabilityZones
            this.replicaCount = x.replicaCount
            this.replicaOutpostArns = x.replicaOutpostArns
            this.slots = x.slots
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration = NodeGroupConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
