// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input of a `ModifyReplicationGroups` operation.
 */
public class ModifyReplicationGroupRequest private constructor(builder: Builder) {
    /**
     * If `true`, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the replication group.
     *
     * If `false`, changes to the nodes in the replication group are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.
     *
     * Valid values: `true` | `false`
     *
     * Default: `false`
     */
    public val applyImmediately: kotlin.Boolean? = builder.applyImmediately
    /**
     * Reserved parameter. The password used to access a password protected server. This parameter must be specified with the `auth-token-update-strategy ` parameter. Password constraints:
     * + Must be only printable ASCII characters
     * + Must be at least 16 characters and no more than 128 characters in length
     * + Cannot contain any of the following characters: '/', '"', or '@', '%'
     *
     *  For more information, see AUTH password at [AUTH](http://redis.io/commands/AUTH).
     */
    public val authToken: kotlin.String? = builder.authToken
    /**
     * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the `auth-token` parameter. Possible values:
     * + ROTATE - default, if no update strategy is provided
     * + SET - allowed only after ROTATE
     * + DELETE - allowed only when transitioning to RBAC
     *
     *  For more information, see [Authenticating Users with AUTH](http://docs.aws.amazon.com/AmazonElastiCache/latest/dg/auth.html)
     */
    public val authTokenUpdateStrategy: aws.sdk.kotlin.services.elasticache.model.AuthTokenUpdateStrategyType? = builder.authTokenUpdateStrategy
    /**
     * If you are running Valkey or Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.
     *
     * Valid values: `true` | `false`
     */
    public val automaticFailoverEnabled: kotlin.Boolean? = builder.automaticFailoverEnabled
    /**
     * A valid cache node type that you want to scale this replication group to.
     */
    public val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * The name of the cache parameter group to apply to all of the clusters in this replication group. This change is asynchronously applied as soon as possible for parameters when the `ApplyImmediately` parameter is specified as `true` for this request.
     */
    public val cacheParameterGroupName: kotlin.String? = builder.cacheParameterGroupName
    /**
     * A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.
     *
     * This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).
     *
     * Constraints: Must contain no more than 255 alphanumeric characters. Must not be `Default`.
     */
    public val cacheSecurityGroupNames: List<String>? = builder.cacheSecurityGroupNames
    /**
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to Compatible. Compatible mode allows your Valkey or Redis OSS clients to connect using both cluster mode enabled and cluster mode disabled. After you migrate all Valkey or Redis OSS clients to use cluster mode enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.
     */
    public val clusterMode: aws.sdk.kotlin.services.elasticache.model.ClusterMode? = builder.clusterMode
    /**
     * Modifies the engine listed in a replication group message. The options are redis, memcached or valkey.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The upgraded version of the cache engine to be run on the clusters in the replication group.
     *
     * **Important:** You can upgrade to a newer engine version (see [Selecting a Cache Engine and Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/SelectEngine.html#VersionManagement)), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing replication group and create it anew with the earlier engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The network type you choose when modifying a cluster, either `ipv4` | `ipv6`. IPv6 is supported for workloads using Valkey 7.2 and above, Redis OSS engine version 6.2 to 7.1 and Memcached engine version 1.6.6 and above on all instances built on the [Nitro system](http://aws.amazon.com/ec2/nitro/).
     */
    public val ipDiscovery: aws.sdk.kotlin.services.elasticache.model.IpDiscovery? = builder.ipDiscovery
    /**
     * Specifies the destination, format and type of the logs.
     */
    public val logDeliveryConfigurations: List<LogDeliveryConfigurationRequest>? = builder.logDeliveryConfigurations
    /**
     * A flag to indicate MultiAZ is enabled.
     */
    public val multiAzEnabled: kotlin.Boolean? = builder.multiAzEnabled
    /**
     * Deprecated. This parameter is not used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val nodeGroupId: kotlin.String? = builder.nodeGroupId
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
     *
     * The Amazon SNS topic owner must be same as the replication group owner.
     */
    public val notificationTopicArn: kotlin.String? = builder.notificationTopicArn
    /**
     * The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the status is `active`.
     *
     * Valid values: `active` | `inactive`
     */
    public val notificationTopicStatus: kotlin.String? = builder.notificationTopicStatus
    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     *
     * Valid values for `ddd` are:
     * + `sun`
     * + `mon`
     * + `tue`
     * + `wed`
     * + `thu`
     * + `fri`
     * + `sat`
     *
     * Example: `sun:23:00-mon:01:30`
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role. The nodes of all other clusters in the replication group are read replicas.
     */
    public val primaryClusterId: kotlin.String? = builder.primaryClusterId
    /**
     * Removes the user group associated with this replication group.
     */
    public val removeUserGroups: kotlin.Boolean? = builder.removeUserGroups
    /**
     * A description for the replication group. Maximum length is 255 characters.
     */
    public val replicationGroupDescription: kotlin.String? = builder.replicationGroupDescription
    /**
     * The identifier of the replication group to modify.
     */
    public val replicationGroupId: kotlin.String? = builder.replicationGroupId
    /**
     * Specifies the VPC Security Groups associated with the clusters in the replication group.
     *
     * This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     *
     * **Important** If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
     */
    public val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard) specified by `SnapshottingClusterId`.
     *
     * Example: `05:00-09:00`
     *
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     */
    public val snapshotWindow: kotlin.String? = builder.snapshotWindow
    /**
     * The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set for Valkey or Redis OSS (cluster mode enabled) replication groups.
     */
    public val snapshottingClusterId: kotlin.String? = builder.snapshottingClusterId
    /**
     * A flag that enables in-transit encryption when set to true. If you are enabling in-transit encryption for an existing cluster, you must also set `TransitEncryptionMode` to `preferred`.
     */
    public val transitEncryptionEnabled: kotlin.Boolean? = builder.transitEncryptionEnabled
    /**
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     *
     * You must set `TransitEncryptionEnabled` to `true`, for your existing cluster, and set `TransitEncryptionMode` to `preferred` in the same request to allow both encrypted and unencrypted connections at the same time. Once you migrate all your Valkey or Redis OSS clients to use encrypted connections you can set the value to `required` to allow encrypted connections only.
     *
     * Setting `TransitEncryptionMode` to `required` is a two-step process that requires you to first set the `TransitEncryptionMode` to `preferred`, after that you can set `TransitEncryptionMode` to `required`.
     */
    public val transitEncryptionMode: aws.sdk.kotlin.services.elasticache.model.TransitEncryptionMode? = builder.transitEncryptionMode
    /**
     * The ID of the user group you are associating with the replication group.
     */
    public val userGroupIdsToAdd: List<String>? = builder.userGroupIdsToAdd
    /**
     * The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.
     */
    public val userGroupIdsToRemove: List<String>? = builder.userGroupIdsToRemove

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyReplicationGroupRequest(")
        append("applyImmediately=$applyImmediately,")
        append("authToken=$authToken,")
        append("authTokenUpdateStrategy=$authTokenUpdateStrategy,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("automaticFailoverEnabled=$automaticFailoverEnabled,")
        append("cacheNodeType=$cacheNodeType,")
        append("cacheParameterGroupName=$cacheParameterGroupName,")
        append("cacheSecurityGroupNames=$cacheSecurityGroupNames,")
        append("clusterMode=$clusterMode,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("ipDiscovery=$ipDiscovery,")
        append("logDeliveryConfigurations=$logDeliveryConfigurations,")
        append("multiAzEnabled=$multiAzEnabled,")
        append("nodeGroupId=$nodeGroupId,")
        append("notificationTopicArn=$notificationTopicArn,")
        append("notificationTopicStatus=$notificationTopicStatus,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("primaryClusterId=$primaryClusterId,")
        append("removeUserGroups=$removeUserGroups,")
        append("replicationGroupDescription=$replicationGroupDescription,")
        append("replicationGroupId=$replicationGroupId,")
        append("securityGroupIds=$securityGroupIds,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("snapshotWindow=$snapshotWindow,")
        append("snapshottingClusterId=$snapshottingClusterId,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled,")
        append("transitEncryptionMode=$transitEncryptionMode,")
        append("userGroupIdsToAdd=$userGroupIdsToAdd,")
        append("userGroupIdsToRemove=$userGroupIdsToRemove")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyImmediately?.hashCode() ?: 0
        result = 31 * result + (authToken?.hashCode() ?: 0)
        result = 31 * result + (authTokenUpdateStrategy?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (automaticFailoverEnabled?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeType?.hashCode() ?: 0)
        result = 31 * result + (cacheParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (cacheSecurityGroupNames?.hashCode() ?: 0)
        result = 31 * result + (clusterMode?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (ipDiscovery?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfigurations?.hashCode() ?: 0)
        result = 31 * result + (multiAzEnabled?.hashCode() ?: 0)
        result = 31 * result + (nodeGroupId?.hashCode() ?: 0)
        result = 31 * result + (notificationTopicArn?.hashCode() ?: 0)
        result = 31 * result + (notificationTopicStatus?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (primaryClusterId?.hashCode() ?: 0)
        result = 31 * result + (removeUserGroups?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (snapshotWindow?.hashCode() ?: 0)
        result = 31 * result + (snapshottingClusterId?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionMode?.hashCode() ?: 0)
        result = 31 * result + (userGroupIdsToAdd?.hashCode() ?: 0)
        result = 31 * result + (userGroupIdsToRemove?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyReplicationGroupRequest

        if (applyImmediately != other.applyImmediately) return false
        if (authToken != other.authToken) return false
        if (authTokenUpdateStrategy != other.authTokenUpdateStrategy) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (automaticFailoverEnabled != other.automaticFailoverEnabled) return false
        if (cacheNodeType != other.cacheNodeType) return false
        if (cacheParameterGroupName != other.cacheParameterGroupName) return false
        if (cacheSecurityGroupNames != other.cacheSecurityGroupNames) return false
        if (clusterMode != other.clusterMode) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (ipDiscovery != other.ipDiscovery) return false
        if (logDeliveryConfigurations != other.logDeliveryConfigurations) return false
        if (multiAzEnabled != other.multiAzEnabled) return false
        if (nodeGroupId != other.nodeGroupId) return false
        if (notificationTopicArn != other.notificationTopicArn) return false
        if (notificationTopicStatus != other.notificationTopicStatus) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (primaryClusterId != other.primaryClusterId) return false
        if (removeUserGroups != other.removeUserGroups) return false
        if (replicationGroupDescription != other.replicationGroupDescription) return false
        if (replicationGroupId != other.replicationGroupId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (snapshotWindow != other.snapshotWindow) return false
        if (snapshottingClusterId != other.snapshottingClusterId) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false
        if (transitEncryptionMode != other.transitEncryptionMode) return false
        if (userGroupIdsToAdd != other.userGroupIdsToAdd) return false
        if (userGroupIdsToRemove != other.userGroupIdsToRemove) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If `true`, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the replication group.
         *
         * If `false`, changes to the nodes in the replication group are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.
         *
         * Valid values: `true` | `false`
         *
         * Default: `false`
         */
        public var applyImmediately: kotlin.Boolean? = null
        /**
         * Reserved parameter. The password used to access a password protected server. This parameter must be specified with the `auth-token-update-strategy ` parameter. Password constraints:
         * + Must be only printable ASCII characters
         * + Must be at least 16 characters and no more than 128 characters in length
         * + Cannot contain any of the following characters: '/', '"', or '@', '%'
         *
         *  For more information, see AUTH password at [AUTH](http://redis.io/commands/AUTH).
         */
        public var authToken: kotlin.String? = null
        /**
         * Specifies the strategy to use to update the AUTH token. This parameter must be specified with the `auth-token` parameter. Possible values:
         * + ROTATE - default, if no update strategy is provided
         * + SET - allowed only after ROTATE
         * + DELETE - allowed only when transitioning to RBAC
         *
         *  For more information, see [Authenticating Users with AUTH](http://docs.aws.amazon.com/AmazonElastiCache/latest/dg/auth.html)
         */
        public var authTokenUpdateStrategy: aws.sdk.kotlin.services.elasticache.model.AuthTokenUpdateStrategyType? = null
        /**
         * If you are running Valkey or Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.
         *
         * Valid values: `true` | `false`
         */
        public var automaticFailoverEnabled: kotlin.Boolean? = null
        /**
         * A valid cache node type that you want to scale this replication group to.
         */
        public var cacheNodeType: kotlin.String? = null
        /**
         * The name of the cache parameter group to apply to all of the clusters in this replication group. This change is asynchronously applied as soon as possible for parameters when the `ApplyImmediately` parameter is specified as `true` for this request.
         */
        public var cacheParameterGroupName: kotlin.String? = null
        /**
         * A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.
         *
         * This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).
         *
         * Constraints: Must contain no more than 255 alphanumeric characters. Must not be `Default`.
         */
        public var cacheSecurityGroupNames: List<String>? = null
        /**
         * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to Compatible. Compatible mode allows your Valkey or Redis OSS clients to connect using both cluster mode enabled and cluster mode disabled. After you migrate all Valkey or Redis OSS clients to use cluster mode enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.
         */
        public var clusterMode: aws.sdk.kotlin.services.elasticache.model.ClusterMode? = null
        /**
         * Modifies the engine listed in a replication group message. The options are redis, memcached or valkey.
         */
        public var engine: kotlin.String? = null
        /**
         * The upgraded version of the cache engine to be run on the clusters in the replication group.
         *
         * **Important:** You can upgrade to a newer engine version (see [Selecting a Cache Engine and Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/dg/SelectEngine.html#VersionManagement)), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing replication group and create it anew with the earlier engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The network type you choose when modifying a cluster, either `ipv4` | `ipv6`. IPv6 is supported for workloads using Valkey 7.2 and above, Redis OSS engine version 6.2 to 7.1 and Memcached engine version 1.6.6 and above on all instances built on the [Nitro system](http://aws.amazon.com/ec2/nitro/).
         */
        public var ipDiscovery: aws.sdk.kotlin.services.elasticache.model.IpDiscovery? = null
        /**
         * Specifies the destination, format and type of the logs.
         */
        public var logDeliveryConfigurations: List<LogDeliveryConfigurationRequest>? = null
        /**
         * A flag to indicate MultiAZ is enabled.
         */
        public var multiAzEnabled: kotlin.Boolean? = null
        /**
         * Deprecated. This parameter is not used.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var nodeGroupId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.
         *
         * The Amazon SNS topic owner must be same as the replication group owner.
         */
        public var notificationTopicArn: kotlin.String? = null
        /**
         * The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the status is `active`.
         *
         * Valid values: `active` | `inactive`
         */
        public var notificationTopicStatus: kotlin.String? = null
        /**
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         *
         * Valid values for `ddd` are:
         * + `sun`
         * + `mon`
         * + `tue`
         * + `wed`
         * + `thu`
         * + `fri`
         * + `sat`
         *
         * Example: `sun:23:00-mon:01:30`
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role. The nodes of all other clusters in the replication group are read replicas.
         */
        public var primaryClusterId: kotlin.String? = null
        /**
         * Removes the user group associated with this replication group.
         */
        public var removeUserGroups: kotlin.Boolean? = null
        /**
         * A description for the replication group. Maximum length is 255 characters.
         */
        public var replicationGroupDescription: kotlin.String? = null
        /**
         * The identifier of the replication group to modify.
         */
        public var replicationGroupId: kotlin.String? = null
        /**
         * Specifies the VPC Security Groups associated with the clusters in the replication group.
         *
         * This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private Cloud (Amazon VPC).
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         *
         * **Important** If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
         */
        public var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard) specified by `SnapshottingClusterId`.
         *
         * Example: `05:00-09:00`
         *
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         */
        public var snapshotWindow: kotlin.String? = null
        /**
         * The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set for Valkey or Redis OSS (cluster mode enabled) replication groups.
         */
        public var snapshottingClusterId: kotlin.String? = null
        /**
         * A flag that enables in-transit encryption when set to true. If you are enabling in-transit encryption for an existing cluster, you must also set `TransitEncryptionMode` to `preferred`.
         */
        public var transitEncryptionEnabled: kotlin.Boolean? = null
        /**
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         *
         * You must set `TransitEncryptionEnabled` to `true`, for your existing cluster, and set `TransitEncryptionMode` to `preferred` in the same request to allow both encrypted and unencrypted connections at the same time. Once you migrate all your Valkey or Redis OSS clients to use encrypted connections you can set the value to `required` to allow encrypted connections only.
         *
         * Setting `TransitEncryptionMode` to `required` is a two-step process that requires you to first set the `TransitEncryptionMode` to `preferred`, after that you can set `TransitEncryptionMode` to `required`.
         */
        public var transitEncryptionMode: aws.sdk.kotlin.services.elasticache.model.TransitEncryptionMode? = null
        /**
         * The ID of the user group you are associating with the replication group.
         */
        public var userGroupIdsToAdd: List<String>? = null
        /**
         * The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.
         */
        public var userGroupIdsToRemove: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupRequest) : this() {
            this.applyImmediately = x.applyImmediately
            this.authToken = x.authToken
            this.authTokenUpdateStrategy = x.authTokenUpdateStrategy
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.automaticFailoverEnabled = x.automaticFailoverEnabled
            this.cacheNodeType = x.cacheNodeType
            this.cacheParameterGroupName = x.cacheParameterGroupName
            this.cacheSecurityGroupNames = x.cacheSecurityGroupNames
            this.clusterMode = x.clusterMode
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.ipDiscovery = x.ipDiscovery
            this.logDeliveryConfigurations = x.logDeliveryConfigurations
            this.multiAzEnabled = x.multiAzEnabled
            this.nodeGroupId = x.nodeGroupId
            this.notificationTopicArn = x.notificationTopicArn
            this.notificationTopicStatus = x.notificationTopicStatus
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.primaryClusterId = x.primaryClusterId
            this.removeUserGroups = x.removeUserGroups
            this.replicationGroupDescription = x.replicationGroupDescription
            this.replicationGroupId = x.replicationGroupId
            this.securityGroupIds = x.securityGroupIds
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.snapshotWindow = x.snapshotWindow
            this.snapshottingClusterId = x.snapshottingClusterId
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
            this.transitEncryptionMode = x.transitEncryptionMode
            this.userGroupIdsToAdd = x.userGroupIdsToAdd
            this.userGroupIdsToRemove = x.userGroupIdsToRemove
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupRequest = ModifyReplicationGroupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
