// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateServerlessCacheRequest private constructor(builder: Builder) {
    /**
     * Sets the cache usage limits for storage and ElastiCache Processing Units for the cache.
     */
    public val cacheUsageLimits: aws.sdk.kotlin.services.elasticache.model.CacheUsageLimits? = builder.cacheUsageLimits
    /**
     * The daily time that snapshots will be created from the new serverless cache. By default this number is populated with 0, i.e. no snapshots will be created on an automatic daily basis. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val dailySnapshotTime: kotlin.String? = builder.dailySnapshotTime
    /**
     * User-provided description for the serverless cache. The default is NULL, i.e. if no description is provided then an empty string will be returned. The maximum length is 255 characters.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the cache engine to be used for creating the serverless cache.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The version of the cache engine that will be used to create the serverless cache.
     */
    public val majorEngineVersion: kotlin.String? = builder.majorEngineVersion
    /**
     * A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * User-provided identifier for the serverless cache. This parameter is stored as a lowercase string.
     */
    public val serverlessCacheName: kotlin.String? = builder.serverlessCacheName
    /**
     * The ARN(s) of the snapshot that the new serverless cache will be created from. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val snapshotArnsToRestore: List<String>? = builder.snapshotArnsToRestore
    /**
     * The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The list of tags (key, value) pairs to be added to the serverless cache resource. Default is NULL.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The identifier of the UserGroup to be associated with the serverless cache. Available for Valkey and Redis OSS only. Default is NULL.
     */
    public val userGroupId: kotlin.String? = builder.userGroupId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.CreateServerlessCacheRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServerlessCacheRequest(")
        append("cacheUsageLimits=$cacheUsageLimits,")
        append("dailySnapshotTime=$dailySnapshotTime,")
        append("description=$description,")
        append("engine=$engine,")
        append("kmsKeyId=$kmsKeyId,")
        append("majorEngineVersion=$majorEngineVersion,")
        append("securityGroupIds=$securityGroupIds,")
        append("serverlessCacheName=$serverlessCacheName,")
        append("snapshotArnsToRestore=$snapshotArnsToRestore,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("userGroupId=$userGroupId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheUsageLimits?.hashCode() ?: 0
        result = 31 * result + (dailySnapshotTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (majorEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (serverlessCacheName?.hashCode() ?: 0)
        result = 31 * result + (snapshotArnsToRestore?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userGroupId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServerlessCacheRequest

        if (cacheUsageLimits != other.cacheUsageLimits) return false
        if (dailySnapshotTime != other.dailySnapshotTime) return false
        if (description != other.description) return false
        if (engine != other.engine) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (majorEngineVersion != other.majorEngineVersion) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (serverlessCacheName != other.serverlessCacheName) return false
        if (snapshotArnsToRestore != other.snapshotArnsToRestore) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (userGroupId != other.userGroupId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.CreateServerlessCacheRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Sets the cache usage limits for storage and ElastiCache Processing Units for the cache.
         */
        public var cacheUsageLimits: aws.sdk.kotlin.services.elasticache.model.CacheUsageLimits? = null
        /**
         * The daily time that snapshots will be created from the new serverless cache. By default this number is populated with 0, i.e. no snapshots will be created on an automatic daily basis. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var dailySnapshotTime: kotlin.String? = null
        /**
         * User-provided description for the serverless cache. The default is NULL, i.e. if no description is provided then an empty string will be returned. The maximum length is 255 characters.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the cache engine to be used for creating the serverless cache.
         */
        public var engine: kotlin.String? = null
        /**
         * ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The version of the cache engine that will be used to create the serverless cache.
         */
        public var majorEngineVersion: kotlin.String? = null
        /**
         * A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * User-provided identifier for the serverless cache. This parameter is stored as a lowercase string.
         */
        public var serverlessCacheName: kotlin.String? = null
        /**
         * The ARN(s) of the snapshot that the new serverless cache will be created from. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var snapshotArnsToRestore: List<String>? = null
        /**
         * The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
         */
        public var subnetIds: List<String>? = null
        /**
         * The list of tags (key, value) pairs to be added to the serverless cache resource. Default is NULL.
         */
        public var tags: List<Tag>? = null
        /**
         * The identifier of the UserGroup to be associated with the serverless cache. Available for Valkey and Redis OSS only. Default is NULL.
         */
        public var userGroupId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.CreateServerlessCacheRequest) : this() {
            this.cacheUsageLimits = x.cacheUsageLimits
            this.dailySnapshotTime = x.dailySnapshotTime
            this.description = x.description
            this.engine = x.engine
            this.kmsKeyId = x.kmsKeyId
            this.majorEngineVersion = x.majorEngineVersion
            this.securityGroupIds = x.securityGroupIds
            this.serverlessCacheName = x.serverlessCacheName
            this.snapshotArnsToRestore = x.snapshotArnsToRestore
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.userGroupId = x.userGroupId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.CreateServerlessCacheRequest = CreateServerlessCacheRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.CacheUsageLimits] inside the given [block]
         */
        public fun cacheUsageLimits(block: aws.sdk.kotlin.services.elasticache.model.CacheUsageLimits.Builder.() -> kotlin.Unit) {
            this.cacheUsageLimits = aws.sdk.kotlin.services.elasticache.model.CacheUsageLimits.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
