/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.elasticache.serde;

import aws.sdk.kotlin.services.elasticache.model.DecreaseReplicaCountResponse;
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException;
import aws.sdk.kotlin.services.elasticache.serde.AwsQueryUtilKt;
import aws.sdk.kotlin.services.elasticache.serde.ClusterQuotaForCustomerExceededFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InsufficientCacheClusterCapacityFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidCacheClusterStateFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidParameterCombinationExceptionDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidParameterValueExceptionDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidReplicationGroupStateFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidVpcNetworkStateFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.NoOperationFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.NodeGroupsPerReplicationGroupQuotaExceededFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.NodeQuotaForCustomerExceededFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.ReplicationGroupDocumentDeserializerKt;
import aws.sdk.kotlin.services.elasticache.serde.ReplicationGroupNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.ServiceLinkedRoleNotFoundFaultDeserializer;
import aws.smithy.kotlin.runtime.awsprotocol.AwsErrorDetails;
import aws.smithy.kotlin.runtime.awsprotocol.ProtocolErrorsKt;
import aws.smithy.kotlin.runtime.awsprotocol.ResponseUtilsKt;
import aws.smithy.kotlin.runtime.awsprotocol.xml.RestXmlErrorDeserializerKt;
import aws.smithy.kotlin.runtime.http.HttpCall;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"throwDecreaseReplicaCountError", "", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "call", "Laws/smithy/kotlin/runtime/http/HttpCall;", "payload", "", "deserializeDecreaseReplicaCountOperationBody", "", "builder", "Laws/sdk/kotlin/services/elasticache/model/DecreaseReplicaCountResponse$Builder;", "elasticache"})
@SourceDebugExtension(value={"SMAP\nDecreaseReplicaCountOperationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecreaseReplicaCountOperationDeserializer.kt\naws/sdk/kotlin/services/elasticache/serde/DecreaseReplicaCountOperationDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class DecreaseReplicaCountOperationDeserializerKt {
    /*
     * Unable to fully structure code
     */
    private static final Void throwDecreaseReplicaCountError(ExecutionContext context, HttpCall call, byte[] payload) {
        wrappedResponse = ResponseUtilsKt.withPayload((HttpResponse)call.getResponse(), (byte[])payload);
        wrappedCall = HttpCall.copy$default((HttpCall)call, null, (HttpResponse)wrappedResponse, (int)1, null);
        try {
            v0 = payload;
            if (payload == null) {
                $i$a$-checkNotNull-DecreaseReplicaCountOperationDeserializerKt$throwDecreaseReplicaCountError$errorDetails$1 = false;
                $i$a$-checkNotNull-DecreaseReplicaCountOperationDeserializerKt$throwDecreaseReplicaCountError$errorDetails$1 = "unable to parse error from empty response";
                throw new IllegalStateException($i$a$-checkNotNull-DecreaseReplicaCountOperationDeserializerKt$throwDecreaseReplicaCountError$errorDetails$1.toString());
            }
            $i$a$-checkNotNull-DecreaseReplicaCountOperationDeserializerKt$throwDecreaseReplicaCountError$errorDetails$1 = RestXmlErrorDeserializerKt.parseRestXmlErrorResponseNoSuspend((byte[])payload);
        }
        catch (Exception ex) {
            it = var8_10 = new ElastiCacheException("Failed to parse response as 'awsQuery' error", ex);
            $i$a$-also-DecreaseReplicaCountOperationDeserializerKt$throwDecreaseReplicaCountError$errorDetails$2 = false;
            ProtocolErrorsKt.setAseErrorMetadata((Object)it, (HttpResponse)wrappedCall.getResponse(), null);
            throw (Throwable)var8_10;
        }
        errorDetails = $i$a$-checkNotNull-DecreaseReplicaCountOperationDeserializerKt$throwDecreaseReplicaCountError$errorDetails$1;
        var7_9 = errorDetails.getCode();
        if (var7_9 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var7_9.hashCode()) {
            case 833027812: {
                if (var7_9.equals("NodeQuotaForCustomerExceeded")) {
                    tmp = 1;
                }
                break;
            }
            case 1671677824: {
                if (var7_9.equals("ReplicationGroupNotFoundFault")) {
                    tmp = 2;
                }
                break;
            }
            case 1219607989: {
                if (var7_9.equals("InsufficientCacheClusterCapacity")) {
                    tmp = 3;
                }
                break;
            }
            case 1054393197: {
                if (var7_9.equals("InvalidVPCNetworkStateFault")) {
                    tmp = 4;
                }
                break;
            }
            case 503919932: {
                if (var7_9.equals("NoOperationFault")) {
                    tmp = 5;
                }
                break;
            }
            case -315307727: {
                if (var7_9.equals("NodeGroupsPerReplicationGroupQuotaExceeded")) {
                    tmp = 6;
                }
                break;
            }
            case -133634083: {
                if (var7_9.equals("InvalidParameterCombination")) {
                    tmp = 7;
                }
                break;
            }
            case -233152849: {
                if (var7_9.equals("ServiceLinkedRoleNotFoundFault")) {
                    tmp = 8;
                }
                break;
            }
            case 1582661186: {
                if (var7_9.equals("InvalidCacheClusterState")) {
                    tmp = 9;
                }
                break;
            }
            case 2020592807: {
                if (var7_9.equals("InvalidReplicationGroupState")) {
                    tmp = 10;
                }
                break;
            }
            case 343384319: {
                if (var7_9.equals("InvalidParameterValue")) {
                    tmp = 11;
                }
                break;
            }
            case 2047336092: {
                if (var7_9.equals("ClusterQuotaForCustomerExceeded")) {
                    tmp = 12;
                }
                break;
            }
        }
        switch (tmp) {
            case 4: {
                v1 = new InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 5: {
                v1 = new NoOperationFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 9: {
                v1 = new InvalidCacheClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 6: {
                v1 = new NodeGroupsPerReplicationGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 1: {
                v1 = new NodeQuotaForCustomerExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 10: {
                v1 = new InvalidReplicationGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 11: {
                v1 = new InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 12: {
                v1 = new ClusterQuotaForCustomerExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 3: {
                v1 = new InsufficientCacheClusterCapacityFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 7: {
                v1 = new InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 2: {
                v1 = new ReplicationGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 8: {
                v1 = new ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = new ElastiCacheException(errorDetails.getMessage());
            }
        }
        ex = v1;
        ProtocolErrorsKt.setAseErrorMetadata((Object)ex, (HttpResponse)wrappedResponse, (AwsErrorDetails)((AwsErrorDetails)errorDetails));
        throw ex;
    }

    private static final void deserializeDecreaseReplicaCountOperationBody(DecreaseReplicaCountResponse.Builder builder, byte[] payload) {
        XmlTagReader root = XmlTagReaderKt.xmlTagReader((byte[])payload);
        XmlTagReader unwrapped = AwsQueryUtilKt.unwrapAwsQueryResponse(root, "DecreaseReplicaCount");
        while (unwrapped.nextTag() != null) {
            XmlTagReader curr;
            if (Intrinsics.areEqual((Object)curr.getTagName(), (Object)"ReplicationGroup")) {
                builder.setReplicationGroup(ReplicationGroupDocumentDeserializerKt.deserializeReplicationGroupDocument(curr));
            }
            curr.drop();
        }
    }

    public static final /* synthetic */ Void access$throwDecreaseReplicaCountError(ExecutionContext context, HttpCall call, byte[] payload) {
        return DecreaseReplicaCountOperationDeserializerKt.throwDecreaseReplicaCountError(context, call, payload);
    }

    public static final /* synthetic */ void access$deserializeDecreaseReplicaCountOperationBody(DecreaseReplicaCountResponse.Builder builder, byte[] payload) {
        DecreaseReplicaCountOperationDeserializerKt.deserializeDecreaseReplicaCountOperationBody(builder, payload);
    }
}

