/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.elasticache.serde;

import aws.sdk.kotlin.services.elasticache.model.CreateServerlessCacheResponse;
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException;
import aws.sdk.kotlin.services.elasticache.serde.AwsQueryUtilKt;
import aws.sdk.kotlin.services.elasticache.serde.InvalidCredentialsExceptionDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidParameterCombinationExceptionDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidParameterValueExceptionDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidServerlessCacheStateFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidUserGroupStateFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.ServerlessCacheAlreadyExistsFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.ServerlessCacheDocumentDeserializerKt;
import aws.sdk.kotlin.services.elasticache.serde.ServerlessCacheNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.ServerlessCacheQuotaForCustomerExceededFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.ServiceLinkedRoleNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.TagQuotaPerResourceExceededDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.UserGroupNotFoundFaultDeserializer;
import aws.smithy.kotlin.runtime.awsprotocol.AwsErrorDetails;
import aws.smithy.kotlin.runtime.awsprotocol.ProtocolErrorsKt;
import aws.smithy.kotlin.runtime.awsprotocol.ResponseUtilsKt;
import aws.smithy.kotlin.runtime.awsprotocol.xml.RestXmlErrorDeserializerKt;
import aws.smithy.kotlin.runtime.http.HttpCall;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"throwCreateServerlessCacheError", "", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "call", "Laws/smithy/kotlin/runtime/http/HttpCall;", "payload", "", "deserializeCreateServerlessCacheOperationBody", "", "builder", "Laws/sdk/kotlin/services/elasticache/model/CreateServerlessCacheResponse$Builder;", "elasticache"})
@SourceDebugExtension(value={"SMAP\nCreateServerlessCacheOperationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateServerlessCacheOperationDeserializer.kt\naws/sdk/kotlin/services/elasticache/serde/CreateServerlessCacheOperationDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class CreateServerlessCacheOperationDeserializerKt {
    /*
     * Unable to fully structure code
     */
    private static final Void throwCreateServerlessCacheError(ExecutionContext context, HttpCall call, byte[] payload) {
        wrappedResponse = ResponseUtilsKt.withPayload((HttpResponse)call.getResponse(), (byte[])payload);
        wrappedCall = HttpCall.copy$default((HttpCall)call, null, (HttpResponse)wrappedResponse, (int)1, null);
        try {
            v0 = payload;
            if (payload == null) {
                $i$a$-checkNotNull-CreateServerlessCacheOperationDeserializerKt$throwCreateServerlessCacheError$errorDetails$1 = false;
                $i$a$-checkNotNull-CreateServerlessCacheOperationDeserializerKt$throwCreateServerlessCacheError$errorDetails$1 = "unable to parse error from empty response";
                throw new IllegalStateException($i$a$-checkNotNull-CreateServerlessCacheOperationDeserializerKt$throwCreateServerlessCacheError$errorDetails$1.toString());
            }
            $i$a$-checkNotNull-CreateServerlessCacheOperationDeserializerKt$throwCreateServerlessCacheError$errorDetails$1 = RestXmlErrorDeserializerKt.parseRestXmlErrorResponseNoSuspend((byte[])payload);
        }
        catch (Exception ex) {
            it = var8_10 = new ElastiCacheException("Failed to parse response as 'awsQuery' error", ex);
            $i$a$-also-CreateServerlessCacheOperationDeserializerKt$throwCreateServerlessCacheError$errorDetails$2 = false;
            ProtocolErrorsKt.setAseErrorMetadata((Object)it, (HttpResponse)wrappedCall.getResponse(), null);
            throw (Throwable)var8_10;
        }
        errorDetails = $i$a$-checkNotNull-CreateServerlessCacheOperationDeserializerKt$throwCreateServerlessCacheError$errorDetails$1;
        var7_9 = errorDetails.getCode();
        if (var7_9 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var7_9.hashCode()) {
            case 1201657130: {
                if (var7_9.equals("InvalidCredentialsException")) {
                    tmp = 1;
                }
                break;
            }
            case -133634083: {
                if (var7_9.equals("InvalidParameterCombination")) {
                    tmp = 2;
                }
                break;
            }
            case -233152849: {
                if (var7_9.equals("ServiceLinkedRoleNotFoundFault")) {
                    tmp = 3;
                }
                break;
            }
            case 1244835124: {
                if (var7_9.equals("InvalidUserGroupState")) {
                    tmp = 4;
                }
                break;
            }
            case 343384319: {
                if (var7_9.equals("InvalidParameterValue")) {
                    tmp = 5;
                }
                break;
            }
            case -1928844256: {
                if (var7_9.equals("InvalidServerlessCacheStateFault")) {
                    tmp = 6;
                }
                break;
            }
            case 88332506: {
                if (var7_9.equals("ServerlessCacheQuotaForCustomerExceededFault")) {
                    tmp = 7;
                }
                break;
            }
            case -901961804: {
                if (var7_9.equals("ServerlessCacheAlreadyExistsFault")) {
                    tmp = 8;
                }
                break;
            }
            case 735017443: {
                if (var7_9.equals("UserGroupNotFound")) {
                    tmp = 9;
                }
                break;
            }
            case 1626364717: {
                if (var7_9.equals("ServerlessCacheNotFoundFault")) {
                    tmp = 10;
                }
                break;
            }
            case -1139888960: {
                if (var7_9.equals("TagQuotaPerResourceExceeded")) {
                    tmp = 11;
                }
                break;
            }
        }
        switch (tmp) {
            case 5: {
                v1 = new InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 10: {
                v1 = new ServerlessCacheNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 7: {
                v1 = new ServerlessCacheQuotaForCustomerExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 6: {
                v1 = new InvalidServerlessCacheStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 11: {
                v1 = new TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 1: {
                v1 = new InvalidCredentialsExceptionDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 8: {
                v1 = new ServerlessCacheAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 2: {
                v1 = new InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 4: {
                v1 = new InvalidUserGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 3: {
                v1 = new ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 9: {
                v1 = new UserGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = new ElastiCacheException(errorDetails.getMessage());
            }
        }
        ex = v1;
        ProtocolErrorsKt.setAseErrorMetadata((Object)ex, (HttpResponse)wrappedResponse, (AwsErrorDetails)((AwsErrorDetails)errorDetails));
        throw ex;
    }

    private static final void deserializeCreateServerlessCacheOperationBody(CreateServerlessCacheResponse.Builder builder, byte[] payload) {
        XmlTagReader root = XmlTagReaderKt.xmlTagReader((byte[])payload);
        XmlTagReader unwrapped = AwsQueryUtilKt.unwrapAwsQueryResponse(root, "CreateServerlessCache");
        while (unwrapped.nextTag() != null) {
            XmlTagReader curr;
            if (Intrinsics.areEqual((Object)curr.getTagName(), (Object)"ServerlessCache")) {
                builder.setServerlessCache(ServerlessCacheDocumentDeserializerKt.deserializeServerlessCacheDocument(curr));
            }
            curr.drop();
        }
    }

    public static final /* synthetic */ Void access$throwCreateServerlessCacheError(ExecutionContext context, HttpCall call, byte[] payload) {
        return CreateServerlessCacheOperationDeserializerKt.throwCreateServerlessCacheError(context, call, payload);
    }

    public static final /* synthetic */ void access$deserializeCreateServerlessCacheOperationBody(CreateServerlessCacheResponse.Builder builder, byte[] payload) {
        CreateServerlessCacheOperationDeserializerKt.deserializeCreateServerlessCacheOperationBody(builder, payload);
    }
}

