/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.elasticache.serde;

import aws.sdk.kotlin.services.elasticache.model.CreateReplicationGroupResponse;
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException;
import aws.sdk.kotlin.services.elasticache.serde.AwsQueryUtilKt;
import aws.sdk.kotlin.services.elasticache.serde.CacheClusterNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.CacheParameterGroupNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.CacheSecurityGroupNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.CacheSubnetGroupNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.ClusterQuotaForCustomerExceededFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.GlobalReplicationGroupNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InsufficientCacheClusterCapacityFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidCacheClusterStateFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidGlobalReplicationGroupStateFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidParameterCombinationExceptionDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidParameterValueExceptionDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidUserGroupStateFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidVpcNetworkStateFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.NodeGroupsPerReplicationGroupQuotaExceededFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.NodeQuotaForClusterExceededFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.NodeQuotaForCustomerExceededFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.ReplicationGroupAlreadyExistsFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.ReplicationGroupDocumentDeserializerKt;
import aws.sdk.kotlin.services.elasticache.serde.TagQuotaPerResourceExceededDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.UserGroupNotFoundFaultDeserializer;
import aws.smithy.kotlin.runtime.awsprotocol.AwsErrorDetails;
import aws.smithy.kotlin.runtime.awsprotocol.ProtocolErrorsKt;
import aws.smithy.kotlin.runtime.awsprotocol.ResponseUtilsKt;
import aws.smithy.kotlin.runtime.awsprotocol.xml.RestXmlErrorDeserializerKt;
import aws.smithy.kotlin.runtime.http.HttpCall;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"throwCreateReplicationGroupError", "", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "call", "Laws/smithy/kotlin/runtime/http/HttpCall;", "payload", "", "deserializeCreateReplicationGroupOperationBody", "", "builder", "Laws/sdk/kotlin/services/elasticache/model/CreateReplicationGroupResponse$Builder;", "elasticache"})
@SourceDebugExtension(value={"SMAP\nCreateReplicationGroupOperationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateReplicationGroupOperationDeserializer.kt\naws/sdk/kotlin/services/elasticache/serde/CreateReplicationGroupOperationDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class CreateReplicationGroupOperationDeserializerKt {
    /*
     * Unable to fully structure code
     */
    private static final Void throwCreateReplicationGroupError(ExecutionContext context, HttpCall call, byte[] payload) {
        wrappedResponse = ResponseUtilsKt.withPayload((HttpResponse)call.getResponse(), (byte[])payload);
        wrappedCall = HttpCall.copy$default((HttpCall)call, null, (HttpResponse)wrappedResponse, (int)1, null);
        try {
            v0 = payload;
            if (payload == null) {
                $i$a$-checkNotNull-CreateReplicationGroupOperationDeserializerKt$throwCreateReplicationGroupError$errorDetails$1 = false;
                $i$a$-checkNotNull-CreateReplicationGroupOperationDeserializerKt$throwCreateReplicationGroupError$errorDetails$1 = "unable to parse error from empty response";
                throw new IllegalStateException($i$a$-checkNotNull-CreateReplicationGroupOperationDeserializerKt$throwCreateReplicationGroupError$errorDetails$1.toString());
            }
            $i$a$-checkNotNull-CreateReplicationGroupOperationDeserializerKt$throwCreateReplicationGroupError$errorDetails$1 = RestXmlErrorDeserializerKt.parseRestXmlErrorResponseNoSuspend((byte[])payload);
        }
        catch (Exception ex) {
            it = var8_10 = new ElastiCacheException("Failed to parse response as 'awsQuery' error", ex);
            $i$a$-also-CreateReplicationGroupOperationDeserializerKt$throwCreateReplicationGroupError$errorDetails$2 = false;
            ProtocolErrorsKt.setAseErrorMetadata((Object)it, (HttpResponse)wrappedCall.getResponse(), null);
            throw (Throwable)var8_10;
        }
        errorDetails = $i$a$-checkNotNull-CreateReplicationGroupOperationDeserializerKt$throwCreateReplicationGroupError$errorDetails$1;
        var7_9 = errorDetails.getCode();
        if (var7_9 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var7_9.hashCode()) {
            case 833027812: {
                if (var7_9.equals("NodeQuotaForCustomerExceeded")) {
                    tmp = 1;
                }
                break;
            }
            case 1219607989: {
                if (var7_9.equals("InsufficientCacheClusterCapacity")) {
                    tmp = 2;
                }
                break;
            }
            case -315307727: {
                if (var7_9.equals("NodeGroupsPerReplicationGroupQuotaExceeded")) {
                    tmp = 3;
                }
                break;
            }
            case 1811704698: {
                if (var7_9.equals("NodeQuotaForClusterExceeded")) {
                    tmp = 4;
                }
                break;
            }
            case -831156621: {
                if (var7_9.equals("CacheSubnetGroupNotFoundFault")) {
                    tmp = 5;
                }
                break;
            }
            case 1244835124: {
                if (var7_9.equals("InvalidUserGroupState")) {
                    tmp = 6;
                }
                break;
            }
            case 343384319: {
                if (var7_9.equals("InvalidParameterValue")) {
                    tmp = 7;
                }
                break;
            }
            case 636322023: {
                if (var7_9.equals("CacheParameterGroupNotFound")) {
                    tmp = 8;
                }
                break;
            }
            case -1690897763: {
                if (var7_9.equals("GlobalReplicationGroupNotFoundFault")) {
                    tmp = 9;
                }
                break;
            }
            case 735017443: {
                if (var7_9.equals("UserGroupNotFound")) {
                    tmp = 10;
                }
                break;
            }
            case -1012229628: {
                if (var7_9.equals("InvalidGlobalReplicationGroupState")) {
                    tmp = 11;
                }
                break;
            }
            case -1139888960: {
                if (var7_9.equals("TagQuotaPerResourceExceeded")) {
                    tmp = 12;
                }
                break;
            }
            case -1391245471: {
                if (var7_9.equals("ReplicationGroupAlreadyExists")) {
                    tmp = 13;
                }
                break;
            }
            case -652956473: {
                if (var7_9.equals("CacheClusterNotFound")) {
                    tmp = 14;
                }
                break;
            }
            case 1054393197: {
                if (var7_9.equals("InvalidVPCNetworkStateFault")) {
                    tmp = 15;
                }
                break;
            }
            case 100210284: {
                if (var7_9.equals("CacheSecurityGroupNotFound")) {
                    tmp = 16;
                }
                break;
            }
            case -133634083: {
                if (var7_9.equals("InvalidParameterCombination")) {
                    tmp = 17;
                }
                break;
            }
            case 1582661186: {
                if (var7_9.equals("InvalidCacheClusterState")) {
                    tmp = 18;
                }
                break;
            }
            case 2047336092: {
                if (var7_9.equals("ClusterQuotaForCustomerExceeded")) {
                    tmp = 19;
                }
                break;
            }
        }
        switch (tmp) {
            case 15: {
                v1 = new InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 16: {
                v1 = new CacheSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 14: {
                v1 = new CacheClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 18: {
                v1 = new InvalidCacheClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 3: {
                v1 = new NodeGroupsPerReplicationGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 4: {
                v1 = new NodeQuotaForClusterExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 1: {
                v1 = new NodeQuotaForCustomerExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 5: {
                v1 = new CacheSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 10: {
                v1 = new UserGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 7: {
                v1 = new InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 9: {
                v1 = new GlobalReplicationGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 11: {
                v1 = new InvalidGlobalReplicationGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 8: {
                v1 = new CacheParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 12: {
                v1 = new TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 19: {
                v1 = new ClusterQuotaForCustomerExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 13: {
                v1 = new ReplicationGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 2: {
                v1 = new InsufficientCacheClusterCapacityFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 17: {
                v1 = new InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 6: {
                v1 = new InvalidUserGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = new ElastiCacheException(errorDetails.getMessage());
            }
        }
        ex = v1;
        ProtocolErrorsKt.setAseErrorMetadata((Object)ex, (HttpResponse)wrappedResponse, (AwsErrorDetails)((AwsErrorDetails)errorDetails));
        throw ex;
    }

    private static final void deserializeCreateReplicationGroupOperationBody(CreateReplicationGroupResponse.Builder builder, byte[] payload) {
        XmlTagReader root = XmlTagReaderKt.xmlTagReader((byte[])payload);
        XmlTagReader unwrapped = AwsQueryUtilKt.unwrapAwsQueryResponse(root, "CreateReplicationGroup");
        while (unwrapped.nextTag() != null) {
            XmlTagReader curr;
            if (Intrinsics.areEqual((Object)curr.getTagName(), (Object)"ReplicationGroup")) {
                builder.setReplicationGroup(ReplicationGroupDocumentDeserializerKt.deserializeReplicationGroupDocument(curr));
            }
            curr.drop();
        }
    }

    public static final /* synthetic */ Void access$throwCreateReplicationGroupError(ExecutionContext context, HttpCall call, byte[] payload) {
        return CreateReplicationGroupOperationDeserializerKt.throwCreateReplicationGroupError(context, call, payload);
    }

    public static final /* synthetic */ void access$deserializeCreateReplicationGroupOperationBody(CreateReplicationGroupResponse.Builder builder, byte[] payload) {
        CreateReplicationGroupOperationDeserializerKt.deserializeCreateReplicationGroupOperationBody(builder, payload);
    }
}

