/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.elasticache.serde;

import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException;
import aws.sdk.kotlin.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse;
import aws.sdk.kotlin.services.elasticache.serde.AuthorizationNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.AwsQueryUtilKt;
import aws.sdk.kotlin.services.elasticache.serde.CacheSecurityGroupDocumentDeserializerKt;
import aws.sdk.kotlin.services.elasticache.serde.CacheSecurityGroupNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidCacheSecurityGroupStateFaultDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidParameterCombinationExceptionDeserializer;
import aws.sdk.kotlin.services.elasticache.serde.InvalidParameterValueExceptionDeserializer;
import aws.smithy.kotlin.runtime.awsprotocol.AwsErrorDetails;
import aws.smithy.kotlin.runtime.awsprotocol.ProtocolErrorsKt;
import aws.smithy.kotlin.runtime.awsprotocol.ResponseUtilsKt;
import aws.smithy.kotlin.runtime.awsprotocol.xml.RestXmlErrorDeserializerKt;
import aws.smithy.kotlin.runtime.http.HttpCall;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"throwRevokeCacheSecurityGroupIngressError", "", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "call", "Laws/smithy/kotlin/runtime/http/HttpCall;", "payload", "", "deserializeRevokeCacheSecurityGroupIngressOperationBody", "", "builder", "Laws/sdk/kotlin/services/elasticache/model/RevokeCacheSecurityGroupIngressResponse$Builder;", "elasticache"})
@SourceDebugExtension(value={"SMAP\nRevokeCacheSecurityGroupIngressOperationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RevokeCacheSecurityGroupIngressOperationDeserializer.kt\naws/sdk/kotlin/services/elasticache/serde/RevokeCacheSecurityGroupIngressOperationDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class RevokeCacheSecurityGroupIngressOperationDeserializerKt {
    /*
     * Unable to fully structure code
     */
    private static final Void throwRevokeCacheSecurityGroupIngressError(ExecutionContext context, HttpCall call, byte[] payload) {
        wrappedResponse = ResponseUtilsKt.withPayload((HttpResponse)call.getResponse(), (byte[])payload);
        wrappedCall = HttpCall.copy$default((HttpCall)call, null, (HttpResponse)wrappedResponse, (int)1, null);
        try {
            v0 = payload;
            if (payload == null) {
                $i$a$-checkNotNull-RevokeCacheSecurityGroupIngressOperationDeserializerKt$throwRevokeCacheSecurityGroupIngressError$errorDetails$1 = false;
                $i$a$-checkNotNull-RevokeCacheSecurityGroupIngressOperationDeserializerKt$throwRevokeCacheSecurityGroupIngressError$errorDetails$1 = "unable to parse error from empty response";
                throw new IllegalStateException($i$a$-checkNotNull-RevokeCacheSecurityGroupIngressOperationDeserializerKt$throwRevokeCacheSecurityGroupIngressError$errorDetails$1.toString());
            }
            $i$a$-checkNotNull-RevokeCacheSecurityGroupIngressOperationDeserializerKt$throwRevokeCacheSecurityGroupIngressError$errorDetails$1 = RestXmlErrorDeserializerKt.parseRestXmlErrorResponseNoSuspend((byte[])payload);
        }
        catch (Exception ex) {
            it = var8_10 = new ElastiCacheException("Failed to parse response as 'awsQuery' error", ex);
            $i$a$-also-RevokeCacheSecurityGroupIngressOperationDeserializerKt$throwRevokeCacheSecurityGroupIngressError$errorDetails$2 = false;
            ProtocolErrorsKt.setAseErrorMetadata((Object)it, (HttpResponse)wrappedCall.getResponse(), null);
            throw (Throwable)var8_10;
        }
        errorDetails = $i$a$-checkNotNull-RevokeCacheSecurityGroupIngressOperationDeserializerKt$throwRevokeCacheSecurityGroupIngressError$errorDetails$1;
        var7_9 = errorDetails.getCode();
        if (var7_9 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var7_9.hashCode()) {
            case 100210284: {
                if (var7_9.equals("CacheSecurityGroupNotFound")) {
                    tmp = 1;
                }
                break;
            }
            case -133634083: {
                if (var7_9.equals("InvalidParameterCombination")) {
                    tmp = 2;
                }
                break;
            }
            case 343384319: {
                if (var7_9.equals("InvalidParameterValue")) {
                    tmp = 3;
                }
                break;
            }
            case 2100679677: {
                if (var7_9.equals("InvalidCacheSecurityGroupState")) {
                    tmp = 4;
                }
                break;
            }
            case -147598360: {
                if (var7_9.equals("AuthorizationNotFound")) {
                    tmp = 5;
                }
                break;
            }
        }
        switch (tmp) {
            case 3: {
                v1 = new InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 1: {
                v1 = new CacheSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 4: {
                v1 = new InvalidCacheSecurityGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 5: {
                v1 = new AuthorizationNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 2: {
                v1 = new InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = new ElastiCacheException(errorDetails.getMessage());
            }
        }
        ex = v1;
        ProtocolErrorsKt.setAseErrorMetadata((Object)ex, (HttpResponse)wrappedResponse, (AwsErrorDetails)((AwsErrorDetails)errorDetails));
        throw ex;
    }

    private static final void deserializeRevokeCacheSecurityGroupIngressOperationBody(RevokeCacheSecurityGroupIngressResponse.Builder builder, byte[] payload) {
        XmlTagReader root = XmlTagReaderKt.xmlTagReader((byte[])payload);
        XmlTagReader unwrapped = AwsQueryUtilKt.unwrapAwsQueryResponse(root, "RevokeCacheSecurityGroupIngress");
        while (unwrapped.nextTag() != null) {
            XmlTagReader curr;
            if (Intrinsics.areEqual((Object)curr.getTagName(), (Object)"CacheSecurityGroup")) {
                builder.setCacheSecurityGroup(CacheSecurityGroupDocumentDeserializerKt.deserializeCacheSecurityGroupDocument(curr));
            }
            curr.drop();
        }
    }

    public static final /* synthetic */ Void access$throwRevokeCacheSecurityGroupIngressError(ExecutionContext context, HttpCall call, byte[] payload) {
        return RevokeCacheSecurityGroupIngressOperationDeserializerKt.throwRevokeCacheSecurityGroupIngressError(context, call, payload);
    }

    public static final /* synthetic */ void access$deserializeRevokeCacheSecurityGroupIngressOperationBody(RevokeCacheSecurityGroupIngressResponse.Builder builder, byte[] payload) {
        RevokeCacheSecurityGroupIngressOperationDeserializerKt.deserializeRevokeCacheSecurityGroupIngressOperationBody(builder, payload);
    }
}

