// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ReplicationGroup
import aws.sdk.kotlin.services.elasticache.model.StartMigrationResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class StartMigrationOperationDeserializer: HttpDeserializer.NonStreaming<StartMigrationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartMigrationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartMigrationError(context, call, payload)
        }
        val builder = StartMigrationResponse.Builder()

        if (payload != null) {
            deserializeStartMigrationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartMigrationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidReplicationGroupState" -> InvalidReplicationGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReplicationGroupAlreadyUnderMigrationFault" -> ReplicationGroupAlreadyUnderMigrationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReplicationGroupNotFoundFault" -> ReplicationGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartMigrationOperationBody(builder: StartMigrationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "StartMigration")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ReplicationGroup com.amazonaws.elasticache#StartMigrationResponse$ReplicationGroup
            "ReplicationGroup" -> builder.replicationGroup = deserializeReplicationGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
