// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.AutomaticFailoverStatus
import aws.sdk.kotlin.services.elasticache.model.ClusterMode
import aws.sdk.kotlin.services.elasticache.model.DataTieringStatus
import aws.sdk.kotlin.services.elasticache.model.IpDiscovery
import aws.sdk.kotlin.services.elasticache.model.MultiAzStatus
import aws.sdk.kotlin.services.elasticache.model.NetworkType
import aws.sdk.kotlin.services.elasticache.model.ReplicationGroup
import aws.sdk.kotlin.services.elasticache.model.TransitEncryptionMode
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeReplicationGroupDocument(reader: XmlTagReader): ReplicationGroup {
    val builder = ReplicationGroup.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ReplicationGroupId com.amazonaws.elasticache#ReplicationGroup$ReplicationGroupId
            "ReplicationGroupId" -> builder.replicationGroupId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // Description com.amazonaws.elasticache#ReplicationGroup$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // GlobalReplicationGroupInfo com.amazonaws.elasticache#ReplicationGroup$GlobalReplicationGroupInfo
            "GlobalReplicationGroupInfo" -> builder.globalReplicationGroupInfo = deserializeGlobalReplicationGroupInfoDocument(curr)
            // Status com.amazonaws.elasticache#ReplicationGroup$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // PendingModifiedValues com.amazonaws.elasticache#ReplicationGroup$PendingModifiedValues
            "PendingModifiedValues" -> builder.pendingModifiedValues = deserializeReplicationGroupPendingModifiedValuesDocument(curr)
            // MemberClusters com.amazonaws.elasticache#ReplicationGroup$MemberClusters
            "MemberClusters" -> builder.memberClusters = deserializeClusterIdListShape(curr)
            // NodeGroups com.amazonaws.elasticache#ReplicationGroup$NodeGroups
            "NodeGroups" -> builder.nodeGroups = deserializeNodeGroupListShape(curr)
            // SnapshottingClusterId com.amazonaws.elasticache#ReplicationGroup$SnapshottingClusterId
            "SnapshottingClusterId" -> builder.snapshottingClusterId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // AutomaticFailover com.amazonaws.elasticache#ReplicationGroup$AutomaticFailover
            "AutomaticFailover" -> builder.automaticFailover = curr.tryData()
                .parse { AutomaticFailoverStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#AutomaticFailoverStatus`)" }
            // MultiAZ com.amazonaws.elasticache#ReplicationGroup$MultiAZ
            "MultiAZ" -> builder.multiAz = curr.tryData()
                .parse { MultiAzStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#MultiAZStatus`)" }
            // ConfigurationEndpoint com.amazonaws.elasticache#ReplicationGroup$ConfigurationEndpoint
            "ConfigurationEndpoint" -> builder.configurationEndpoint = deserializeEndpointDocument(curr)
            // SnapshotRetentionLimit com.amazonaws.elasticache#ReplicationGroup$SnapshotRetentionLimit
            "SnapshotRetentionLimit" -> builder.snapshotRetentionLimit = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.elasticache#IntegerOptional`)" }
            // SnapshotWindow com.amazonaws.elasticache#ReplicationGroup$SnapshotWindow
            "SnapshotWindow" -> builder.snapshotWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // ClusterEnabled com.amazonaws.elasticache#ReplicationGroup$ClusterEnabled
            "ClusterEnabled" -> builder.clusterEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticache#BooleanOptional`)" }
            // CacheNodeType com.amazonaws.elasticache#ReplicationGroup$CacheNodeType
            "CacheNodeType" -> builder.cacheNodeType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // AuthTokenEnabled com.amazonaws.elasticache#ReplicationGroup$AuthTokenEnabled
            "AuthTokenEnabled" -> builder.authTokenEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticache#BooleanOptional`)" }
            // AuthTokenLastModifiedDate com.amazonaws.elasticache#ReplicationGroup$AuthTokenLastModifiedDate
            "AuthTokenLastModifiedDate" -> builder.authTokenLastModifiedDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticache#TStamp`)" }
            // TransitEncryptionEnabled com.amazonaws.elasticache#ReplicationGroup$TransitEncryptionEnabled
            "TransitEncryptionEnabled" -> builder.transitEncryptionEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticache#BooleanOptional`)" }
            // AtRestEncryptionEnabled com.amazonaws.elasticache#ReplicationGroup$AtRestEncryptionEnabled
            "AtRestEncryptionEnabled" -> builder.atRestEncryptionEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticache#BooleanOptional`)" }
            // MemberClustersOutpostArns com.amazonaws.elasticache#ReplicationGroup$MemberClustersOutpostArns
            "MemberClustersOutpostArns" -> builder.memberClustersOutpostArns = deserializeReplicationGroupOutpostArnListShape(curr)
            // KmsKeyId com.amazonaws.elasticache#ReplicationGroup$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // ARN com.amazonaws.elasticache#ReplicationGroup$ARN
            "ARN" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // UserGroupIds com.amazonaws.elasticache#ReplicationGroup$UserGroupIds
            "UserGroupIds" -> builder.userGroupIds = deserializeUserGroupIdListShape(curr)
            // LogDeliveryConfigurations com.amazonaws.elasticache#ReplicationGroup$LogDeliveryConfigurations
            "LogDeliveryConfigurations" -> builder.logDeliveryConfigurations = deserializeLogDeliveryConfigurationListShape(curr)
            // ReplicationGroupCreateTime com.amazonaws.elasticache#ReplicationGroup$ReplicationGroupCreateTime
            "ReplicationGroupCreateTime" -> builder.replicationGroupCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticache#TStamp`)" }
            // DataTiering com.amazonaws.elasticache#ReplicationGroup$DataTiering
            "DataTiering" -> builder.dataTiering = curr.tryData()
                .parse { DataTieringStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#DataTieringStatus`)" }
            // AutoMinorVersionUpgrade com.amazonaws.elasticache#ReplicationGroup$AutoMinorVersionUpgrade
            "AutoMinorVersionUpgrade" -> builder.autoMinorVersionUpgrade = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticache#Boolean`)" }
            // NetworkType com.amazonaws.elasticache#ReplicationGroup$NetworkType
            "NetworkType" -> builder.networkType = curr.tryData()
                .parse { NetworkType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#NetworkType`)" }
            // IpDiscovery com.amazonaws.elasticache#ReplicationGroup$IpDiscovery
            "IpDiscovery" -> builder.ipDiscovery = curr.tryData()
                .parse { IpDiscovery.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#IpDiscovery`)" }
            // TransitEncryptionMode com.amazonaws.elasticache#ReplicationGroup$TransitEncryptionMode
            "TransitEncryptionMode" -> builder.transitEncryptionMode = curr.tryData()
                .parse { TransitEncryptionMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#TransitEncryptionMode`)" }
            // ClusterMode com.amazonaws.elasticache#ReplicationGroup$ClusterMode
            "ClusterMode" -> builder.clusterMode = curr.tryData()
                .parse { ClusterMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#ClusterMode`)" }
            // Engine com.amazonaws.elasticache#ReplicationGroup$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
