// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ReplicationGroup
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyReplicationGroupOperationDeserializer: HttpDeserializer.NonStreaming<ModifyReplicationGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifyReplicationGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyReplicationGroupError(context, call, payload)
        }
        val builder = ModifyReplicationGroupResponse.Builder()

        if (payload != null) {
            deserializeModifyReplicationGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifyReplicationGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CacheSecurityGroupNotFound" -> CacheSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidKMSKeyFault" -> InvalidKmsKeyFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCacheSecurityGroupState" -> InvalidCacheSecurityGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CacheClusterNotFound" -> CacheClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCacheClusterState" -> InvalidCacheClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NodeQuotaForClusterExceeded" -> NodeQuotaForClusterExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NodeQuotaForCustomerExceeded" -> NodeQuotaForCustomerExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidReplicationGroupState" -> InvalidReplicationGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UserGroupNotFound" -> UserGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CacheParameterGroupNotFound" -> CacheParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientCacheClusterCapacity" -> InsufficientCacheClusterCapacityFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ReplicationGroupNotFoundFault" -> ReplicationGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidUserGroupState" -> InvalidUserGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyReplicationGroupOperationBody(builder: ModifyReplicationGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyReplicationGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ReplicationGroup com.amazonaws.elasticache#ModifyReplicationGroupResult$ReplicationGroup
            "ReplicationGroup" -> builder.replicationGroup = deserializeReplicationGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
