// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.AuthTokenUpdateStrategyType
import aws.sdk.kotlin.services.elasticache.model.AzMode
import aws.sdk.kotlin.services.elasticache.model.IpDiscovery
import aws.sdk.kotlin.services.elasticache.model.LogDeliveryConfigurationRequest
import aws.sdk.kotlin.services.elasticache.model.ModifyCacheClusterRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ModifyCacheClusterOperationSerializer: HttpSerializer.NonStreaming<ModifyCacheClusterRequest> {
    override fun serialize(context: ExecutionContext, input: ModifyCacheClusterRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeModifyCacheClusterOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeModifyCacheClusterOperationBody(context: ExecutionContext, input: ModifyCacheClusterRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val AZMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("AZMode"))
    val APPLYIMMEDIATELY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("ApplyImmediately"))
    val AUTHTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AuthToken"))
    val AUTHTOKENUPDATESTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("AuthTokenUpdateStrategy"))
    val AUTOMINORVERSIONUPGRADE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("AutoMinorVersionUpgrade"))
    val CACHECLUSTERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("CacheClusterId"))
    val CACHENODEIDSTOREMOVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("CacheNodeIdsToRemove"), FormUrlCollectionName("CacheNodeId"))
    val CACHENODETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("CacheNodeType"))
    val CACHEPARAMETERGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("CacheParameterGroupName"))
    val CACHESECURITYGROUPNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("CacheSecurityGroupNames"), FormUrlCollectionName("CacheSecurityGroupName"))
    val ENGINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Engine"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("EngineVersion"))
    val IPDISCOVERY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, FormUrlSerialName("IpDiscovery"))
    val LOGDELIVERYCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("LogDeliveryConfigurations"), FormUrlCollectionName("LogDeliveryConfigurationRequest"))
    val NEWAVAILABILITYZONES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("NewAvailabilityZones"), FormUrlCollectionName("PreferredAvailabilityZone"))
    val NOTIFICATIONTOPICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("NotificationTopicArn"))
    val NOTIFICATIONTOPICSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("NotificationTopicStatus"))
    val NUMCACHENODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("NumCacheNodes"))
    val PREFERREDMAINTENANCEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PreferredMaintenanceWindow"))
    val SECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("SecurityGroupIds"), FormUrlCollectionName("SecurityGroupId"))
    val SNAPSHOTRETENTIONLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("SnapshotRetentionLimit"))
    val SNAPSHOTWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SnapshotWindow"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("ModifyCacheClusterMessage"))
        trait(QueryLiteral("Action", "ModifyCacheCluster"))
        trait(QueryLiteral("Version", "2015-02-02"))
        field(AZMODE_DESCRIPTOR)
        field(APPLYIMMEDIATELY_DESCRIPTOR)
        field(AUTHTOKEN_DESCRIPTOR)
        field(AUTHTOKENUPDATESTRATEGY_DESCRIPTOR)
        field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR)
        field(CACHECLUSTERID_DESCRIPTOR)
        field(CACHENODEIDSTOREMOVE_DESCRIPTOR)
        field(CACHENODETYPE_DESCRIPTOR)
        field(CACHEPARAMETERGROUPNAME_DESCRIPTOR)
        field(CACHESECURITYGROUPNAMES_DESCRIPTOR)
        field(ENGINE_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(IPDISCOVERY_DESCRIPTOR)
        field(LOGDELIVERYCONFIGURATIONS_DESCRIPTOR)
        field(NEWAVAILABILITYZONES_DESCRIPTOR)
        field(NOTIFICATIONTOPICARN_DESCRIPTOR)
        field(NOTIFICATIONTOPICSTATUS_DESCRIPTOR)
        field(NUMCACHENODES_DESCRIPTOR)
        field(PREFERREDMAINTENANCEWINDOW_DESCRIPTOR)
        field(SECURITYGROUPIDS_DESCRIPTOR)
        field(SNAPSHOTRETENTIONLIMIT_DESCRIPTOR)
        field(SNAPSHOTWINDOW_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.azMode?.let { field(AZMODE_DESCRIPTOR, it.value) }
        input.applyImmediately?.let { field(APPLYIMMEDIATELY_DESCRIPTOR, it) }
        input.authToken?.let { field(AUTHTOKEN_DESCRIPTOR, it) }
        input.authTokenUpdateStrategy?.let { field(AUTHTOKENUPDATESTRATEGY_DESCRIPTOR, it.value) }
        input.autoMinorVersionUpgrade?.let { field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR, it) }
        input.cacheClusterId?.let { field(CACHECLUSTERID_DESCRIPTOR, it) }
        if (input.cacheNodeIdsToRemove != null) {
            listField(CACHENODEIDSTOREMOVE_DESCRIPTOR) {
                for (el0 in input.cacheNodeIdsToRemove) {
                    serializeString(el0)
                }
            }
        }
        input.cacheNodeType?.let { field(CACHENODETYPE_DESCRIPTOR, it) }
        input.cacheParameterGroupName?.let { field(CACHEPARAMETERGROUPNAME_DESCRIPTOR, it) }
        if (input.cacheSecurityGroupNames != null) {
            listField(CACHESECURITYGROUPNAMES_DESCRIPTOR) {
                for (el0 in input.cacheSecurityGroupNames) {
                    serializeString(el0)
                }
            }
        }
        input.engine?.let { field(ENGINE_DESCRIPTOR, it) }
        input.engineVersion?.let { field(ENGINEVERSION_DESCRIPTOR, it) }
        input.ipDiscovery?.let { field(IPDISCOVERY_DESCRIPTOR, it.value) }
        if (input.logDeliveryConfigurations != null) {
            listField(LOGDELIVERYCONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.logDeliveryConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeLogDeliveryConfigurationRequestDocument))
                }
            }
        }
        if (input.newAvailabilityZones != null) {
            listField(NEWAVAILABILITYZONES_DESCRIPTOR) {
                for (el0 in input.newAvailabilityZones) {
                    serializeString(el0)
                }
            }
        }
        input.notificationTopicArn?.let { field(NOTIFICATIONTOPICARN_DESCRIPTOR, it) }
        input.notificationTopicStatus?.let { field(NOTIFICATIONTOPICSTATUS_DESCRIPTOR, it) }
        input.numCacheNodes?.let { field(NUMCACHENODES_DESCRIPTOR, it) }
        input.preferredMaintenanceWindow?.let { field(PREFERREDMAINTENANCEWINDOW_DESCRIPTOR, it) }
        if (input.securityGroupIds != null) {
            listField(SECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.securityGroupIds) {
                    serializeString(el0)
                }
            }
        }
        input.snapshotRetentionLimit?.let { field(SNAPSHOTRETENTIONLIMIT_DESCRIPTOR, it) }
        input.snapshotWindow?.let { field(SNAPSHOTWINDOW_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
