// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.CacheCluster
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ModifyCacheClusterResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyCacheClusterOperationDeserializer: HttpDeserializer.NonStreaming<ModifyCacheClusterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifyCacheClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyCacheClusterError(context, call, payload)
        }
        val builder = ModifyCacheClusterResponse.Builder()

        if (payload != null) {
            deserializeModifyCacheClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifyCacheClusterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CacheSecurityGroupNotFound" -> CacheSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCacheSecurityGroupState" -> InvalidCacheSecurityGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CacheParameterGroupNotFound" -> CacheParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CacheClusterNotFound" -> CacheClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCacheClusterState" -> InvalidCacheClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NodeQuotaForClusterExceeded" -> NodeQuotaForClusterExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientCacheClusterCapacity" -> InsufficientCacheClusterCapacityFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NodeQuotaForCustomerExceeded" -> NodeQuotaForCustomerExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyCacheClusterOperationBody(builder: ModifyCacheClusterResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyCacheCluster")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CacheCluster com.amazonaws.elasticache#ModifyCacheClusterResult$CacheCluster
            "CacheCluster" -> builder.cacheCluster = deserializeCacheClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
