// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.Event
import aws.sdk.kotlin.services.elasticache.model.SourceType
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeEventDocument(reader: XmlTagReader): Event {
    val builder = Event.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // SourceIdentifier com.amazonaws.elasticache#Event$SourceIdentifier
            "SourceIdentifier" -> builder.sourceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // SourceType com.amazonaws.elasticache#Event$SourceType
            "SourceType" -> builder.sourceType = curr.tryData()
                .parse { SourceType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#SourceType`)" }
            // Message com.amazonaws.elasticache#Event$Message
            "Message" -> builder.message = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // Date com.amazonaws.elasticache#Event$Date
            "Date" -> builder.date = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticache#TStamp`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
