// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.DescribeServerlessCacheSnapshotsResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ServerlessCacheSnapshot
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeServerlessCacheSnapshotsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeServerlessCacheSnapshotsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeServerlessCacheSnapshotsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeServerlessCacheSnapshotsError(context, call, payload)
        }
        val builder = DescribeServerlessCacheSnapshotsResponse.Builder()

        if (payload != null) {
            deserializeDescribeServerlessCacheSnapshotsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeServerlessCacheSnapshotsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServerlessCacheSnapshotNotFoundFault" -> ServerlessCacheSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServerlessCacheNotFoundFault" -> ServerlessCacheNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeServerlessCacheSnapshotsOperationBody(builder: DescribeServerlessCacheSnapshotsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeServerlessCacheSnapshots")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // NextToken com.amazonaws.elasticache#DescribeServerlessCacheSnapshotsResponse$NextToken
            "NextToken" -> builder.nextToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // ServerlessCacheSnapshots com.amazonaws.elasticache#DescribeServerlessCacheSnapshotsResponse$ServerlessCacheSnapshots
            "ServerlessCacheSnapshots" -> builder.serverlessCacheSnapshots = deserializeServerlessCacheSnapshotListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
