// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.AuthenticationMode
import aws.sdk.kotlin.services.elasticache.model.CreateUserRequest
import aws.sdk.kotlin.services.elasticache.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateUserOperationSerializer: HttpSerializer.NonStreaming<CreateUserRequest> {
    override fun serialize(context: ExecutionContext, input: CreateUserRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateUserOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeCreateUserOperationBody(context: ExecutionContext, input: CreateUserRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ACCESSSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AccessString"))
    val AUTHENTICATIONMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("AuthenticationMode"))
    val ENGINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Engine"))
    val NOPASSWORDREQUIRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("NoPasswordRequired"))
    val PASSWORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Passwords"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"), FormUrlCollectionName("Tag"))
    val USERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("UserId"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("UserName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CreateUserMessage"))
        trait(QueryLiteral("Action", "CreateUser"))
        trait(QueryLiteral("Version", "2015-02-02"))
        field(ACCESSSTRING_DESCRIPTOR)
        field(AUTHENTICATIONMODE_DESCRIPTOR)
        field(ENGINE_DESCRIPTOR)
        field(NOPASSWORDREQUIRED_DESCRIPTOR)
        field(PASSWORDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USERID_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessString?.let { field(ACCESSSTRING_DESCRIPTOR, it) }
        input.authenticationMode?.let { field(AUTHENTICATIONMODE_DESCRIPTOR, it, ::serializeAuthenticationModeDocument) }
        input.engine?.let { field(ENGINE_DESCRIPTOR, it) }
        input.noPasswordRequired?.let { field(NOPASSWORDREQUIRED_DESCRIPTOR, it) }
        if (input.passwords != null) {
            listField(PASSWORDS_DESCRIPTOR) {
                for (el0 in input.passwords) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.userId?.let { field(USERID_DESCRIPTOR, it) }
        input.userName?.let { field(USERNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
