// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.CreateSnapshotResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.Snapshot
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateSnapshotOperationDeserializer: HttpDeserializer.NonStreaming<CreateSnapshotResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateSnapshotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateSnapshotError(context, call, payload)
        }
        val builder = CreateSnapshotResponse.Builder()

        if (payload != null) {
            deserializeCreateSnapshotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateSnapshotError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotAlreadyExistsFault" -> SnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload)
        "CacheClusterNotFound" -> CacheClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCacheClusterState" -> InvalidCacheClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotQuotaExceededFault" -> SnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotFeatureNotSupportedFault" -> SnapshotFeatureNotSupportedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidReplicationGroupState" -> InvalidReplicationGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReplicationGroupNotFoundFault" -> ReplicationGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateSnapshotOperationBody(builder: CreateSnapshotResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateSnapshot")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Snapshot com.amazonaws.elasticache#CreateSnapshotResult$Snapshot
            "Snapshot" -> builder.snapshot = deserializeSnapshotDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
