// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.CreateServerlessCacheSnapshotResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ServerlessCacheSnapshot
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateServerlessCacheSnapshotOperationDeserializer: HttpDeserializer.NonStreaming<CreateServerlessCacheSnapshotResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateServerlessCacheSnapshotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateServerlessCacheSnapshotError(context, call, payload)
        }
        val builder = CreateServerlessCacheSnapshotResponse.Builder()

        if (payload != null) {
            deserializeCreateServerlessCacheSnapshotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateServerlessCacheSnapshotError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServerlessCacheNotFoundFault" -> ServerlessCacheNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidServerlessCacheStateFault" -> InvalidServerlessCacheStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ServerlessCacheSnapshotQuotaExceededFault" -> ServerlessCacheSnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload)
        "ServerlessCacheSnapshotAlreadyExistsFault" -> ServerlessCacheSnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateServerlessCacheSnapshotOperationBody(builder: CreateServerlessCacheSnapshotResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateServerlessCacheSnapshot")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ServerlessCacheSnapshot com.amazonaws.elasticache#CreateServerlessCacheSnapshotResponse$ServerlessCacheSnapshot
            "ServerlessCacheSnapshot" -> builder.serverlessCacheSnapshot = deserializeServerlessCacheSnapshotDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
