// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.CacheSubnetGroup
import aws.sdk.kotlin.services.elasticache.model.CreateCacheSubnetGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateCacheSubnetGroupOperationDeserializer: HttpDeserializer.NonStreaming<CreateCacheSubnetGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateCacheSubnetGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateCacheSubnetGroupError(context, call, payload)
        }
        val builder = CreateCacheSubnetGroupResponse.Builder()

        if (payload != null) {
            deserializeCreateCacheSubnetGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateCacheSubnetGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CacheSubnetGroupAlreadyExists" -> CacheSubnetGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload)
        "SubnetNotAllowedFault" -> SubnetNotAllowedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload)
        "CacheSubnetGroupQuotaExceeded" -> CacheSubnetGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CacheSubnetQuotaExceededFault" -> CacheSubnetQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCacheSubnetGroupOperationBody(builder: CreateCacheSubnetGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateCacheSubnetGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CacheSubnetGroup com.amazonaws.elasticache#CreateCacheSubnetGroupResult$CacheSubnetGroup
            "CacheSubnetGroup" -> builder.cacheSubnetGroup = deserializeCacheSubnetGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
