// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.CacheParameterGroup
import aws.sdk.kotlin.services.elasticache.model.CreateCacheParameterGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateCacheParameterGroupOperationDeserializer: HttpDeserializer.NonStreaming<CreateCacheParameterGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateCacheParameterGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateCacheParameterGroupError(context, call, payload)
        }
        val builder = CreateCacheParameterGroupResponse.Builder()

        if (payload != null) {
            deserializeCreateCacheParameterGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateCacheParameterGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CacheParameterGroupAlreadyExists" -> CacheParameterGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload)
        "CacheParameterGroupQuotaExceeded" -> CacheParameterGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCacheParameterGroupState" -> InvalidCacheParameterGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCacheParameterGroupOperationBody(builder: CreateCacheParameterGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateCacheParameterGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CacheParameterGroup com.amazonaws.elasticache#CreateCacheParameterGroupResult$CacheParameterGroup
            "CacheParameterGroup" -> builder.cacheParameterGroup = deserializeCacheParameterGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
