// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.CopySnapshotResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.Snapshot
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CopySnapshotOperationDeserializer: HttpDeserializer.NonStreaming<CopySnapshotResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CopySnapshotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCopySnapshotError(context, call, payload)
        }
        val builder = CopySnapshotResponse.Builder()

        if (payload != null) {
            deserializeCopySnapshotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCopySnapshotError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotAlreadyExistsFault" -> SnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSnapshotState" -> InvalidSnapshotStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotNotFoundFault" -> SnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotQuotaExceededFault" -> SnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCopySnapshotOperationBody(builder: CopySnapshotResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CopySnapshot")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Snapshot com.amazonaws.elasticache#CopySnapshotResult$Snapshot
            "Snapshot" -> builder.snapshot = deserializeSnapshotDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
