// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.CopyServerlessCacheSnapshotResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ServerlessCacheSnapshot
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CopyServerlessCacheSnapshotOperationDeserializer: HttpDeserializer.NonStreaming<CopyServerlessCacheSnapshotResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CopyServerlessCacheSnapshotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCopyServerlessCacheSnapshotError(context, call, payload)
        }
        val builder = CopyServerlessCacheSnapshotResponse.Builder()

        if (payload != null) {
            deserializeCopyServerlessCacheSnapshotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCopyServerlessCacheSnapshotError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServerlessCacheSnapshotNotFoundFault" -> ServerlessCacheSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidServerlessCacheSnapshotStateFault" -> InvalidServerlessCacheSnapshotStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ServerlessCacheSnapshotQuotaExceededFault" -> ServerlessCacheSnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload)
        "ServerlessCacheSnapshotAlreadyExistsFault" -> ServerlessCacheSnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCopyServerlessCacheSnapshotOperationBody(builder: CopyServerlessCacheSnapshotResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CopyServerlessCacheSnapshot")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ServerlessCacheSnapshot com.amazonaws.elasticache#CopyServerlessCacheSnapshotResponse$ServerlessCacheSnapshot
            "ServerlessCacheSnapshot" -> builder.serverlessCacheSnapshot = deserializeServerlessCacheSnapshotDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
