// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.CacheCluster
import aws.sdk.kotlin.services.elasticache.model.IpDiscovery
import aws.sdk.kotlin.services.elasticache.model.NetworkType
import aws.sdk.kotlin.services.elasticache.model.TransitEncryptionMode
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeCacheClusterDocument(reader: XmlTagReader): CacheCluster {
    val builder = CacheCluster.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // CacheClusterId com.amazonaws.elasticache#CacheCluster$CacheClusterId
            "CacheClusterId" -> builder.cacheClusterId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // ConfigurationEndpoint com.amazonaws.elasticache#CacheCluster$ConfigurationEndpoint
            "ConfigurationEndpoint" -> builder.configurationEndpoint = deserializeEndpointDocument(curr)
            // ClientDownloadLandingPage com.amazonaws.elasticache#CacheCluster$ClientDownloadLandingPage
            "ClientDownloadLandingPage" -> builder.clientDownloadLandingPage = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // CacheNodeType com.amazonaws.elasticache#CacheCluster$CacheNodeType
            "CacheNodeType" -> builder.cacheNodeType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // Engine com.amazonaws.elasticache#CacheCluster$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // EngineVersion com.amazonaws.elasticache#CacheCluster$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // CacheClusterStatus com.amazonaws.elasticache#CacheCluster$CacheClusterStatus
            "CacheClusterStatus" -> builder.cacheClusterStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // NumCacheNodes com.amazonaws.elasticache#CacheCluster$NumCacheNodes
            "NumCacheNodes" -> builder.numCacheNodes = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.elasticache#IntegerOptional`)" }
            // PreferredAvailabilityZone com.amazonaws.elasticache#CacheCluster$PreferredAvailabilityZone
            "PreferredAvailabilityZone" -> builder.preferredAvailabilityZone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // PreferredOutpostArn com.amazonaws.elasticache#CacheCluster$PreferredOutpostArn
            "PreferredOutpostArn" -> builder.preferredOutpostArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // CacheClusterCreateTime com.amazonaws.elasticache#CacheCluster$CacheClusterCreateTime
            "CacheClusterCreateTime" -> builder.cacheClusterCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticache#TStamp`)" }
            // PreferredMaintenanceWindow com.amazonaws.elasticache#CacheCluster$PreferredMaintenanceWindow
            "PreferredMaintenanceWindow" -> builder.preferredMaintenanceWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // PendingModifiedValues com.amazonaws.elasticache#CacheCluster$PendingModifiedValues
            "PendingModifiedValues" -> builder.pendingModifiedValues = deserializePendingModifiedValuesDocument(curr)
            // NotificationConfiguration com.amazonaws.elasticache#CacheCluster$NotificationConfiguration
            "NotificationConfiguration" -> builder.notificationConfiguration = deserializeNotificationConfigurationDocument(curr)
            // CacheSecurityGroups com.amazonaws.elasticache#CacheCluster$CacheSecurityGroups
            "CacheSecurityGroups" -> builder.cacheSecurityGroups = deserializeCacheSecurityGroupMembershipListShape(curr)
            // CacheParameterGroup com.amazonaws.elasticache#CacheCluster$CacheParameterGroup
            "CacheParameterGroup" -> builder.cacheParameterGroup = deserializeCacheParameterGroupStatusDocument(curr)
            // CacheSubnetGroupName com.amazonaws.elasticache#CacheCluster$CacheSubnetGroupName
            "CacheSubnetGroupName" -> builder.cacheSubnetGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // CacheNodes com.amazonaws.elasticache#CacheCluster$CacheNodes
            "CacheNodes" -> builder.cacheNodes = deserializeCacheNodeListShape(curr)
            // AutoMinorVersionUpgrade com.amazonaws.elasticache#CacheCluster$AutoMinorVersionUpgrade
            "AutoMinorVersionUpgrade" -> builder.autoMinorVersionUpgrade = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticache#Boolean`)" }
            // SecurityGroups com.amazonaws.elasticache#CacheCluster$SecurityGroups
            "SecurityGroups" -> builder.securityGroups = deserializeSecurityGroupMembershipListShape(curr)
            // ReplicationGroupId com.amazonaws.elasticache#CacheCluster$ReplicationGroupId
            "ReplicationGroupId" -> builder.replicationGroupId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // SnapshotRetentionLimit com.amazonaws.elasticache#CacheCluster$SnapshotRetentionLimit
            "SnapshotRetentionLimit" -> builder.snapshotRetentionLimit = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.elasticache#IntegerOptional`)" }
            // SnapshotWindow com.amazonaws.elasticache#CacheCluster$SnapshotWindow
            "SnapshotWindow" -> builder.snapshotWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // AuthTokenEnabled com.amazonaws.elasticache#CacheCluster$AuthTokenEnabled
            "AuthTokenEnabled" -> builder.authTokenEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticache#BooleanOptional`)" }
            // AuthTokenLastModifiedDate com.amazonaws.elasticache#CacheCluster$AuthTokenLastModifiedDate
            "AuthTokenLastModifiedDate" -> builder.authTokenLastModifiedDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticache#TStamp`)" }
            // TransitEncryptionEnabled com.amazonaws.elasticache#CacheCluster$TransitEncryptionEnabled
            "TransitEncryptionEnabled" -> builder.transitEncryptionEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticache#BooleanOptional`)" }
            // AtRestEncryptionEnabled com.amazonaws.elasticache#CacheCluster$AtRestEncryptionEnabled
            "AtRestEncryptionEnabled" -> builder.atRestEncryptionEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticache#BooleanOptional`)" }
            // ARN com.amazonaws.elasticache#CacheCluster$ARN
            "ARN" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // ReplicationGroupLogDeliveryEnabled com.amazonaws.elasticache#CacheCluster$ReplicationGroupLogDeliveryEnabled
            "ReplicationGroupLogDeliveryEnabled" -> builder.replicationGroupLogDeliveryEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticache#Boolean`)" }
            // LogDeliveryConfigurations com.amazonaws.elasticache#CacheCluster$LogDeliveryConfigurations
            "LogDeliveryConfigurations" -> builder.logDeliveryConfigurations = deserializeLogDeliveryConfigurationListShape(curr)
            // NetworkType com.amazonaws.elasticache#CacheCluster$NetworkType
            "NetworkType" -> builder.networkType = curr.tryData()
                .parse { NetworkType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#NetworkType`)" }
            // IpDiscovery com.amazonaws.elasticache#CacheCluster$IpDiscovery
            "IpDiscovery" -> builder.ipDiscovery = curr.tryData()
                .parse { IpDiscovery.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#IpDiscovery`)" }
            // TransitEncryptionMode com.amazonaws.elasticache#CacheCluster$TransitEncryptionMode
            "TransitEncryptionMode" -> builder.transitEncryptionMode = curr.tryData()
                .parse { TransitEncryptionMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#TransitEncryptionMode`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
