// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.paginators

import aws.sdk.kotlin.services.elasticache.ElastiCacheClient
import aws.sdk.kotlin.services.elasticache.model.CacheCluster
import aws.sdk.kotlin.services.elasticache.model.CacheEngineVersion
import aws.sdk.kotlin.services.elasticache.model.CacheParameterGroup
import aws.sdk.kotlin.services.elasticache.model.CacheSecurityGroup
import aws.sdk.kotlin.services.elasticache.model.CacheSubnetGroup
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheEngineVersionsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheEngineVersionsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheParameterGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheParameterGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheParametersRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheParametersResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheSecurityGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheSecurityGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheSubnetGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheSubnetGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeEngineDefaultParametersRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeEngineDefaultParametersResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeEventsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeEventsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeGlobalReplicationGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeGlobalReplicationGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeServerlessCacheSnapshotsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeServerlessCacheSnapshotsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeServerlessCachesRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeServerlessCachesResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeServiceUpdatesRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeServiceUpdatesResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeSnapshotsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeSnapshotsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeUpdateActionsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeUpdateActionsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeUserGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeUserGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeUsersRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeUsersResponse
import aws.sdk.kotlin.services.elasticache.model.Event
import aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroup
import aws.sdk.kotlin.services.elasticache.model.Parameter
import aws.sdk.kotlin.services.elasticache.model.ReplicationGroup
import aws.sdk.kotlin.services.elasticache.model.ReservedCacheNode
import aws.sdk.kotlin.services.elasticache.model.ReservedCacheNodesOffering
import aws.sdk.kotlin.services.elasticache.model.ServerlessCache
import aws.sdk.kotlin.services.elasticache.model.ServerlessCacheSnapshot
import aws.sdk.kotlin.services.elasticache.model.ServiceUpdate
import aws.sdk.kotlin.services.elasticache.model.Snapshot
import aws.sdk.kotlin.services.elasticache.model.UpdateAction
import aws.sdk.kotlin.services.elasticache.model.User
import aws.sdk.kotlin.services.elasticache.model.UserGroup
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeCacheClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCacheClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheClustersResponse]
 */
public fun ElastiCacheClient.describeCacheClustersPaginated(initialRequest: DescribeCacheClustersRequest = DescribeCacheClustersRequest { }): Flow<DescribeCacheClustersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeCacheClustersPaginated.describeCacheClusters(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCacheClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheClustersResponse]
 */
public fun ElastiCacheClient.describeCacheClustersPaginated(block: DescribeCacheClustersRequest.Builder.() -> Unit): Flow<DescribeCacheClustersResponse> =
    describeCacheClustersPaginated(DescribeCacheClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCacheClustersPaginated]
 * to access the nested member [CacheCluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CacheCluster]
 */
@JvmName("describeCacheClustersResponseCacheCluster")
public fun Flow<DescribeCacheClustersResponse>.cacheClusters(): Flow<CacheCluster> =
    transform() { response ->
        response.cacheClusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeCacheEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCacheEngineVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheEngineVersionsResponse]
 */
public fun ElastiCacheClient.describeCacheEngineVersionsPaginated(initialRequest: DescribeCacheEngineVersionsRequest = DescribeCacheEngineVersionsRequest { }): Flow<DescribeCacheEngineVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeCacheEngineVersionsPaginated.describeCacheEngineVersions(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCacheEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheEngineVersionsResponse]
 */
public fun ElastiCacheClient.describeCacheEngineVersionsPaginated(block: DescribeCacheEngineVersionsRequest.Builder.() -> Unit): Flow<DescribeCacheEngineVersionsResponse> =
    describeCacheEngineVersionsPaginated(DescribeCacheEngineVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCacheEngineVersionsPaginated]
 * to access the nested member [CacheEngineVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CacheEngineVersion]
 */
@JvmName("describeCacheEngineVersionsResponseCacheEngineVersion")
public fun Flow<DescribeCacheEngineVersionsResponse>.cacheEngineVersions(): Flow<CacheEngineVersion> =
    transform() { response ->
        response.cacheEngineVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeCacheParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCacheParameterGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheParameterGroupsResponse]
 */
public fun ElastiCacheClient.describeCacheParameterGroupsPaginated(initialRequest: DescribeCacheParameterGroupsRequest = DescribeCacheParameterGroupsRequest { }): Flow<DescribeCacheParameterGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeCacheParameterGroupsPaginated.describeCacheParameterGroups(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCacheParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheParameterGroupsResponse]
 */
public fun ElastiCacheClient.describeCacheParameterGroupsPaginated(block: DescribeCacheParameterGroupsRequest.Builder.() -> Unit): Flow<DescribeCacheParameterGroupsResponse> =
    describeCacheParameterGroupsPaginated(DescribeCacheParameterGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCacheParameterGroupsPaginated]
 * to access the nested member [CacheParameterGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CacheParameterGroup]
 */
@JvmName("describeCacheParameterGroupsResponseCacheParameterGroup")
public fun Flow<DescribeCacheParameterGroupsResponse>.cacheParameterGroups(): Flow<CacheParameterGroup> =
    transform() { response ->
        response.cacheParameterGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeCacheParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCacheParametersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheParametersResponse]
 */
public fun ElastiCacheClient.describeCacheParametersPaginated(initialRequest: DescribeCacheParametersRequest): Flow<DescribeCacheParametersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeCacheParametersPaginated.describeCacheParameters(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCacheParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheParametersResponse]
 */
public fun ElastiCacheClient.describeCacheParametersPaginated(block: DescribeCacheParametersRequest.Builder.() -> Unit): Flow<DescribeCacheParametersResponse> =
    describeCacheParametersPaginated(DescribeCacheParametersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCacheParametersPaginated]
 * to access the nested member [Parameter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Parameter]
 */
@JvmName("describeCacheParametersResponseParameter")
public fun Flow<DescribeCacheParametersResponse>.parameters(): Flow<Parameter> =
    transform() { response ->
        response.parameters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeCacheSecurityGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCacheSecurityGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheSecurityGroupsResponse]
 */
public fun ElastiCacheClient.describeCacheSecurityGroupsPaginated(initialRequest: DescribeCacheSecurityGroupsRequest = DescribeCacheSecurityGroupsRequest { }): Flow<DescribeCacheSecurityGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeCacheSecurityGroupsPaginated.describeCacheSecurityGroups(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCacheSecurityGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheSecurityGroupsResponse]
 */
public fun ElastiCacheClient.describeCacheSecurityGroupsPaginated(block: DescribeCacheSecurityGroupsRequest.Builder.() -> Unit): Flow<DescribeCacheSecurityGroupsResponse> =
    describeCacheSecurityGroupsPaginated(DescribeCacheSecurityGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCacheSecurityGroupsPaginated]
 * to access the nested member [CacheSecurityGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CacheSecurityGroup]
 */
@JvmName("describeCacheSecurityGroupsResponseCacheSecurityGroup")
public fun Flow<DescribeCacheSecurityGroupsResponse>.cacheSecurityGroups(): Flow<CacheSecurityGroup> =
    transform() { response ->
        response.cacheSecurityGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeCacheSubnetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCacheSubnetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheSubnetGroupsResponse]
 */
public fun ElastiCacheClient.describeCacheSubnetGroupsPaginated(initialRequest: DescribeCacheSubnetGroupsRequest = DescribeCacheSubnetGroupsRequest { }): Flow<DescribeCacheSubnetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeCacheSubnetGroupsPaginated.describeCacheSubnetGroups(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCacheSubnetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCacheSubnetGroupsResponse]
 */
public fun ElastiCacheClient.describeCacheSubnetGroupsPaginated(block: DescribeCacheSubnetGroupsRequest.Builder.() -> Unit): Flow<DescribeCacheSubnetGroupsResponse> =
    describeCacheSubnetGroupsPaginated(DescribeCacheSubnetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCacheSubnetGroupsPaginated]
 * to access the nested member [CacheSubnetGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CacheSubnetGroup]
 */
@JvmName("describeCacheSubnetGroupsResponseCacheSubnetGroup")
public fun Flow<DescribeCacheSubnetGroupsResponse>.cacheSubnetGroups(): Flow<CacheSubnetGroup> =
    transform() { response ->
        response.cacheSubnetGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEngineDefaultParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEngineDefaultParametersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEngineDefaultParametersResponse]
 */
public fun ElastiCacheClient.describeEngineDefaultParametersPaginated(initialRequest: DescribeEngineDefaultParametersRequest): Flow<DescribeEngineDefaultParametersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeEngineDefaultParametersPaginated.describeEngineDefaultParameters(req)
            cursor = result.engineDefaults?.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEngineDefaultParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEngineDefaultParametersResponse]
 */
public fun ElastiCacheClient.describeEngineDefaultParametersPaginated(block: DescribeEngineDefaultParametersRequest.Builder.() -> Unit): Flow<DescribeEngineDefaultParametersResponse> =
    describeEngineDefaultParametersPaginated(DescribeEngineDefaultParametersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEngineDefaultParametersPaginated]
 * to access the nested member [Parameter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Parameter]
 */
@JvmName("describeEngineDefaultParametersResponseParameter")
public fun Flow<DescribeEngineDefaultParametersResponse>.parameters(): Flow<Parameter> =
    transform() { response ->
        response.engineDefaults?.parameters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
public fun ElastiCacheClient.describeEventsPaginated(initialRequest: DescribeEventsRequest = DescribeEventsRequest { }): Flow<DescribeEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeEventsPaginated.describeEvents(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
public fun ElastiCacheClient.describeEventsPaginated(block: DescribeEventsRequest.Builder.() -> Unit): Flow<DescribeEventsResponse> =
    describeEventsPaginated(DescribeEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventsPaginated]
 * to access the nested member [Event]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Event]
 */
@JvmName("describeEventsResponseEvent")
public fun Flow<DescribeEventsResponse>.events(): Flow<Event> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeGlobalReplicationGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGlobalReplicationGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGlobalReplicationGroupsResponse]
 */
public fun ElastiCacheClient.describeGlobalReplicationGroupsPaginated(initialRequest: DescribeGlobalReplicationGroupsRequest = DescribeGlobalReplicationGroupsRequest { }): Flow<DescribeGlobalReplicationGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeGlobalReplicationGroupsPaginated.describeGlobalReplicationGroups(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGlobalReplicationGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGlobalReplicationGroupsResponse]
 */
public fun ElastiCacheClient.describeGlobalReplicationGroupsPaginated(block: DescribeGlobalReplicationGroupsRequest.Builder.() -> Unit): Flow<DescribeGlobalReplicationGroupsResponse> =
    describeGlobalReplicationGroupsPaginated(DescribeGlobalReplicationGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeGlobalReplicationGroupsPaginated]
 * to access the nested member [GlobalReplicationGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GlobalReplicationGroup]
 */
@JvmName("describeGlobalReplicationGroupsResponseGlobalReplicationGroup")
public fun Flow<DescribeGlobalReplicationGroupsResponse>.globalReplicationGroups(): Flow<GlobalReplicationGroup> =
    transform() { response ->
        response.globalReplicationGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeReplicationGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReplicationGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReplicationGroupsResponse]
 */
public fun ElastiCacheClient.describeReplicationGroupsPaginated(initialRequest: DescribeReplicationGroupsRequest = DescribeReplicationGroupsRequest { }): Flow<DescribeReplicationGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeReplicationGroupsPaginated.describeReplicationGroups(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReplicationGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReplicationGroupsResponse]
 */
public fun ElastiCacheClient.describeReplicationGroupsPaginated(block: DescribeReplicationGroupsRequest.Builder.() -> Unit): Flow<DescribeReplicationGroupsResponse> =
    describeReplicationGroupsPaginated(DescribeReplicationGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeReplicationGroupsPaginated]
 * to access the nested member [ReplicationGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReplicationGroup]
 */
@JvmName("describeReplicationGroupsResponseReplicationGroup")
public fun Flow<DescribeReplicationGroupsResponse>.replicationGroups(): Flow<ReplicationGroup> =
    transform() { response ->
        response.replicationGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeReservedCacheNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedCacheNodesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedCacheNodesResponse]
 */
public fun ElastiCacheClient.describeReservedCacheNodesPaginated(initialRequest: DescribeReservedCacheNodesRequest = DescribeReservedCacheNodesRequest { }): Flow<DescribeReservedCacheNodesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeReservedCacheNodesPaginated.describeReservedCacheNodes(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedCacheNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedCacheNodesResponse]
 */
public fun ElastiCacheClient.describeReservedCacheNodesPaginated(block: DescribeReservedCacheNodesRequest.Builder.() -> Unit): Flow<DescribeReservedCacheNodesResponse> =
    describeReservedCacheNodesPaginated(DescribeReservedCacheNodesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeReservedCacheNodesPaginated]
 * to access the nested member [ReservedCacheNode]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReservedCacheNode]
 */
@JvmName("describeReservedCacheNodesResponseReservedCacheNode")
public fun Flow<DescribeReservedCacheNodesResponse>.reservedCacheNodes(): Flow<ReservedCacheNode> =
    transform() { response ->
        response.reservedCacheNodes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeReservedCacheNodesOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedCacheNodesOfferingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedCacheNodesOfferingsResponse]
 */
public fun ElastiCacheClient.describeReservedCacheNodesOfferingsPaginated(initialRequest: DescribeReservedCacheNodesOfferingsRequest = DescribeReservedCacheNodesOfferingsRequest { }): Flow<DescribeReservedCacheNodesOfferingsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeReservedCacheNodesOfferingsPaginated.describeReservedCacheNodesOfferings(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedCacheNodesOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedCacheNodesOfferingsResponse]
 */
public fun ElastiCacheClient.describeReservedCacheNodesOfferingsPaginated(block: DescribeReservedCacheNodesOfferingsRequest.Builder.() -> Unit): Flow<DescribeReservedCacheNodesOfferingsResponse> =
    describeReservedCacheNodesOfferingsPaginated(DescribeReservedCacheNodesOfferingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeReservedCacheNodesOfferingsPaginated]
 * to access the nested member [ReservedCacheNodesOffering]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReservedCacheNodesOffering]
 */
@JvmName("describeReservedCacheNodesOfferingsResponseReservedCacheNodesOffering")
public fun Flow<DescribeReservedCacheNodesOfferingsResponse>.reservedCacheNodesOfferings(): Flow<ReservedCacheNodesOffering> =
    transform() { response ->
        response.reservedCacheNodesOfferings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeServerlessCachesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeServerlessCachesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServerlessCachesResponse]
 */
public fun ElastiCacheClient.describeServerlessCachesPaginated(initialRequest: DescribeServerlessCachesRequest = DescribeServerlessCachesRequest { }): Flow<DescribeServerlessCachesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeServerlessCachesPaginated.describeServerlessCaches(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeServerlessCachesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServerlessCachesResponse]
 */
public fun ElastiCacheClient.describeServerlessCachesPaginated(block: DescribeServerlessCachesRequest.Builder.() -> Unit): Flow<DescribeServerlessCachesResponse> =
    describeServerlessCachesPaginated(DescribeServerlessCachesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeServerlessCachesPaginated]
 * to access the nested member [ServerlessCache]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServerlessCache]
 */
@JvmName("describeServerlessCachesResponseServerlessCache")
public fun Flow<DescribeServerlessCachesResponse>.serverlessCaches(): Flow<ServerlessCache> =
    transform() { response ->
        response.serverlessCaches?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeServerlessCacheSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeServerlessCacheSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServerlessCacheSnapshotsResponse]
 */
public fun ElastiCacheClient.describeServerlessCacheSnapshotsPaginated(initialRequest: DescribeServerlessCacheSnapshotsRequest = DescribeServerlessCacheSnapshotsRequest { }): Flow<DescribeServerlessCacheSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeServerlessCacheSnapshotsPaginated.describeServerlessCacheSnapshots(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeServerlessCacheSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServerlessCacheSnapshotsResponse]
 */
public fun ElastiCacheClient.describeServerlessCacheSnapshotsPaginated(block: DescribeServerlessCacheSnapshotsRequest.Builder.() -> Unit): Flow<DescribeServerlessCacheSnapshotsResponse> =
    describeServerlessCacheSnapshotsPaginated(DescribeServerlessCacheSnapshotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeServerlessCacheSnapshotsPaginated]
 * to access the nested member [ServerlessCacheSnapshot]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServerlessCacheSnapshot]
 */
@JvmName("describeServerlessCacheSnapshotsResponseServerlessCacheSnapshot")
public fun Flow<DescribeServerlessCacheSnapshotsResponse>.serverlessCacheSnapshots(): Flow<ServerlessCacheSnapshot> =
    transform() { response ->
        response.serverlessCacheSnapshots?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeServiceUpdatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeServiceUpdatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServiceUpdatesResponse]
 */
public fun ElastiCacheClient.describeServiceUpdatesPaginated(initialRequest: DescribeServiceUpdatesRequest = DescribeServiceUpdatesRequest { }): Flow<DescribeServiceUpdatesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeServiceUpdatesPaginated.describeServiceUpdates(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeServiceUpdatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServiceUpdatesResponse]
 */
public fun ElastiCacheClient.describeServiceUpdatesPaginated(block: DescribeServiceUpdatesRequest.Builder.() -> Unit): Flow<DescribeServiceUpdatesResponse> =
    describeServiceUpdatesPaginated(DescribeServiceUpdatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeServiceUpdatesPaginated]
 * to access the nested member [ServiceUpdate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceUpdate]
 */
@JvmName("describeServiceUpdatesResponseServiceUpdate")
public fun Flow<DescribeServiceUpdatesResponse>.serviceUpdates(): Flow<ServiceUpdate> =
    transform() { response ->
        response.serviceUpdates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSnapshotsResponse]
 */
public fun ElastiCacheClient.describeSnapshotsPaginated(initialRequest: DescribeSnapshotsRequest = DescribeSnapshotsRequest { }): Flow<DescribeSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeSnapshotsPaginated.describeSnapshots(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSnapshotsResponse]
 */
public fun ElastiCacheClient.describeSnapshotsPaginated(block: DescribeSnapshotsRequest.Builder.() -> Unit): Flow<DescribeSnapshotsResponse> =
    describeSnapshotsPaginated(DescribeSnapshotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeSnapshotsPaginated]
 * to access the nested member [Snapshot]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Snapshot]
 */
@JvmName("describeSnapshotsResponseSnapshot")
public fun Flow<DescribeSnapshotsResponse>.snapshots(): Flow<Snapshot> =
    transform() { response ->
        response.snapshots?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeUpdateActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeUpdateActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUpdateActionsResponse]
 */
public fun ElastiCacheClient.describeUpdateActionsPaginated(initialRequest: DescribeUpdateActionsRequest = DescribeUpdateActionsRequest { }): Flow<DescribeUpdateActionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeUpdateActionsPaginated.describeUpdateActions(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeUpdateActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUpdateActionsResponse]
 */
public fun ElastiCacheClient.describeUpdateActionsPaginated(block: DescribeUpdateActionsRequest.Builder.() -> Unit): Flow<DescribeUpdateActionsResponse> =
    describeUpdateActionsPaginated(DescribeUpdateActionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeUpdateActionsPaginated]
 * to access the nested member [UpdateAction]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UpdateAction]
 */
@JvmName("describeUpdateActionsResponseUpdateAction")
public fun Flow<DescribeUpdateActionsResponse>.updateActions(): Flow<UpdateAction> =
    transform() { response ->
        response.updateActions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeUserGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeUserGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUserGroupsResponse]
 */
public fun ElastiCacheClient.describeUserGroupsPaginated(initialRequest: DescribeUserGroupsRequest = DescribeUserGroupsRequest { }): Flow<DescribeUserGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeUserGroupsPaginated.describeUserGroups(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeUserGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUserGroupsResponse]
 */
public fun ElastiCacheClient.describeUserGroupsPaginated(block: DescribeUserGroupsRequest.Builder.() -> Unit): Flow<DescribeUserGroupsResponse> =
    describeUserGroupsPaginated(DescribeUserGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeUserGroupsPaginated]
 * to access the nested member [UserGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UserGroup]
 */
@JvmName("describeUserGroupsResponseUserGroup")
public fun Flow<DescribeUserGroupsResponse>.userGroups(): Flow<UserGroup> =
    transform() { response ->
        response.userGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUsersResponse]
 */
public fun ElastiCacheClient.describeUsersPaginated(initialRequest: DescribeUsersRequest = DescribeUsersRequest { }): Flow<DescribeUsersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeUsersPaginated.describeUsers(req)
            cursor = result.marker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUsersResponse]
 */
public fun ElastiCacheClient.describeUsersPaginated(block: DescribeUsersRequest.Builder.() -> Unit): Flow<DescribeUsersResponse> =
    describeUsersPaginated(DescribeUsersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeUsersPaginated]
 * to access the nested member [User]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [User]
 */
@JvmName("describeUsersResponseUser")
public fun Flow<DescribeUsersResponse>.users(): Flow<User> =
    transform() { response ->
        response.users?.forEach {
            emit(it)
        }
    }
