// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The status of the service update for a specific replication group
 */
public class UpdateAction private constructor(builder: Builder) {
    /**
     * The ID of the cache cluster
     */
    public val cacheClusterId: kotlin.String? = builder.cacheClusterId
    /**
     * The status of the service update on the cache node
     */
    public val cacheNodeUpdateStatus: List<CacheNodeUpdateStatus>? = builder.cacheNodeUpdateStatus
    /**
     * The Elasticache engine to which the update applies. Either Valkey, Redis OSS or Memcached.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The estimated length of time for the update to complete
     */
    public val estimatedUpdateTime: kotlin.String? = builder.estimatedUpdateTime
    /**
     * The status of the service update on the node group
     */
    public val nodeGroupUpdateStatus: List<NodeGroupUpdateStatus>? = builder.nodeGroupUpdateStatus
    /**
     * The progress of the service update on the replication group
     */
    public val nodesUpdated: kotlin.String? = builder.nodesUpdated
    /**
     * The ID of the replication group
     */
    public val replicationGroupId: kotlin.String? = builder.replicationGroupId
    /**
     * The unique ID of the service update
     */
    public val serviceUpdateName: kotlin.String? = builder.serviceUpdateName
    /**
     * The recommended date to apply the service update to ensure compliance. For information on compliance, see [Self-Service Security Updates for Compliance](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service).
     */
    public val serviceUpdateRecommendedApplyByDate: aws.smithy.kotlin.runtime.time.Instant? = builder.serviceUpdateRecommendedApplyByDate
    /**
     * The date the update is first available
     */
    public val serviceUpdateReleaseDate: aws.smithy.kotlin.runtime.time.Instant? = builder.serviceUpdateReleaseDate
    /**
     * The severity of the service update
     */
    public val serviceUpdateSeverity: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateSeverity? = builder.serviceUpdateSeverity
    /**
     * The status of the service update
     */
    public val serviceUpdateStatus: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateStatus? = builder.serviceUpdateStatus
    /**
     * Reflects the nature of the service update
     */
    public val serviceUpdateType: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateType? = builder.serviceUpdateType
    /**
     * If yes, all nodes in the replication group have been updated by the recommended apply-by date. If no, at least one node in the replication group have not been updated by the recommended apply-by date. If N/A, the replication group was created after the recommended apply-by date.
     */
    public val slaMet: aws.sdk.kotlin.services.elasticache.model.SlaMet? = builder.slaMet
    /**
     * The date that the service update is available to a replication group
     */
    public val updateActionAvailableDate: aws.smithy.kotlin.runtime.time.Instant? = builder.updateActionAvailableDate
    /**
     * The status of the update action
     */
    public val updateActionStatus: aws.sdk.kotlin.services.elasticache.model.UpdateActionStatus? = builder.updateActionStatus
    /**
     * The date when the UpdateActionStatus was last modified
     */
    public val updateActionStatusModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.updateActionStatusModifiedDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.UpdateAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAction(")
        append("cacheClusterId=$cacheClusterId,")
        append("cacheNodeUpdateStatus=$cacheNodeUpdateStatus,")
        append("engine=$engine,")
        append("estimatedUpdateTime=$estimatedUpdateTime,")
        append("nodeGroupUpdateStatus=$nodeGroupUpdateStatus,")
        append("nodesUpdated=$nodesUpdated,")
        append("replicationGroupId=$replicationGroupId,")
        append("serviceUpdateName=$serviceUpdateName,")
        append("serviceUpdateRecommendedApplyByDate=$serviceUpdateRecommendedApplyByDate,")
        append("serviceUpdateReleaseDate=$serviceUpdateReleaseDate,")
        append("serviceUpdateSeverity=$serviceUpdateSeverity,")
        append("serviceUpdateStatus=$serviceUpdateStatus,")
        append("serviceUpdateType=$serviceUpdateType,")
        append("slaMet=$slaMet,")
        append("updateActionAvailableDate=$updateActionAvailableDate,")
        append("updateActionStatus=$updateActionStatus,")
        append("updateActionStatusModifiedDate=$updateActionStatusModifiedDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheClusterId?.hashCode() ?: 0
        result = 31 * result + (cacheNodeUpdateStatus?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (estimatedUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (nodeGroupUpdateStatus?.hashCode() ?: 0)
        result = 31 * result + (nodesUpdated?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateName?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateRecommendedApplyByDate?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateReleaseDate?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateSeverity?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateStatus?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateType?.hashCode() ?: 0)
        result = 31 * result + (slaMet?.hashCode() ?: 0)
        result = 31 * result + (updateActionAvailableDate?.hashCode() ?: 0)
        result = 31 * result + (updateActionStatus?.hashCode() ?: 0)
        result = 31 * result + (updateActionStatusModifiedDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAction

        if (cacheClusterId != other.cacheClusterId) return false
        if (cacheNodeUpdateStatus != other.cacheNodeUpdateStatus) return false
        if (engine != other.engine) return false
        if (estimatedUpdateTime != other.estimatedUpdateTime) return false
        if (nodeGroupUpdateStatus != other.nodeGroupUpdateStatus) return false
        if (nodesUpdated != other.nodesUpdated) return false
        if (replicationGroupId != other.replicationGroupId) return false
        if (serviceUpdateName != other.serviceUpdateName) return false
        if (serviceUpdateRecommendedApplyByDate != other.serviceUpdateRecommendedApplyByDate) return false
        if (serviceUpdateReleaseDate != other.serviceUpdateReleaseDate) return false
        if (serviceUpdateSeverity != other.serviceUpdateSeverity) return false
        if (serviceUpdateStatus != other.serviceUpdateStatus) return false
        if (serviceUpdateType != other.serviceUpdateType) return false
        if (slaMet != other.slaMet) return false
        if (updateActionAvailableDate != other.updateActionAvailableDate) return false
        if (updateActionStatus != other.updateActionStatus) return false
        if (updateActionStatusModifiedDate != other.updateActionStatusModifiedDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.UpdateAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the cache cluster
         */
        public var cacheClusterId: kotlin.String? = null
        /**
         * The status of the service update on the cache node
         */
        public var cacheNodeUpdateStatus: List<CacheNodeUpdateStatus>? = null
        /**
         * The Elasticache engine to which the update applies. Either Valkey, Redis OSS or Memcached.
         */
        public var engine: kotlin.String? = null
        /**
         * The estimated length of time for the update to complete
         */
        public var estimatedUpdateTime: kotlin.String? = null
        /**
         * The status of the service update on the node group
         */
        public var nodeGroupUpdateStatus: List<NodeGroupUpdateStatus>? = null
        /**
         * The progress of the service update on the replication group
         */
        public var nodesUpdated: kotlin.String? = null
        /**
         * The ID of the replication group
         */
        public var replicationGroupId: kotlin.String? = null
        /**
         * The unique ID of the service update
         */
        public var serviceUpdateName: kotlin.String? = null
        /**
         * The recommended date to apply the service update to ensure compliance. For information on compliance, see [Self-Service Security Updates for Compliance](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service).
         */
        public var serviceUpdateRecommendedApplyByDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date the update is first available
         */
        public var serviceUpdateReleaseDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The severity of the service update
         */
        public var serviceUpdateSeverity: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateSeverity? = null
        /**
         * The status of the service update
         */
        public var serviceUpdateStatus: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateStatus? = null
        /**
         * Reflects the nature of the service update
         */
        public var serviceUpdateType: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateType? = null
        /**
         * If yes, all nodes in the replication group have been updated by the recommended apply-by date. If no, at least one node in the replication group have not been updated by the recommended apply-by date. If N/A, the replication group was created after the recommended apply-by date.
         */
        public var slaMet: aws.sdk.kotlin.services.elasticache.model.SlaMet? = null
        /**
         * The date that the service update is available to a replication group
         */
        public var updateActionAvailableDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the update action
         */
        public var updateActionStatus: aws.sdk.kotlin.services.elasticache.model.UpdateActionStatus? = null
        /**
         * The date when the UpdateActionStatus was last modified
         */
        public var updateActionStatusModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.UpdateAction) : this() {
            this.cacheClusterId = x.cacheClusterId
            this.cacheNodeUpdateStatus = x.cacheNodeUpdateStatus
            this.engine = x.engine
            this.estimatedUpdateTime = x.estimatedUpdateTime
            this.nodeGroupUpdateStatus = x.nodeGroupUpdateStatus
            this.nodesUpdated = x.nodesUpdated
            this.replicationGroupId = x.replicationGroupId
            this.serviceUpdateName = x.serviceUpdateName
            this.serviceUpdateRecommendedApplyByDate = x.serviceUpdateRecommendedApplyByDate
            this.serviceUpdateReleaseDate = x.serviceUpdateReleaseDate
            this.serviceUpdateSeverity = x.serviceUpdateSeverity
            this.serviceUpdateStatus = x.serviceUpdateStatus
            this.serviceUpdateType = x.serviceUpdateType
            this.slaMet = x.slaMet
            this.updateActionAvailableDate = x.updateActionAvailableDate
            this.updateActionStatus = x.updateActionStatus
            this.updateActionStatusModifiedDate = x.updateActionStatusModifiedDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.UpdateAction = UpdateAction(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
