// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The resource representing a serverless cache.
 */
public class ServerlessCache private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the serverless cache.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The cache usage limit for the serverless cache.
     */
    public val cacheUsageLimits: aws.sdk.kotlin.services.elasticache.model.CacheUsageLimits? = builder.cacheUsageLimits
    /**
     * When the serverless cache was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The daily time that a cache snapshot will be created. Default is NULL, i.e. snapshots will not be created at a specific time on a daily basis. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val dailySnapshotTime: kotlin.String? = builder.dailySnapshotTime
    /**
     * A description of the serverless cache.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Represents the information required for client programs to connect to a cache node. This value is read-only.
     */
    public val endpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = builder.endpoint
    /**
     * The engine the serverless cache is compatible with.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The name and version number of the engine the serverless cache is compatible with.
     */
    public val fullEngineVersion: kotlin.String? = builder.fullEngineVersion
    /**
     * The ID of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt data at rest in the serverless cache.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The version number of the engine the serverless cache is compatible with.
     */
    public val majorEngineVersion: kotlin.String? = builder.majorEngineVersion
    /**
     * Represents the information required for client programs to connect to a cache node. This value is read-only.
     */
    public val readerEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = builder.readerEndpoint
    /**
     * The IDs of the EC2 security groups associated with the serverless cache.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The unique identifier of the serverless cache.
     */
    public val serverlessCacheName: kotlin.String? = builder.serverlessCacheName
    /**
     * The current setting for the number of serverless cache snapshots the system will retain. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING, CREATE-FAILED and MODIFYING.
     */
    public val status: kotlin.String? = builder.status
    /**
     * If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets across AZs in your VPC. For all other Regions, if no subnet IDs are given then ElastiCache will select 3 default subnets across AZs in your default VPC.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The identifier of the user group associated with the serverless cache. Available for Valkey and Redis OSS only. Default is NULL.
     */
    public val userGroupId: kotlin.String? = builder.userGroupId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.ServerlessCache = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerlessCache(")
        append("arn=$arn,")
        append("cacheUsageLimits=$cacheUsageLimits,")
        append("createTime=$createTime,")
        append("dailySnapshotTime=$dailySnapshotTime,")
        append("description=$description,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("fullEngineVersion=$fullEngineVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("majorEngineVersion=$majorEngineVersion,")
        append("readerEndpoint=$readerEndpoint,")
        append("securityGroupIds=$securityGroupIds,")
        append("serverlessCacheName=$serverlessCacheName,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("status=$status,")
        append("subnetIds=$subnetIds,")
        append("userGroupId=$userGroupId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (cacheUsageLimits?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (dailySnapshotTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (fullEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (majorEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (readerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (serverlessCacheName?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (userGroupId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerlessCache

        if (arn != other.arn) return false
        if (cacheUsageLimits != other.cacheUsageLimits) return false
        if (createTime != other.createTime) return false
        if (dailySnapshotTime != other.dailySnapshotTime) return false
        if (description != other.description) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (fullEngineVersion != other.fullEngineVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (majorEngineVersion != other.majorEngineVersion) return false
        if (readerEndpoint != other.readerEndpoint) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (serverlessCacheName != other.serverlessCacheName) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (status != other.status) return false
        if (subnetIds != other.subnetIds) return false
        if (userGroupId != other.userGroupId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.ServerlessCache = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the serverless cache.
         */
        public var arn: kotlin.String? = null
        /**
         * The cache usage limit for the serverless cache.
         */
        public var cacheUsageLimits: aws.sdk.kotlin.services.elasticache.model.CacheUsageLimits? = null
        /**
         * When the serverless cache was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The daily time that a cache snapshot will be created. Default is NULL, i.e. snapshots will not be created at a specific time on a daily basis. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var dailySnapshotTime: kotlin.String? = null
        /**
         * A description of the serverless cache.
         */
        public var description: kotlin.String? = null
        /**
         * Represents the information required for client programs to connect to a cache node. This value is read-only.
         */
        public var endpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = null
        /**
         * The engine the serverless cache is compatible with.
         */
        public var engine: kotlin.String? = null
        /**
         * The name and version number of the engine the serverless cache is compatible with.
         */
        public var fullEngineVersion: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt data at rest in the serverless cache.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The version number of the engine the serverless cache is compatible with.
         */
        public var majorEngineVersion: kotlin.String? = null
        /**
         * Represents the information required for client programs to connect to a cache node. This value is read-only.
         */
        public var readerEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = null
        /**
         * The IDs of the EC2 security groups associated with the serverless cache.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The unique identifier of the serverless cache.
         */
        public var serverlessCacheName: kotlin.String? = null
        /**
         * The current setting for the number of serverless cache snapshots the system will retain. Available for Valkey, Redis OSS and Serverless Memcached only.
         */
        public var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING, CREATE-FAILED and MODIFYING.
         */
        public var status: kotlin.String? = null
        /**
         * If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets across AZs in your VPC. For all other Regions, if no subnet IDs are given then ElastiCache will select 3 default subnets across AZs in your default VPC.
         */
        public var subnetIds: List<String>? = null
        /**
         * The identifier of the user group associated with the serverless cache. Available for Valkey and Redis OSS only. Default is NULL.
         */
        public var userGroupId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.ServerlessCache) : this() {
            this.arn = x.arn
            this.cacheUsageLimits = x.cacheUsageLimits
            this.createTime = x.createTime
            this.dailySnapshotTime = x.dailySnapshotTime
            this.description = x.description
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.fullEngineVersion = x.fullEngineVersion
            this.kmsKeyId = x.kmsKeyId
            this.majorEngineVersion = x.majorEngineVersion
            this.readerEndpoint = x.readerEndpoint
            this.securityGroupIds = x.securityGroupIds
            this.serverlessCacheName = x.serverlessCacheName
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.status = x.status
            this.subnetIds = x.subnetIds
            this.userGroupId = x.userGroupId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.ServerlessCache = ServerlessCache(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.CacheUsageLimits] inside the given [block]
         */
        public fun cacheUsageLimits(block: aws.sdk.kotlin.services.elasticache.model.CacheUsageLimits.Builder.() -> kotlin.Unit) {
            this.cacheUsageLimits = aws.sdk.kotlin.services.elasticache.model.CacheUsageLimits.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.Endpoint] inside the given [block]
         */
        public fun endpoint(block: aws.sdk.kotlin.services.elasticache.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.endpoint = aws.sdk.kotlin.services.elasticache.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.Endpoint] inside the given [block]
         */
        public fun readerEndpoint(block: aws.sdk.kotlin.services.elasticache.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.readerEndpoint = aws.sdk.kotlin.services.elasticache.model.Endpoint.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
