// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the input of a `DescribeEvents` operation.
 */
public class DescribeEventsRequest private constructor(builder: Builder) {
    /**
     * The number of minutes worth of events to retrieve.
     */
    public val duration: kotlin.Int? = builder.duration
    /**
     * The end of the time interval for which to retrieve events, specified in ISO 8601 format.
     *
     * **Example:** 2017-03-30T07:03:49.555Z
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a marker is included in the response so that the remaining results can be retrieved.
     *
     * Default: 100
     *
     * Constraints: minimum 20; maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The identifier of the event source for which events are returned. If not specified, all sources are included in the response.
     */
    public val sourceIdentifier: kotlin.String? = builder.sourceIdentifier
    /**
     * The event source to retrieve events for. If no value is specified, all events are returned.
     */
    public val sourceType: aws.sdk.kotlin.services.elasticache.model.SourceType? = builder.sourceType
    /**
     * The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
     *
     * **Example:** 2017-03-30T07:03:49.555Z
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.DescribeEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEventsRequest(")
        append("duration=$duration,")
        append("endTime=$endTime,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("sourceIdentifier=$sourceIdentifier,")
        append("sourceType=$sourceType,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (sourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEventsRequest

        if (duration != other.duration) return false
        if (endTime != other.endTime) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (sourceIdentifier != other.sourceIdentifier) return false
        if (sourceType != other.sourceType) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.DescribeEventsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of minutes worth of events to retrieve.
         */
        public var duration: kotlin.Int? = null
        /**
         * The end of the time interval for which to retrieve events, specified in ISO 8601 format.
         *
         * **Example:** 2017-03-30T07:03:49.555Z
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a marker is included in the response so that the remaining results can be retrieved.
         *
         * Default: 100
         *
         * Constraints: minimum 20; maximum 100.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The identifier of the event source for which events are returned. If not specified, all sources are included in the response.
         */
        public var sourceIdentifier: kotlin.String? = null
        /**
         * The event source to retrieve events for. If no value is specified, all events are returned.
         */
        public var sourceType: aws.sdk.kotlin.services.elasticache.model.SourceType? = null
        /**
         * The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
         *
         * **Example:** 2017-03-30T07:03:49.555Z
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.DescribeEventsRequest) : this() {
            this.duration = x.duration
            this.endTime = x.endTime
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.sourceIdentifier = x.sourceIdentifier
            this.sourceType = x.sourceType
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.DescribeEventsRequest = DescribeEventsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
