// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the output of one of the following operations:
 * + `CreateCacheSubnetGroup`
 * + `ModifyCacheSubnetGroup`
 */
public class CacheSubnetGroup private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the cache subnet group.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The description of the cache subnet group.
     */
    public val cacheSubnetGroupDescription: kotlin.String? = builder.cacheSubnetGroupDescription
    /**
     * The name of the cache subnet group.
     */
    public val cacheSubnetGroupName: kotlin.String? = builder.cacheSubnetGroupName
    /**
     * A list of subnets associated with the cache subnet group.
     */
    public val subnets: List<Subnet>? = builder.subnets
    /**
     * Either `ipv4` | `ipv6` | `dual_stack`. IPv6 is supported for workloads using Valkey 7.2 and above, Redis OSS engine version 6.2 and above or Memcached engine version 1.6.6 and above on all instances built on the [Nitro system](http://aws.amazon.com/ec2/nitro/).
     */
    public val supportedNetworkTypes: List<NetworkType>? = builder.supportedNetworkTypes
    /**
     * The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.CacheSubnetGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CacheSubnetGroup(")
        append("arn=$arn,")
        append("cacheSubnetGroupDescription=$cacheSubnetGroupDescription,")
        append("cacheSubnetGroupName=$cacheSubnetGroupName,")
        append("subnets=$subnets,")
        append("supportedNetworkTypes=$supportedNetworkTypes,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (cacheSubnetGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (cacheSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (supportedNetworkTypes?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CacheSubnetGroup

        if (arn != other.arn) return false
        if (cacheSubnetGroupDescription != other.cacheSubnetGroupDescription) return false
        if (cacheSubnetGroupName != other.cacheSubnetGroupName) return false
        if (subnets != other.subnets) return false
        if (supportedNetworkTypes != other.supportedNetworkTypes) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.CacheSubnetGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN (Amazon Resource Name) of the cache subnet group.
         */
        public var arn: kotlin.String? = null
        /**
         * The description of the cache subnet group.
         */
        public var cacheSubnetGroupDescription: kotlin.String? = null
        /**
         * The name of the cache subnet group.
         */
        public var cacheSubnetGroupName: kotlin.String? = null
        /**
         * A list of subnets associated with the cache subnet group.
         */
        public var subnets: List<Subnet>? = null
        /**
         * Either `ipv4` | `ipv6` | `dual_stack`. IPv6 is supported for workloads using Valkey 7.2 and above, Redis OSS engine version 6.2 and above or Memcached engine version 1.6.6 and above on all instances built on the [Nitro system](http://aws.amazon.com/ec2/nitro/).
         */
        public var supportedNetworkTypes: List<NetworkType>? = null
        /**
         * The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.CacheSubnetGroup) : this() {
            this.arn = x.arn
            this.cacheSubnetGroupDescription = x.cacheSubnetGroupDescription
            this.cacheSubnetGroupName = x.cacheSubnetGroupName
            this.subnets = x.subnets
            this.supportedNetworkTypes = x.supportedNetworkTypes
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.CacheSubnetGroup = CacheSubnetGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
