// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.waiters

import aws.sdk.kotlin.services.elasticache.ElastiCacheClient
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until ElastiCache cluster is available.
 */
public suspend fun ElastiCacheClient.waitUntilCacheClusterAvailable(request: DescribeCacheClustersRequest): Outcome<DescribeCacheClustersResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 15_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeCacheClustersRequest, DescribeCacheClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            !(projection as List<String>).isNullOrEmpty() && projection.all { it == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            (projection as List<String>?)?.any { it == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            (projection as List<String>?)?.any { it == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            (projection as List<String>?)?.any { it == "incompatible-network" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            (projection as List<String>?)?.any { it == "restore-failed" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCacheClusters(request) }
}

/**
 * Wait until ElastiCache cluster is available.
 */
public suspend fun ElastiCacheClient.waitUntilCacheClusterAvailable(block: DescribeCacheClustersRequest.Builder.() -> Unit): Outcome<DescribeCacheClustersResponse> =
    waitUntilCacheClusterAvailable(DescribeCacheClustersRequest.Builder().apply(block).build())

/**
 * Wait until ElastiCache cluster is deleted.
 */
public suspend fun ElastiCacheClient.waitUntilCacheClusterDeleted(request: DescribeCacheClustersRequest): Outcome<DescribeCacheClustersResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 15_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeCacheClustersRequest, DescribeCacheClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            !(projection as List<String>).isNullOrEmpty() && projection.all { it == "deleted" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "CacheClusterNotFound"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            (projection as List<String>?)?.any { it == "available" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            (projection as List<String>?)?.any { it == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            (projection as List<String>?)?.any { it == "incompatible-network" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            (projection as List<String>?)?.any { it == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            (projection as List<String>?)?.any { it == "restore-failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible()
            val projection = cacheClustersOrEmpty?.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            (projection as List<String>?)?.any { it == "snapshotting" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCacheClusters(request) }
}

/**
 * Wait until ElastiCache cluster is deleted.
 */
public suspend fun ElastiCacheClient.waitUntilCacheClusterDeleted(block: DescribeCacheClustersRequest.Builder.() -> Unit): Outcome<DescribeCacheClustersResponse> =
    waitUntilCacheClusterDeleted(DescribeCacheClustersRequest.Builder().apply(block).build())

/**
 * Wait until ElastiCache replication group is available.
 */
public suspend fun ElastiCacheClient.waitUntilReplicationGroupAvailable(request: DescribeReplicationGroupsRequest): Outcome<DescribeReplicationGroupsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 15_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val replicationGroups = it.replicationGroups
            val replicationGroupsOrEmpty = replicationGroups?.flattenIfPossible()
            val projection = replicationGroupsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            !(projection as List<String>).isNullOrEmpty() && projection.all { it == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationGroups = it.replicationGroups
            val replicationGroupsOrEmpty = replicationGroups?.flattenIfPossible()
            val projection = replicationGroupsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String>?)?.any { it == "deleted" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeReplicationGroups(request) }
}

/**
 * Wait until ElastiCache replication group is available.
 */
public suspend fun ElastiCacheClient.waitUntilReplicationGroupAvailable(block: DescribeReplicationGroupsRequest.Builder.() -> Unit): Outcome<DescribeReplicationGroupsResponse> =
    waitUntilReplicationGroupAvailable(DescribeReplicationGroupsRequest.Builder().apply(block).build())

/**
 * Wait until ElastiCache replication group is deleted.
 */
public suspend fun ElastiCacheClient.waitUntilReplicationGroupDeleted(request: DescribeReplicationGroupsRequest): Outcome<DescribeReplicationGroupsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 15_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val replicationGroups = it.replicationGroups
            val replicationGroupsOrEmpty = replicationGroups?.flattenIfPossible()
            val projection = replicationGroupsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            !(projection as List<String>).isNullOrEmpty() && projection.all { it == "deleted" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationGroups = it.replicationGroups
            val replicationGroupsOrEmpty = replicationGroups?.flattenIfPossible()
            val projection = replicationGroupsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String>?)?.any { it == "available" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ReplicationGroupNotFoundFault"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeReplicationGroups(request) }
}

/**
 * Wait until ElastiCache replication group is deleted.
 */
public suspend fun ElastiCacheClient.waitUntilReplicationGroupDeleted(block: DescribeReplicationGroupsRequest.Builder.() -> Unit): Outcome<DescribeReplicationGroupsResponse> =
    waitUntilReplicationGroupDeleted(DescribeReplicationGroupsRequest.Builder().apply(block).build())
