// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.services.elasticache.model.Authentication
import aws.sdk.kotlin.services.elasticache.model.CreateUserResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class CreateUserOperationDeserializer: HttpDeserialize<CreateUserResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateUserResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateUserError(context, call)
        }
        val builder = CreateUserResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateUserOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateUserError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateUserName" -> DuplicateUserNameFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall)
        "UserAlreadyExists" -> UserAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "UserQuotaExceeded" -> UserQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateUserOperationBody(builder: CreateUserResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateUserResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateUserResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateUser response")
    }
    // end unwrap response wrapper

    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ARN"))
    val ACCESSSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AccessString"))
    val AUTHENTICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Authentication"))
    val ENGINE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Engine"))
    val MINIMUMENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("MinimumEngineVersion"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Status"))
    val USERGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("UserGroupIds"))
    val USERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("UserId"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("UserName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("CreateUserResult"))
        field(ARN_DESCRIPTOR)
        field(ACCESSSTRING_DESCRIPTOR)
        field(AUTHENTICATION_DESCRIPTOR)
        field(ENGINE_DESCRIPTOR)
        field(MINIMUMENGINEVERSION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(USERGROUPIDS_DESCRIPTOR)
        field(USERID_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ACCESSSTRING_DESCRIPTOR.index -> builder.accessString = deserializeString()
                AUTHENTICATION_DESCRIPTOR.index -> builder.authentication = deserializeAuthenticationDocument(deserializer)
                ENGINE_DESCRIPTOR.index -> builder.engine = deserializeString()
                MINIMUMENGINEVERSION_DESCRIPTOR.index -> builder.minimumEngineVersion = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                USERGROUPIDS_DESCRIPTOR.index -> builder.userGroupIds =
                    deserializer.deserializeList(USERGROUPIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERID_DESCRIPTOR.index -> builder.userId = deserializeString()
                USERNAME_DESCRIPTOR.index -> builder.userName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
