// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.services.elasticache.model.BatchStopUpdateActionResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ProcessedUpdateAction
import aws.sdk.kotlin.services.elasticache.model.UnprocessedUpdateAction
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class BatchStopUpdateActionOperationDeserializer: HttpDeserialize<BatchStopUpdateActionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): BatchStopUpdateActionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchStopUpdateActionError(context, call)
        }
        val builder = BatchStopUpdateActionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchStopUpdateActionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchStopUpdateActionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUpdateNotFoundFault" -> ServiceUpdateNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchStopUpdateActionOperationBody(builder: BatchStopUpdateActionResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("BatchStopUpdateActionResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("BatchStopUpdateActionResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap BatchStopUpdateAction response")
    }
    // end unwrap response wrapper

    val PROCESSEDUPDATEACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ProcessedUpdateActions"), XmlCollectionName("ProcessedUpdateAction"))
    val UNPROCESSEDUPDATEACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("UnprocessedUpdateActions"), XmlCollectionName("UnprocessedUpdateAction"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("BatchStopUpdateActionResult"))
        field(PROCESSEDUPDATEACTIONS_DESCRIPTOR)
        field(UNPROCESSEDUPDATEACTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROCESSEDUPDATEACTIONS_DESCRIPTOR.index -> builder.processedUpdateActions =
                    deserializer.deserializeList(PROCESSEDUPDATEACTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProcessedUpdateAction>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProcessedUpdateActionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDUPDATEACTIONS_DESCRIPTOR.index -> builder.unprocessedUpdateActions =
                    deserializer.deserializeList(UNPROCESSEDUPDATEACTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedUpdateAction>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedUpdateActionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
