// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input of a `DeleteReplicationGroup` operation.
 */
public class DeleteReplicationGroupRequest private constructor(builder: Builder) {
    /**
     * The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final snapshot is taken, the replication group is immediately deleted.
     */
    public val finalSnapshotIdentifier: kotlin.String? = builder.finalSnapshotIdentifier
    /**
     * The identifier for the cluster to be deleted. This parameter is not case sensitive.
     */
    public val replicationGroupId: kotlin.String? = builder.replicationGroupId
    /**
     * If set to `true`, all of the read replicas are deleted, but the primary node is retained.
     */
    public val retainPrimaryCluster: kotlin.Boolean? = builder.retainPrimaryCluster

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.DeleteReplicationGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteReplicationGroupRequest(")
        append("finalSnapshotIdentifier=$finalSnapshotIdentifier,")
        append("replicationGroupId=$replicationGroupId,")
        append("retainPrimaryCluster=$retainPrimaryCluster")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = finalSnapshotIdentifier?.hashCode() ?: 0
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (retainPrimaryCluster?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteReplicationGroupRequest

        if (finalSnapshotIdentifier != other.finalSnapshotIdentifier) return false
        if (replicationGroupId != other.replicationGroupId) return false
        if (retainPrimaryCluster != other.retainPrimaryCluster) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.DeleteReplicationGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final snapshot is taken, the replication group is immediately deleted.
         */
        public var finalSnapshotIdentifier: kotlin.String? = null
        /**
         * The identifier for the cluster to be deleted. This parameter is not case sensitive.
         */
        public var replicationGroupId: kotlin.String? = null
        /**
         * If set to `true`, all of the read replicas are deleted, but the primary node is retained.
         */
        public var retainPrimaryCluster: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.DeleteReplicationGroupRequest) : this() {
            this.finalSnapshotIdentifier = x.finalSnapshotIdentifier
            this.replicationGroupId = x.replicationGroupId
            this.retainPrimaryCluster = x.retainPrimaryCluster
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.DeleteReplicationGroupRequest = DeleteReplicationGroupRequest(this)
    }
}
