// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input of a `CopySnapshotMessage` operation.
 */
public class CopySnapshotRequest private constructor(builder: Builder) {
    /**
     * The ID of the KMS key used to encrypt the target snapshot.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of an existing snapshot from which to make a copy.
     */
    public val sourceSnapshotName: kotlin.String? = builder.sourceSnapshotName
    /**
     * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.
     *
     * When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3 bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the *Amazon ElastiCache User Guide*.
     *
     * For more information, see [Exporting a Snapshot](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html) in the *Amazon ElastiCache User Guide*.
     */
    public val targetBucket: kotlin.String? = builder.targetBucket
    /**
     * A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.
     */
    public val targetSnapshotName: kotlin.String? = builder.targetSnapshotName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.CopySnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopySnapshotRequest(")
        append("kmsKeyId=$kmsKeyId,")
        append("sourceSnapshotName=$sourceSnapshotName,")
        append("tags=$tags,")
        append("targetBucket=$targetBucket,")
        append("targetSnapshotName=$targetSnapshotName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (sourceSnapshotName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetBucket?.hashCode() ?: 0)
        result = 31 * result + (targetSnapshotName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopySnapshotRequest

        if (kmsKeyId != other.kmsKeyId) return false
        if (sourceSnapshotName != other.sourceSnapshotName) return false
        if (tags != other.tags) return false
        if (targetBucket != other.targetBucket) return false
        if (targetSnapshotName != other.targetSnapshotName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.CopySnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the KMS key used to encrypt the target snapshot.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of an existing snapshot from which to make a copy.
         */
        public var sourceSnapshotName: kotlin.String? = null
        /**
         * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.
         */
        public var tags: List<Tag>? = null
        /**
         * The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.
         *
         * When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3 bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the *Amazon ElastiCache User Guide*.
         *
         * For more information, see [Exporting a Snapshot](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html) in the *Amazon ElastiCache User Guide*.
         */
        public var targetBucket: kotlin.String? = null
        /**
         * A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.
         */
        public var targetSnapshotName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.CopySnapshotRequest) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.sourceSnapshotName = x.sourceSnapshotName
            this.tags = x.tags
            this.targetBucket = x.targetBucket
            this.targetSnapshotName = x.targetSnapshotName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.CopySnapshotRequest = CopySnapshotRequest(this)
    }
}
