// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.elasticache.auth.DefaultElastiCacheAuthSchemeProvider
import aws.sdk.kotlin.services.elasticache.auth.ElastiCacheAuthSchemeProvider
import aws.sdk.kotlin.services.elasticache.endpoints.DefaultElastiCacheEndpointProvider
import aws.sdk.kotlin.services.elasticache.endpoints.ElastiCacheEndpointParameters
import aws.sdk.kotlin.services.elasticache.endpoints.ElastiCacheEndpointProvider
import aws.sdk.kotlin.services.elasticache.model.AddTagsToResourceRequest
import aws.sdk.kotlin.services.elasticache.model.AddTagsToResourceResponse
import aws.sdk.kotlin.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest
import aws.sdk.kotlin.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse
import aws.sdk.kotlin.services.elasticache.model.BatchApplyUpdateActionRequest
import aws.sdk.kotlin.services.elasticache.model.BatchApplyUpdateActionResponse
import aws.sdk.kotlin.services.elasticache.model.BatchStopUpdateActionRequest
import aws.sdk.kotlin.services.elasticache.model.BatchStopUpdateActionResponse
import aws.sdk.kotlin.services.elasticache.model.CompleteMigrationRequest
import aws.sdk.kotlin.services.elasticache.model.CompleteMigrationResponse
import aws.sdk.kotlin.services.elasticache.model.CopySnapshotRequest
import aws.sdk.kotlin.services.elasticache.model.CopySnapshotResponse
import aws.sdk.kotlin.services.elasticache.model.CreateCacheClusterRequest
import aws.sdk.kotlin.services.elasticache.model.CreateCacheClusterResponse
import aws.sdk.kotlin.services.elasticache.model.CreateCacheParameterGroupRequest
import aws.sdk.kotlin.services.elasticache.model.CreateCacheParameterGroupResponse
import aws.sdk.kotlin.services.elasticache.model.CreateCacheSecurityGroupRequest
import aws.sdk.kotlin.services.elasticache.model.CreateCacheSecurityGroupResponse
import aws.sdk.kotlin.services.elasticache.model.CreateCacheSubnetGroupRequest
import aws.sdk.kotlin.services.elasticache.model.CreateCacheSubnetGroupResponse
import aws.sdk.kotlin.services.elasticache.model.CreateGlobalReplicationGroupRequest
import aws.sdk.kotlin.services.elasticache.model.CreateGlobalReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.CreateReplicationGroupRequest
import aws.sdk.kotlin.services.elasticache.model.CreateReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.CreateSnapshotRequest
import aws.sdk.kotlin.services.elasticache.model.CreateSnapshotResponse
import aws.sdk.kotlin.services.elasticache.model.CreateUserGroupRequest
import aws.sdk.kotlin.services.elasticache.model.CreateUserGroupResponse
import aws.sdk.kotlin.services.elasticache.model.CreateUserRequest
import aws.sdk.kotlin.services.elasticache.model.CreateUserResponse
import aws.sdk.kotlin.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupRequest
import aws.sdk.kotlin.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.DecreaseReplicaCountRequest
import aws.sdk.kotlin.services.elasticache.model.DecreaseReplicaCountResponse
import aws.sdk.kotlin.services.elasticache.model.DeleteCacheClusterRequest
import aws.sdk.kotlin.services.elasticache.model.DeleteCacheClusterResponse
import aws.sdk.kotlin.services.elasticache.model.DeleteCacheParameterGroupRequest
import aws.sdk.kotlin.services.elasticache.model.DeleteCacheParameterGroupResponse
import aws.sdk.kotlin.services.elasticache.model.DeleteCacheSecurityGroupRequest
import aws.sdk.kotlin.services.elasticache.model.DeleteCacheSecurityGroupResponse
import aws.sdk.kotlin.services.elasticache.model.DeleteCacheSubnetGroupRequest
import aws.sdk.kotlin.services.elasticache.model.DeleteCacheSubnetGroupResponse
import aws.sdk.kotlin.services.elasticache.model.DeleteGlobalReplicationGroupRequest
import aws.sdk.kotlin.services.elasticache.model.DeleteGlobalReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.DeleteReplicationGroupRequest
import aws.sdk.kotlin.services.elasticache.model.DeleteReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.DeleteSnapshotRequest
import aws.sdk.kotlin.services.elasticache.model.DeleteSnapshotResponse
import aws.sdk.kotlin.services.elasticache.model.DeleteUserGroupRequest
import aws.sdk.kotlin.services.elasticache.model.DeleteUserGroupResponse
import aws.sdk.kotlin.services.elasticache.model.DeleteUserRequest
import aws.sdk.kotlin.services.elasticache.model.DeleteUserResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheEngineVersionsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheEngineVersionsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheParameterGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheParameterGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheParametersRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheParametersResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheSecurityGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheSecurityGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheSubnetGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheSubnetGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeEngineDefaultParametersRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeEngineDefaultParametersResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeEventsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeEventsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeGlobalReplicationGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeGlobalReplicationGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeReservedCacheNodesResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeServiceUpdatesRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeServiceUpdatesResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeSnapshotsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeSnapshotsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeUpdateActionsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeUpdateActionsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeUserGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeUserGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeUsersRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeUsersResponse
import aws.sdk.kotlin.services.elasticache.model.DisassociateGlobalReplicationGroupRequest
import aws.sdk.kotlin.services.elasticache.model.DisassociateGlobalReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.FailoverGlobalReplicationGroupRequest
import aws.sdk.kotlin.services.elasticache.model.FailoverGlobalReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest
import aws.sdk.kotlin.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.IncreaseReplicaCountRequest
import aws.sdk.kotlin.services.elasticache.model.IncreaseReplicaCountResponse
import aws.sdk.kotlin.services.elasticache.model.ListAllowedNodeTypeModificationsRequest
import aws.sdk.kotlin.services.elasticache.model.ListAllowedNodeTypeModificationsResponse
import aws.sdk.kotlin.services.elasticache.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.elasticache.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.elasticache.model.ModifyCacheClusterRequest
import aws.sdk.kotlin.services.elasticache.model.ModifyCacheClusterResponse
import aws.sdk.kotlin.services.elasticache.model.ModifyCacheParameterGroupRequest
import aws.sdk.kotlin.services.elasticache.model.ModifyCacheParameterGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ModifyCacheSubnetGroupRequest
import aws.sdk.kotlin.services.elasticache.model.ModifyCacheSubnetGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ModifyGlobalReplicationGroupRequest
import aws.sdk.kotlin.services.elasticache.model.ModifyGlobalReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupRequest
import aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest
import aws.sdk.kotlin.services.elasticache.model.ModifyReplicationGroupShardConfigurationResponse
import aws.sdk.kotlin.services.elasticache.model.ModifyUserGroupRequest
import aws.sdk.kotlin.services.elasticache.model.ModifyUserGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ModifyUserRequest
import aws.sdk.kotlin.services.elasticache.model.ModifyUserResponse
import aws.sdk.kotlin.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest
import aws.sdk.kotlin.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse
import aws.sdk.kotlin.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupRequest
import aws.sdk.kotlin.services.elasticache.model.RebalanceSlotsInGlobalReplicationGroupResponse
import aws.sdk.kotlin.services.elasticache.model.RebootCacheClusterRequest
import aws.sdk.kotlin.services.elasticache.model.RebootCacheClusterResponse
import aws.sdk.kotlin.services.elasticache.model.RemoveTagsFromResourceRequest
import aws.sdk.kotlin.services.elasticache.model.RemoveTagsFromResourceResponse
import aws.sdk.kotlin.services.elasticache.model.ResetCacheParameterGroupRequest
import aws.sdk.kotlin.services.elasticache.model.ResetCacheParameterGroupResponse
import aws.sdk.kotlin.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest
import aws.sdk.kotlin.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse
import aws.sdk.kotlin.services.elasticache.model.StartMigrationRequest
import aws.sdk.kotlin.services.elasticache.model.StartMigrationResponse
import aws.sdk.kotlin.services.elasticache.model.TestFailoverRequest
import aws.sdk.kotlin.services.elasticache.model.TestFailoverResponse
import aws.sdk.kotlin.services.elasticache.model.TestMigrationRequest
import aws.sdk.kotlin.services.elasticache.model.TestMigrationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "ElastiCache"
public const val SdkVersion: String = "0.32.0-beta"

/**
 * # Amazon ElastiCache
 * Amazon ElastiCache is a web service that makes it easier to set up, operate, and scale a distributed cache in the cloud.
 *
 * With ElastiCache, customers get all of the benefits of a high-performance, in-memory cache with less of the administrative burden involved in launching and managing a distributed cache. The service makes setup, scaling, and cluster failure handling much simpler than in a self-managed cache deployment.
 *
 * In addition, through integration with Amazon CloudWatch, customers get enhanced visibility into the key performance statistics associated with their cache and can receive alarms if a part of their cache runs hot.
 */
public interface ElastiCacheClient : SdkClient {
    /**
     * ElastiCacheClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ElastiCacheClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ElastiCacheClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ElastiCacheClient = DefaultElastiCacheClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: ElastiCacheAuthSchemeProvider = builder.authSchemeProvider ?: DefaultElastiCacheAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ElastiCacheEndpointProvider = builder.endpointProvider ?: DefaultElastiCacheEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ElastiCache"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ElastiCacheAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ElastiCacheEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     *
     *  For example, you can use cost-allocation tags to your ElastiCache resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services.
     *
     * For more information, see [Using Cost Allocation Tags in Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html) in the *ElastiCache User Guide*.
     */
    public suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2, and Amazon EC2 security groups are used as the authorization mechanism.
     *
     * You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another region.
     */
    public suspend fun authorizeCacheSecurityGroupIngress(input: AuthorizeCacheSecurityGroupIngressRequest): AuthorizeCacheSecurityGroupIngressResponse

    /**
     * Apply the service update. For more information on service updates and applying them, see [Applying Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html).
     */
    public suspend fun batchApplyUpdateAction(input: BatchApplyUpdateActionRequest): BatchApplyUpdateActionResponse

    /**
     * Stop the service update. For more information on service updates and stopping them, see [Stopping Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html).
     */
    public suspend fun batchStopUpdateAction(input: BatchStopUpdateActionRequest): BatchStopUpdateActionResponse

    /**
     * Complete the migration of data.
     */
    public suspend fun completeMigration(input: CompleteMigrationRequest): CompleteMigrationResponse

    /**
     * Makes a copy of an existing snapshot.
     *
     * This operation is valid for Redis only.
     *
     * Users or groups that have permissions to use the `CopySnapshot` operation can create their own Amazon S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has the ability to use the `CopySnapshot` operation. For more information about using IAM to control the use of ElastiCache operations, see [Exporting Snapshots](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html) and [Authentication & Access Control](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html).
     *
     * You could receive the following error messages.
     *
     * **Error Messages**
     * + **Error Message:** The S3 bucket %s is outside of the region.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The S3 bucket %s does not exist.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The S3 bucket %s is not owned by the authenticated user.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The authenticated user does not have sufficient permissions to perform the desired activity.**Solution:** Contact your system administrator to get the needed permissions.
     * + **Error Message:** The S3 bucket %s already contains an object with key %s.**Solution:** Give the `TargetSnapshotName` a new and unique value. If exporting a snapshot, you could alternatively create a new Amazon S3 bucket and use this same value for `TargetSnapshotName`.
     * + **Error Message: ** ElastiCache has not been granted READ permissions %s on the S3 Bucket.**Solution:** Add List and Read permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     * + **Error Message: ** ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.**Solution:** Add Upload/Delete permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     * + **Error Message: ** ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.**Solution:** Add View Permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     */
    public suspend fun copySnapshot(input: CopySnapshotRequest): CopySnapshotResponse

    /**
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either Memcached or Redis.
     *
     * This operation is not supported for Redis (cluster mode enabled) clusters.
     */
    public suspend fun createCacheCluster(input: CreateCacheClusterRequest): CreateCacheClusterResponse

    /**
     * Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster or replication group using the CacheParameterGroup.
     *
     * A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of specific parameters. For more information, see:
     * + [ModifyCacheParameterGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html) in the ElastiCache API Reference.
     * + [Parameters and Parameter Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html) in the ElastiCache User Guide.
     */
    public suspend fun createCacheParameterGroup(input: CreateCacheParameterGroupRequest): CreateCacheParameterGroupResponse

    /**
     * Creates a new cache security group. Use a cache security group to control access to one or more clusters.
     *
     * Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more information, see [CreateCacheSubnetGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html).
     */
    public suspend fun createCacheSecurityGroup(input: CreateCacheSecurityGroupRequest): CreateCacheSecurityGroupResponse

    /**
     * Creates a new cache subnet group.
     *
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    public suspend fun createCacheSubnetGroup(input: CreateCacheSubnetGroupRequest): CreateCacheSubnetGroupResponse

    /**
     * Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable low-latency reads and disaster recovery across regions. For more information, see [Replication Across Regions Using Global Datastore](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html).
     * + The **GlobalReplicationGroupIdSuffix** is the name of the Global datastore.
     * + The **PrimaryReplicationGroupId** represents the name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.
     */
    public suspend fun createGlobalReplicationGroup(input: CreateGlobalReplicationGroupRequest): CreateGlobalReplicationGroupResponse

    /**
     * Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.
     *
     * This API can be used to create a standalone regional replication group or a secondary replication group associated with a Global datastore.
     *
     * A Redis (cluster mode disabled) replication group is a collection of clusters, where one of the clusters is a read/write primary and the others are read-only replicas. Writes to the primary are asynchronously propagated to the replicas.
     *
     * A Redis cluster-mode enabled cluster is comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas to 15 shards and 5 replicas, which is the maximum number or replicas allowed.
     *
     * The node or shard limit can be increased to a maximum of 500 per cluster if the Redis engine version is 5.0.6 or higher. For example, you can choose to configure a 500 node cluster that ranges between 83 shards (one primary and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there are enough available IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet group have too small a CIDR range or the subnets are shared and heavily used by other clusters. For more information, see [Creating a Subnet Group](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html). For versions below 5.0.6, the limit is 250 per cluster.
     *
     * To request a limit increase, see [Amazon Service Limits](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) and choose the limit type **Nodes per cluster per instance type**.
     *
     * When a Redis (cluster mode disabled) replication group has been successfully created, you can add one or more read replicas to it, up to a total of 5 read replicas. If you need to increase or decrease the number of node groups (console: shards), you can avail yourself of ElastiCache for Redis' scaling. For more information, see [Scaling ElastiCache for Redis Clusters](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html) in the *ElastiCache User Guide*.
     *
     * This operation is valid for Redis only.
     */
    public suspend fun createReplicationGroup(input: CreateReplicationGroupRequest): CreateReplicationGroupResponse

    /**
     * Creates a copy of an entire cluster or replication group at a specific moment in time.
     *
     * This operation is valid for Redis only.
     */
    public suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    public suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * For Redis engine version 6.0 onwards: Creates a Redis user group. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html)
     */
    public suspend fun createUserGroup(input: CreateUserGroupRequest): CreateUserGroupResponse

    /**
     * Decreases the number of node groups in a Global datastore
     */
    public suspend fun decreaseNodeGroupsInGlobalReplicationGroup(input: DecreaseNodeGroupsInGlobalReplicationGroupRequest): DecreaseNodeGroupsInGlobalReplicationGroupResponse

    /**
     * Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
     */
    public suspend fun decreaseReplicaCount(input: DecreaseReplicaCountRequest): DecreaseReplicaCountResponse

    /**
     * Deletes a previously provisioned cluster. `DeleteCacheCluster` deletes all associated cache nodes, node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.
     *
     * This operation is not valid for:
     * + Redis (cluster mode enabled) clusters
     * + Redis (cluster mode disabled) clusters
     * + A cluster that is the last read replica of a replication group
     * + A cluster that is the primary node of a replication group
     * + A node group (shard) that has Multi-AZ mode enabled
     * + A cluster from a Redis (cluster mode enabled) replication group
     * + A cluster that is not in the `available` state
     */
    public suspend fun deleteCacheCluster(input: DeleteCacheClusterRequest): DeleteCacheClusterResponse

    /**
     * Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with any cache clusters. You cannot delete the default cache parameter groups in your account.
     */
    public suspend fun deleteCacheParameterGroup(input: DeleteCacheParameterGroupRequest): DeleteCacheParameterGroupResponse

    /**
     * Deletes a cache security group.
     *
     * You cannot delete a cache security group if it is associated with any clusters.
     */
    public suspend fun deleteCacheSecurityGroup(input: DeleteCacheSecurityGroupRequest): DeleteCacheSecurityGroupResponse

    /**
     * Deletes a cache subnet group.
     *
     * You cannot delete a default cache subnet group or one that is associated with any clusters.
     */
    public suspend fun deleteCacheSubnetGroup(input: DeleteCacheSubnetGroupRequest): DeleteCacheSubnetGroupResponse

    /**
     * Deleting a Global datastore is a two-step process:
     * + First, you must DisassociateGlobalReplicationGroup to remove the secondary clusters in the Global datastore.
     * + Once the Global datastore contains only the primary cluster, you can use the `DeleteGlobalReplicationGroup` API to delete the Global datastore while retainining the primary cluster using `RetainPrimaryReplicationGroup=true`.
     *
     * Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the primary by setting `RetainPrimaryReplicationGroup=true`. The primary cluster is never deleted when deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore.
     *
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.
     */
    public suspend fun deleteGlobalReplicationGroup(input: DeleteGlobalReplicationGroupRequest): DeleteGlobalReplicationGroupResponse

    /**
     * Deletes an existing replication group. By default, this operation deletes the entire replication group, including the primary/primaries and all of the read replicas. If the replication group has only one primary, you can optionally delete only the read replicas, while retaining the primary by setting `RetainPrimaryCluster=true`.
     *
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.
     *
     * This operation is valid for Redis only.
     */
    public suspend fun deleteReplicationGroup(input: DeleteReplicationGroupRequest): DeleteReplicationGroupResponse

    /**
     * Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately begins deleting the snapshot; you cannot cancel or revert this operation.
     *
     * This operation is valid for Redis only.
     */
    public suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse

    /**
     * For Redis engine version 6.0 onwards: Deletes a user. The user will be removed from all user groups and in turn removed from all replication groups. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * For Redis engine version 6.0 onwards: Deletes a user group. The user group must first be disassociated from the replication group before it can be deleted. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    public suspend fun deleteUserGroup(input: DeleteUserGroupRequest): DeleteUserGroupResponse

    /**
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cache cluster if a cluster identifier is supplied.
     *
     * By default, abbreviated information about the clusters is returned. You can use the optional *ShowCacheNodeInfo* flag to retrieve detailed information about the cache nodes associated with the clusters. These details include the DNS address and port for the cache node endpoint.
     *
     * If the cluster is in the *creating* state, only cluster-level information is displayed until all of the nodes are successfully provisioned.
     *
     * If the cluster is in the *deleting* state, only cluster-level information is displayed.
     *
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the additional nodes are not displayed until they are completely provisioned. When the cluster state is *available*, the cluster is ready for use.
     *
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is displayed.
     */
    public suspend fun describeCacheClusters(input: DescribeCacheClustersRequest = DescribeCacheClustersRequest {}): DescribeCacheClustersResponse

    /**
     * Returns a list of the available cache engines and their versions.
     */
    public suspend fun describeCacheEngineVersions(input: DescribeCacheEngineVersionsRequest = DescribeCacheEngineVersionsRequest {}): DescribeCacheEngineVersionsResponse

    /**
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list contains only the descriptions for that group.
     */
    public suspend fun describeCacheParameterGroups(input: DescribeCacheParameterGroupsRequest = DescribeCacheParameterGroupsRequest {}): DescribeCacheParameterGroupsResponse

    /**
     * Returns the detailed parameter list for a particular cache parameter group.
     */
    public suspend fun describeCacheParameters(input: DescribeCacheParametersRequest): DescribeCacheParametersResponse

    /**
     * Returns a list of cache security group descriptions. If a cache security group name is specified, the list contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
     */
    public suspend fun describeCacheSecurityGroups(input: DescribeCacheSecurityGroupsRequest = DescribeCacheSecurityGroupsRequest {}): DescribeCacheSecurityGroupsResponse

    /**
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache clusters now launch in VPC by default.
     */
    public suspend fun describeCacheSubnetGroups(input: DescribeCacheSubnetGroupsRequest = DescribeCacheSubnetGroupsRequest {}): DescribeCacheSubnetGroupsResponse

    /**
     * Returns the default engine and system parameter information for the specified cache engine.
     */
    public suspend fun describeEngineDefaultParameters(input: DescribeEngineDefaultParametersRequest): DescribeEngineDefaultParametersResponse

    /**
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events specific to a particular cluster, cache security group, or cache parameter group by providing the name as a parameter.
     *
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.
     */
    public suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest {}): DescribeEventsResponse

    /**
     * Returns information about a particular global replication group. If no identifier is specified, returns information about all Global datastores.
     */
    public suspend fun describeGlobalReplicationGroups(input: DescribeGlobalReplicationGroupsRequest = DescribeGlobalReplicationGroupsRequest {}): DescribeGlobalReplicationGroupsResponse

    /**
     * Returns information about a particular replication group. If no identifier is specified, `DescribeReplicationGroups` returns information about all replication groups.
     *
     * This operation is valid for Redis only.
     */
    public suspend fun describeReplicationGroups(input: DescribeReplicationGroupsRequest = DescribeReplicationGroupsRequest {}): DescribeReplicationGroupsResponse

    /**
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     */
    public suspend fun describeReservedCacheNodes(input: DescribeReservedCacheNodesRequest = DescribeReservedCacheNodesRequest {}): DescribeReservedCacheNodesResponse

    /**
     * Lists available reserved cache node offerings.
     */
    public suspend fun describeReservedCacheNodesOfferings(input: DescribeReservedCacheNodesOfferingsRequest = DescribeReservedCacheNodesOfferingsRequest {}): DescribeReservedCacheNodesOfferingsResponse

    /**
     * Returns details of the service updates
     */
    public suspend fun describeServiceUpdates(input: DescribeServiceUpdatesRequest = DescribeServiceUpdatesRequest {}): DescribeServiceUpdatesResponse

    /**
     * Returns information about cluster or replication group snapshots. By default, `DescribeSnapshots` lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cache cluster.
     *
     * This operation is valid for Redis only.
     */
    public suspend fun describeSnapshots(input: DescribeSnapshotsRequest = DescribeSnapshotsRequest {}): DescribeSnapshotsResponse

    /**
     * Returns details of the update actions
     */
    public suspend fun describeUpdateActions(input: DescribeUpdateActionsRequest = DescribeUpdateActionsRequest {}): DescribeUpdateActionsResponse

    /**
     * Returns a list of user groups.
     */
    public suspend fun describeUserGroups(input: DescribeUserGroupsRequest = DescribeUserGroupsRequest {}): DescribeUserGroupsResponse

    /**
     * Returns a list of users.
     */
    public suspend fun describeUsers(input: DescribeUsersRequest = DescribeUsersRequest {}): DescribeUsersResponse

    /**
     * Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon region.
     */
    public suspend fun disassociateGlobalReplicationGroup(input: DisassociateGlobalReplicationGroupRequest): DisassociateGlobalReplicationGroupResponse

    /**
     * Used to failover the primary region to a secondary region. The secondary region will become primary, and all other clusters will become secondary.
     */
    public suspend fun failoverGlobalReplicationGroup(input: FailoverGlobalReplicationGroupRequest): FailoverGlobalReplicationGroupResponse

    /**
     * Increase the number of node groups in the Global datastore
     */
    public suspend fun increaseNodeGroupsInGlobalReplicationGroup(input: IncreaseNodeGroupsInGlobalReplicationGroupRequest): IncreaseNodeGroupsInGlobalReplicationGroupResponse

    /**
     * Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
     */
    public suspend fun increaseReplicaCount(input: IncreaseReplicaCountRequest): IncreaseReplicaCountResponse

    /**
     * Lists all available node types that you can scale your Redis cluster's or replication group's current node type.
     *
     * When you use the `ModifyCacheCluster` or `ModifyReplicationGroup` operations to scale your cluster or replication group, the value of the `CacheNodeType` parameter must be one of the node types returned by this operation.
     */
    public suspend fun listAllowedNodeTypeModifications(input: ListAllowedNodeTypeModificationsRequest = ListAllowedNodeTypeModificationsRequest {}): ListAllowedNodeTypeModificationsResponse

    /**
     * Lists all tags currently on a named resource.
     *
     *  A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     *
     * If the cluster is not in the *available* state, `ListTagsForResource` returns an error.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration parameters by specifying the parameters and the new values.
     */
    public suspend fun modifyCacheCluster(input: ModifyCacheClusterRequest): ModifyCacheClusterResponse

    /**
     * Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
     */
    public suspend fun modifyCacheParameterGroup(input: ModifyCacheParameterGroupRequest): ModifyCacheParameterGroupResponse

    /**
     * Modifies an existing cache subnet group.
     */
    public suspend fun modifyCacheSubnetGroup(input: ModifyCacheSubnetGroupRequest): ModifyCacheSubnetGroupResponse

    /**
     * Modifies the settings for a Global datastore.
     */
    public suspend fun modifyGlobalReplicationGroup(input: ModifyGlobalReplicationGroupRequest): ModifyGlobalReplicationGroupResponse

    /**
     * Modifies the settings for a replication group.
     * + [Scaling for Amazon ElastiCache for Redis (cluster mode enabled)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html) in the ElastiCache User Guide
     * + [ModifyReplicationGroupShardConfiguration](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html) in the ElastiCache API Reference
     *
     * This operation is valid for Redis only.
     */
    public suspend fun modifyReplicationGroup(input: ModifyReplicationGroupRequest): ModifyReplicationGroupResponse

    /**
     * Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance the keyspaces among existing shards.
     */
    public suspend fun modifyReplicationGroupShardConfiguration(input: ModifyReplicationGroupShardConfigurationRequest): ModifyReplicationGroupShardConfigurationResponse

    /**
     * Changes user password(s) and/or access string.
     */
    public suspend fun modifyUser(input: ModifyUserRequest): ModifyUserResponse

    /**
     * Changes the list of users that belong to the user group.
     */
    public suspend fun modifyUserGroup(input: ModifyUserGroupRequest): ModifyUserGroupResponse

    /**
     * Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are non-refundable. For more information, see [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/reserved-nodes.html) for Redis or [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/reserved-nodes.html) for Memcached.
     */
    public suspend fun purchaseReservedCacheNodesOffering(input: PurchaseReservedCacheNodesOfferingRequest): PurchaseReservedCacheNodesOfferingResponse

    /**
     * Redistribute slots to ensure uniform distribution across existing shards in the cluster.
     */
    public suspend fun rebalanceSlotsInGlobalReplicationGroup(input: RebalanceSlotsInGlobalReplicationGroupRequest): RebalanceSlotsInGlobalReplicationGroupResponse

    /**
     * Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
     *
     * The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.
     *
     * When the reboot is complete, a cluster event is created.
     *
     * Rebooting a cluster is currently supported on Memcached and Redis (cluster mode disabled) clusters. Rebooting is not supported on Redis (cluster mode enabled) clusters.
     *
     * If you make changes to parameters that require a Redis (cluster mode enabled) cluster reboot for the changes to be applied, see [Rebooting a Cluster](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes.rebooting.html) for an alternate process.
     */
    public suspend fun rebootCacheCluster(input: RebootCacheClusterRequest): RebootCacheClusterResponse

    /**
     * Removes the tags identified by the `TagKeys` list from the named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     */
    public suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the `ResetAllParameters` and `CacheParameterGroupName` parameters.
     */
    public suspend fun resetCacheParameterGroup(input: ResetCacheParameterGroupRequest): ResetCacheParameterGroupResponse

    /**
     * Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security group that had been previously authorized.
     */
    public suspend fun revokeCacheSecurityGroupIngress(input: RevokeCacheSecurityGroupIngressRequest): RevokeCacheSecurityGroupIngressResponse

    /**
     * Start the migration of data.
     */
    public suspend fun startMigration(input: StartMigrationRequest): StartMigrationResponse

    /**
     * Represents the input of a `TestFailover` operation which test automatic failover on a specified node group (called shard in the console) in a replication group (called cluster in the console).
     *
     * This API is designed for testing the behavior of your application in case of ElastiCache failover. It is not designed to be an operational tool for initiating a failover to overcome a problem you may have with the cluster. Moreover, in certain conditions such as large-scale operational events, Amazon may block this API.
     *
     * **Note the following**
     * + A customer can use this operation to test automatic failover on up to 5 shards (called node groups in the ElastiCache API and Amazon CLI) in any rolling 24-hour period.
     * + If calling this operation on shards in different clusters (called replication groups in the API and CLI), the calls can be made concurrently.
     * + If calling this operation multiple times on different shards in the same Redis (cluster mode enabled) replication group, the first node replacement must complete before a subsequent call can be made.
     * + To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console, the Amazon CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in order of occurrance:
     *    + Replication group message: `Test Failover API called for node group <node-group-id>`
     *    + Cache cluster message: `Failover from primary node <primary-node-id> to replica node <node-id> completed`
     *    + Replication group message: `Failover from primary node <primary-node-id> to replica node <node-id> completed`
     *    + Cache cluster message: `Recovering cache nodes <node-id>`
     *    + Cache cluster message: `Finished recovery for cache nodes <node-id>`
     * For more information see:
     *    + [Viewing ElastiCache Events](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html) in the *ElastiCache User Guide*
     *    + [DescribeEvents](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html) in the ElastiCache API Reference
     *
     * Also see, [Testing Multi-AZ ](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test) in the *ElastiCache User Guide*.
     */
    public suspend fun testFailover(input: TestFailoverRequest): TestFailoverResponse

    /**
     * Async API to test connection between source and target replication group.
     */
    public suspend fun testMigration(input: TestMigrationRequest): TestMigrationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ElastiCacheClient.withConfig(block: ElastiCacheClient.Config.Builder.() -> Unit): ElastiCacheClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultElastiCacheClient(newConfig)
}

/**
 * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
 *
 *  For example, you can use cost-allocation tags to your ElastiCache resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services.
 *
 * For more information, see [Using Cost Allocation Tags in Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html) in the *ElastiCache User Guide*.
 */
public suspend inline fun ElastiCacheClient.addTagsToResource(crossinline block: AddTagsToResourceRequest.Builder.() -> Unit): AddTagsToResourceResponse = addTagsToResource(AddTagsToResourceRequest.Builder().apply(block).build())

/**
 * Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2, and Amazon EC2 security groups are used as the authorization mechanism.
 *
 * You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another region.
 */
public suspend inline fun ElastiCacheClient.authorizeCacheSecurityGroupIngress(crossinline block: AuthorizeCacheSecurityGroupIngressRequest.Builder.() -> Unit): AuthorizeCacheSecurityGroupIngressResponse = authorizeCacheSecurityGroupIngress(AuthorizeCacheSecurityGroupIngressRequest.Builder().apply(block).build())

/**
 * Apply the service update. For more information on service updates and applying them, see [Applying Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html).
 */
public suspend inline fun ElastiCacheClient.batchApplyUpdateAction(crossinline block: BatchApplyUpdateActionRequest.Builder.() -> Unit): BatchApplyUpdateActionResponse = batchApplyUpdateAction(BatchApplyUpdateActionRequest.Builder().apply(block).build())

/**
 * Stop the service update. For more information on service updates and stopping them, see [Stopping Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html).
 */
public suspend inline fun ElastiCacheClient.batchStopUpdateAction(crossinline block: BatchStopUpdateActionRequest.Builder.() -> Unit): BatchStopUpdateActionResponse = batchStopUpdateAction(BatchStopUpdateActionRequest.Builder().apply(block).build())

/**
 * Complete the migration of data.
 */
public suspend inline fun ElastiCacheClient.completeMigration(crossinline block: CompleteMigrationRequest.Builder.() -> Unit): CompleteMigrationResponse = completeMigration(CompleteMigrationRequest.Builder().apply(block).build())

/**
 * Makes a copy of an existing snapshot.
 *
 * This operation is valid for Redis only.
 *
 * Users or groups that have permissions to use the `CopySnapshot` operation can create their own Amazon S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has the ability to use the `CopySnapshot` operation. For more information about using IAM to control the use of ElastiCache operations, see [Exporting Snapshots](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html) and [Authentication & Access Control](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html).
 *
 * You could receive the following error messages.
 *
 * **Error Messages**
 * + **Error Message:** The S3 bucket %s is outside of the region.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
 * + **Error Message:** The S3 bucket %s does not exist.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
 * + **Error Message:** The S3 bucket %s is not owned by the authenticated user.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
 * + **Error Message:** The authenticated user does not have sufficient permissions to perform the desired activity.**Solution:** Contact your system administrator to get the needed permissions.
 * + **Error Message:** The S3 bucket %s already contains an object with key %s.**Solution:** Give the `TargetSnapshotName` a new and unique value. If exporting a snapshot, you could alternatively create a new Amazon S3 bucket and use this same value for `TargetSnapshotName`.
 * + **Error Message: ** ElastiCache has not been granted READ permissions %s on the S3 Bucket.**Solution:** Add List and Read permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
 * + **Error Message: ** ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.**Solution:** Add Upload/Delete permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
 * + **Error Message: ** ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.**Solution:** Add View Permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
 */
public suspend inline fun ElastiCacheClient.copySnapshot(crossinline block: CopySnapshotRequest.Builder.() -> Unit): CopySnapshotResponse = copySnapshot(CopySnapshotRequest.Builder().apply(block).build())

/**
 * Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either Memcached or Redis.
 *
 * This operation is not supported for Redis (cluster mode enabled) clusters.
 */
public suspend inline fun ElastiCacheClient.createCacheCluster(crossinline block: CreateCacheClusterRequest.Builder.() -> Unit): CreateCacheClusterResponse = createCacheCluster(CreateCacheClusterRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster or replication group using the CacheParameterGroup.
 *
 * A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of specific parameters. For more information, see:
 * + [ModifyCacheParameterGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html) in the ElastiCache API Reference.
 * + [Parameters and Parameter Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html) in the ElastiCache User Guide.
 */
public suspend inline fun ElastiCacheClient.createCacheParameterGroup(crossinline block: CreateCacheParameterGroupRequest.Builder.() -> Unit): CreateCacheParameterGroupResponse = createCacheParameterGroup(CreateCacheParameterGroupRequest.Builder().apply(block).build())

/**
 * Creates a new cache security group. Use a cache security group to control access to one or more clusters.
 *
 * Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more information, see [CreateCacheSubnetGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html).
 */
public suspend inline fun ElastiCacheClient.createCacheSecurityGroup(crossinline block: CreateCacheSecurityGroupRequest.Builder.() -> Unit): CreateCacheSecurityGroupResponse = createCacheSecurityGroup(CreateCacheSecurityGroupRequest.Builder().apply(block).build())

/**
 * Creates a new cache subnet group.
 *
 * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
 */
public suspend inline fun ElastiCacheClient.createCacheSubnetGroup(crossinline block: CreateCacheSubnetGroupRequest.Builder.() -> Unit): CreateCacheSubnetGroupResponse = createCacheSubnetGroup(CreateCacheSubnetGroupRequest.Builder().apply(block).build())

/**
 * Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable low-latency reads and disaster recovery across regions. For more information, see [Replication Across Regions Using Global Datastore](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html).
 * + The **GlobalReplicationGroupIdSuffix** is the name of the Global datastore.
 * + The **PrimaryReplicationGroupId** represents the name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.
 */
public suspend inline fun ElastiCacheClient.createGlobalReplicationGroup(crossinline block: CreateGlobalReplicationGroupRequest.Builder.() -> Unit): CreateGlobalReplicationGroupResponse = createGlobalReplicationGroup(CreateGlobalReplicationGroupRequest.Builder().apply(block).build())

/**
 * Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.
 *
 * This API can be used to create a standalone regional replication group or a secondary replication group associated with a Global datastore.
 *
 * A Redis (cluster mode disabled) replication group is a collection of clusters, where one of the clusters is a read/write primary and the others are read-only replicas. Writes to the primary are asynchronously propagated to the replicas.
 *
 * A Redis cluster-mode enabled cluster is comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas to 15 shards and 5 replicas, which is the maximum number or replicas allowed.
 *
 * The node or shard limit can be increased to a maximum of 500 per cluster if the Redis engine version is 5.0.6 or higher. For example, you can choose to configure a 500 node cluster that ranges between 83 shards (one primary and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there are enough available IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet group have too small a CIDR range or the subnets are shared and heavily used by other clusters. For more information, see [Creating a Subnet Group](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html). For versions below 5.0.6, the limit is 250 per cluster.
 *
 * To request a limit increase, see [Amazon Service Limits](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) and choose the limit type **Nodes per cluster per instance type**.
 *
 * When a Redis (cluster mode disabled) replication group has been successfully created, you can add one or more read replicas to it, up to a total of 5 read replicas. If you need to increase or decrease the number of node groups (console: shards), you can avail yourself of ElastiCache for Redis' scaling. For more information, see [Scaling ElastiCache for Redis Clusters](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html) in the *ElastiCache User Guide*.
 *
 * This operation is valid for Redis only.
 */
public suspend inline fun ElastiCacheClient.createReplicationGroup(crossinline block: CreateReplicationGroupRequest.Builder.() -> Unit): CreateReplicationGroupResponse = createReplicationGroup(CreateReplicationGroupRequest.Builder().apply(block).build())

/**
 * Creates a copy of an entire cluster or replication group at a specific moment in time.
 *
 * This operation is valid for Redis only.
 */
public suspend inline fun ElastiCacheClient.createSnapshot(crossinline block: CreateSnapshotRequest.Builder.() -> Unit): CreateSnapshotResponse = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

/**
 * For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
 */
public suspend inline fun ElastiCacheClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit): CreateUserResponse = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * For Redis engine version 6.0 onwards: Creates a Redis user group. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html)
 */
public suspend inline fun ElastiCacheClient.createUserGroup(crossinline block: CreateUserGroupRequest.Builder.() -> Unit): CreateUserGroupResponse = createUserGroup(CreateUserGroupRequest.Builder().apply(block).build())

/**
 * Decreases the number of node groups in a Global datastore
 */
public suspend inline fun ElastiCacheClient.decreaseNodeGroupsInGlobalReplicationGroup(crossinline block: DecreaseNodeGroupsInGlobalReplicationGroupRequest.Builder.() -> Unit): DecreaseNodeGroupsInGlobalReplicationGroupResponse = decreaseNodeGroupsInGlobalReplicationGroup(DecreaseNodeGroupsInGlobalReplicationGroupRequest.Builder().apply(block).build())

/**
 * Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
 */
public suspend inline fun ElastiCacheClient.decreaseReplicaCount(crossinline block: DecreaseReplicaCountRequest.Builder.() -> Unit): DecreaseReplicaCountResponse = decreaseReplicaCount(DecreaseReplicaCountRequest.Builder().apply(block).build())

/**
 * Deletes a previously provisioned cluster. `DeleteCacheCluster` deletes all associated cache nodes, node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.
 *
 * This operation is not valid for:
 * + Redis (cluster mode enabled) clusters
 * + Redis (cluster mode disabled) clusters
 * + A cluster that is the last read replica of a replication group
 * + A cluster that is the primary node of a replication group
 * + A node group (shard) that has Multi-AZ mode enabled
 * + A cluster from a Redis (cluster mode enabled) replication group
 * + A cluster that is not in the `available` state
 */
public suspend inline fun ElastiCacheClient.deleteCacheCluster(crossinline block: DeleteCacheClusterRequest.Builder.() -> Unit): DeleteCacheClusterResponse = deleteCacheCluster(DeleteCacheClusterRequest.Builder().apply(block).build())

/**
 * Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with any cache clusters. You cannot delete the default cache parameter groups in your account.
 */
public suspend inline fun ElastiCacheClient.deleteCacheParameterGroup(crossinline block: DeleteCacheParameterGroupRequest.Builder.() -> Unit): DeleteCacheParameterGroupResponse = deleteCacheParameterGroup(DeleteCacheParameterGroupRequest.Builder().apply(block).build())

/**
 * Deletes a cache security group.
 *
 * You cannot delete a cache security group if it is associated with any clusters.
 */
public suspend inline fun ElastiCacheClient.deleteCacheSecurityGroup(crossinline block: DeleteCacheSecurityGroupRequest.Builder.() -> Unit): DeleteCacheSecurityGroupResponse = deleteCacheSecurityGroup(DeleteCacheSecurityGroupRequest.Builder().apply(block).build())

/**
 * Deletes a cache subnet group.
 *
 * You cannot delete a default cache subnet group or one that is associated with any clusters.
 */
public suspend inline fun ElastiCacheClient.deleteCacheSubnetGroup(crossinline block: DeleteCacheSubnetGroupRequest.Builder.() -> Unit): DeleteCacheSubnetGroupResponse = deleteCacheSubnetGroup(DeleteCacheSubnetGroupRequest.Builder().apply(block).build())

/**
 * Deleting a Global datastore is a two-step process:
 * + First, you must DisassociateGlobalReplicationGroup to remove the secondary clusters in the Global datastore.
 * + Once the Global datastore contains only the primary cluster, you can use the `DeleteGlobalReplicationGroup` API to delete the Global datastore while retainining the primary cluster using `RetainPrimaryReplicationGroup=true`.
 *
 * Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the primary by setting `RetainPrimaryReplicationGroup=true`. The primary cluster is never deleted when deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore.
 *
 * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.
 */
public suspend inline fun ElastiCacheClient.deleteGlobalReplicationGroup(crossinline block: DeleteGlobalReplicationGroupRequest.Builder.() -> Unit): DeleteGlobalReplicationGroupResponse = deleteGlobalReplicationGroup(DeleteGlobalReplicationGroupRequest.Builder().apply(block).build())

/**
 * Deletes an existing replication group. By default, this operation deletes the entire replication group, including the primary/primaries and all of the read replicas. If the replication group has only one primary, you can optionally delete only the read replicas, while retaining the primary by setting `RetainPrimaryCluster=true`.
 *
 * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.
 *
 * This operation is valid for Redis only.
 */
public suspend inline fun ElastiCacheClient.deleteReplicationGroup(crossinline block: DeleteReplicationGroupRequest.Builder.() -> Unit): DeleteReplicationGroupResponse = deleteReplicationGroup(DeleteReplicationGroupRequest.Builder().apply(block).build())

/**
 * Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately begins deleting the snapshot; you cannot cancel or revert this operation.
 *
 * This operation is valid for Redis only.
 */
public suspend inline fun ElastiCacheClient.deleteSnapshot(crossinline block: DeleteSnapshotRequest.Builder.() -> Unit): DeleteSnapshotResponse = deleteSnapshot(DeleteSnapshotRequest.Builder().apply(block).build())

/**
 * For Redis engine version 6.0 onwards: Deletes a user. The user will be removed from all user groups and in turn removed from all replication groups. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
 */
public suspend inline fun ElastiCacheClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * For Redis engine version 6.0 onwards: Deletes a user group. The user group must first be disassociated from the replication group before it can be deleted. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
 */
public suspend inline fun ElastiCacheClient.deleteUserGroup(crossinline block: DeleteUserGroupRequest.Builder.() -> Unit): DeleteUserGroupResponse = deleteUserGroup(DeleteUserGroupRequest.Builder().apply(block).build())

/**
 * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cache cluster if a cluster identifier is supplied.
 *
 * By default, abbreviated information about the clusters is returned. You can use the optional *ShowCacheNodeInfo* flag to retrieve detailed information about the cache nodes associated with the clusters. These details include the DNS address and port for the cache node endpoint.
 *
 * If the cluster is in the *creating* state, only cluster-level information is displayed until all of the nodes are successfully provisioned.
 *
 * If the cluster is in the *deleting* state, only cluster-level information is displayed.
 *
 * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the additional nodes are not displayed until they are completely provisioned. When the cluster state is *available*, the cluster is ready for use.
 *
 * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is displayed.
 */
public suspend inline fun ElastiCacheClient.describeCacheClusters(crossinline block: DescribeCacheClustersRequest.Builder.() -> Unit): DescribeCacheClustersResponse = describeCacheClusters(DescribeCacheClustersRequest.Builder().apply(block).build())

/**
 * Returns a list of the available cache engines and their versions.
 */
public suspend inline fun ElastiCacheClient.describeCacheEngineVersions(crossinline block: DescribeCacheEngineVersionsRequest.Builder.() -> Unit): DescribeCacheEngineVersionsResponse = describeCacheEngineVersions(DescribeCacheEngineVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list contains only the descriptions for that group.
 */
public suspend inline fun ElastiCacheClient.describeCacheParameterGroups(crossinline block: DescribeCacheParameterGroupsRequest.Builder.() -> Unit): DescribeCacheParameterGroupsResponse = describeCacheParameterGroups(DescribeCacheParameterGroupsRequest.Builder().apply(block).build())

/**
 * Returns the detailed parameter list for a particular cache parameter group.
 */
public suspend inline fun ElastiCacheClient.describeCacheParameters(crossinline block: DescribeCacheParametersRequest.Builder.() -> Unit): DescribeCacheParametersResponse = describeCacheParameters(DescribeCacheParametersRequest.Builder().apply(block).build())

/**
 * Returns a list of cache security group descriptions. If a cache security group name is specified, the list contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
 */
public suspend inline fun ElastiCacheClient.describeCacheSecurityGroups(crossinline block: DescribeCacheSecurityGroupsRequest.Builder.() -> Unit): DescribeCacheSecurityGroupsResponse = describeCacheSecurityGroups(DescribeCacheSecurityGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache clusters now launch in VPC by default.
 */
public suspend inline fun ElastiCacheClient.describeCacheSubnetGroups(crossinline block: DescribeCacheSubnetGroupsRequest.Builder.() -> Unit): DescribeCacheSubnetGroupsResponse = describeCacheSubnetGroups(DescribeCacheSubnetGroupsRequest.Builder().apply(block).build())

/**
 * Returns the default engine and system parameter information for the specified cache engine.
 */
public suspend inline fun ElastiCacheClient.describeEngineDefaultParameters(crossinline block: DescribeEngineDefaultParametersRequest.Builder.() -> Unit): DescribeEngineDefaultParametersResponse = describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest.Builder().apply(block).build())

/**
 * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events specific to a particular cluster, cache security group, or cache parameter group by providing the name as a parameter.
 *
 * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.
 */
public suspend inline fun ElastiCacheClient.describeEvents(crossinline block: DescribeEventsRequest.Builder.() -> Unit): DescribeEventsResponse = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

/**
 * Returns information about a particular global replication group. If no identifier is specified, returns information about all Global datastores.
 */
public suspend inline fun ElastiCacheClient.describeGlobalReplicationGroups(crossinline block: DescribeGlobalReplicationGroupsRequest.Builder.() -> Unit): DescribeGlobalReplicationGroupsResponse = describeGlobalReplicationGroups(DescribeGlobalReplicationGroupsRequest.Builder().apply(block).build())

/**
 * Returns information about a particular replication group. If no identifier is specified, `DescribeReplicationGroups` returns information about all replication groups.
 *
 * This operation is valid for Redis only.
 */
public suspend inline fun ElastiCacheClient.describeReplicationGroups(crossinline block: DescribeReplicationGroupsRequest.Builder.() -> Unit): DescribeReplicationGroupsResponse = describeReplicationGroups(DescribeReplicationGroupsRequest.Builder().apply(block).build())

/**
 * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
 */
public suspend inline fun ElastiCacheClient.describeReservedCacheNodes(crossinline block: DescribeReservedCacheNodesRequest.Builder.() -> Unit): DescribeReservedCacheNodesResponse = describeReservedCacheNodes(DescribeReservedCacheNodesRequest.Builder().apply(block).build())

/**
 * Lists available reserved cache node offerings.
 */
public suspend inline fun ElastiCacheClient.describeReservedCacheNodesOfferings(crossinline block: DescribeReservedCacheNodesOfferingsRequest.Builder.() -> Unit): DescribeReservedCacheNodesOfferingsResponse = describeReservedCacheNodesOfferings(DescribeReservedCacheNodesOfferingsRequest.Builder().apply(block).build())

/**
 * Returns details of the service updates
 */
public suspend inline fun ElastiCacheClient.describeServiceUpdates(crossinline block: DescribeServiceUpdatesRequest.Builder.() -> Unit): DescribeServiceUpdatesResponse = describeServiceUpdates(DescribeServiceUpdatesRequest.Builder().apply(block).build())

/**
 * Returns information about cluster or replication group snapshots. By default, `DescribeSnapshots` lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cache cluster.
 *
 * This operation is valid for Redis only.
 */
public suspend inline fun ElastiCacheClient.describeSnapshots(crossinline block: DescribeSnapshotsRequest.Builder.() -> Unit): DescribeSnapshotsResponse = describeSnapshots(DescribeSnapshotsRequest.Builder().apply(block).build())

/**
 * Returns details of the update actions
 */
public suspend inline fun ElastiCacheClient.describeUpdateActions(crossinline block: DescribeUpdateActionsRequest.Builder.() -> Unit): DescribeUpdateActionsResponse = describeUpdateActions(DescribeUpdateActionsRequest.Builder().apply(block).build())

/**
 * Returns a list of user groups.
 */
public suspend inline fun ElastiCacheClient.describeUserGroups(crossinline block: DescribeUserGroupsRequest.Builder.() -> Unit): DescribeUserGroupsResponse = describeUserGroups(DescribeUserGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of users.
 */
public suspend inline fun ElastiCacheClient.describeUsers(crossinline block: DescribeUsersRequest.Builder.() -> Unit): DescribeUsersResponse = describeUsers(DescribeUsersRequest.Builder().apply(block).build())

/**
 * Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon region.
 */
public suspend inline fun ElastiCacheClient.disassociateGlobalReplicationGroup(crossinline block: DisassociateGlobalReplicationGroupRequest.Builder.() -> Unit): DisassociateGlobalReplicationGroupResponse = disassociateGlobalReplicationGroup(DisassociateGlobalReplicationGroupRequest.Builder().apply(block).build())

/**
 * Used to failover the primary region to a secondary region. The secondary region will become primary, and all other clusters will become secondary.
 */
public suspend inline fun ElastiCacheClient.failoverGlobalReplicationGroup(crossinline block: FailoverGlobalReplicationGroupRequest.Builder.() -> Unit): FailoverGlobalReplicationGroupResponse = failoverGlobalReplicationGroup(FailoverGlobalReplicationGroupRequest.Builder().apply(block).build())

/**
 * Increase the number of node groups in the Global datastore
 */
public suspend inline fun ElastiCacheClient.increaseNodeGroupsInGlobalReplicationGroup(crossinline block: IncreaseNodeGroupsInGlobalReplicationGroupRequest.Builder.() -> Unit): IncreaseNodeGroupsInGlobalReplicationGroupResponse = increaseNodeGroupsInGlobalReplicationGroup(IncreaseNodeGroupsInGlobalReplicationGroupRequest.Builder().apply(block).build())

/**
 * Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
 */
public suspend inline fun ElastiCacheClient.increaseReplicaCount(crossinline block: IncreaseReplicaCountRequest.Builder.() -> Unit): IncreaseReplicaCountResponse = increaseReplicaCount(IncreaseReplicaCountRequest.Builder().apply(block).build())

/**
 * Lists all available node types that you can scale your Redis cluster's or replication group's current node type.
 *
 * When you use the `ModifyCacheCluster` or `ModifyReplicationGroup` operations to scale your cluster or replication group, the value of the `CacheNodeType` parameter must be one of the node types returned by this operation.
 */
public suspend inline fun ElastiCacheClient.listAllowedNodeTypeModifications(crossinline block: ListAllowedNodeTypeModificationsRequest.Builder.() -> Unit): ListAllowedNodeTypeModificationsResponse = listAllowedNodeTypeModifications(ListAllowedNodeTypeModificationsRequest.Builder().apply(block).build())

/**
 * Lists all tags currently on a named resource.
 *
 *  A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
 *
 * If the cluster is not in the *available* state, `ListTagsForResource` returns an error.
 */
public suspend inline fun ElastiCacheClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration parameters by specifying the parameters and the new values.
 */
public suspend inline fun ElastiCacheClient.modifyCacheCluster(crossinline block: ModifyCacheClusterRequest.Builder.() -> Unit): ModifyCacheClusterResponse = modifyCacheCluster(ModifyCacheClusterRequest.Builder().apply(block).build())

/**
 * Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
 */
public suspend inline fun ElastiCacheClient.modifyCacheParameterGroup(crossinline block: ModifyCacheParameterGroupRequest.Builder.() -> Unit): ModifyCacheParameterGroupResponse = modifyCacheParameterGroup(ModifyCacheParameterGroupRequest.Builder().apply(block).build())

/**
 * Modifies an existing cache subnet group.
 */
public suspend inline fun ElastiCacheClient.modifyCacheSubnetGroup(crossinline block: ModifyCacheSubnetGroupRequest.Builder.() -> Unit): ModifyCacheSubnetGroupResponse = modifyCacheSubnetGroup(ModifyCacheSubnetGroupRequest.Builder().apply(block).build())

/**
 * Modifies the settings for a Global datastore.
 */
public suspend inline fun ElastiCacheClient.modifyGlobalReplicationGroup(crossinline block: ModifyGlobalReplicationGroupRequest.Builder.() -> Unit): ModifyGlobalReplicationGroupResponse = modifyGlobalReplicationGroup(ModifyGlobalReplicationGroupRequest.Builder().apply(block).build())

/**
 * Modifies the settings for a replication group.
 * + [Scaling for Amazon ElastiCache for Redis (cluster mode enabled)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html) in the ElastiCache User Guide
 * + [ModifyReplicationGroupShardConfiguration](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html) in the ElastiCache API Reference
 *
 * This operation is valid for Redis only.
 */
public suspend inline fun ElastiCacheClient.modifyReplicationGroup(crossinline block: ModifyReplicationGroupRequest.Builder.() -> Unit): ModifyReplicationGroupResponse = modifyReplicationGroup(ModifyReplicationGroupRequest.Builder().apply(block).build())

/**
 * Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance the keyspaces among existing shards.
 */
public suspend inline fun ElastiCacheClient.modifyReplicationGroupShardConfiguration(crossinline block: ModifyReplicationGroupShardConfigurationRequest.Builder.() -> Unit): ModifyReplicationGroupShardConfigurationResponse = modifyReplicationGroupShardConfiguration(ModifyReplicationGroupShardConfigurationRequest.Builder().apply(block).build())

/**
 * Changes user password(s) and/or access string.
 */
public suspend inline fun ElastiCacheClient.modifyUser(crossinline block: ModifyUserRequest.Builder.() -> Unit): ModifyUserResponse = modifyUser(ModifyUserRequest.Builder().apply(block).build())

/**
 * Changes the list of users that belong to the user group.
 */
public suspend inline fun ElastiCacheClient.modifyUserGroup(crossinline block: ModifyUserGroupRequest.Builder.() -> Unit): ModifyUserGroupResponse = modifyUserGroup(ModifyUserGroupRequest.Builder().apply(block).build())

/**
 * Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are non-refundable. For more information, see [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/reserved-nodes.html) for Redis or [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/reserved-nodes.html) for Memcached.
 */
public suspend inline fun ElastiCacheClient.purchaseReservedCacheNodesOffering(crossinline block: PurchaseReservedCacheNodesOfferingRequest.Builder.() -> Unit): PurchaseReservedCacheNodesOfferingResponse = purchaseReservedCacheNodesOffering(PurchaseReservedCacheNodesOfferingRequest.Builder().apply(block).build())

/**
 * Redistribute slots to ensure uniform distribution across existing shards in the cluster.
 */
public suspend inline fun ElastiCacheClient.rebalanceSlotsInGlobalReplicationGroup(crossinline block: RebalanceSlotsInGlobalReplicationGroupRequest.Builder.() -> Unit): RebalanceSlotsInGlobalReplicationGroupResponse = rebalanceSlotsInGlobalReplicationGroup(RebalanceSlotsInGlobalReplicationGroupRequest.Builder().apply(block).build())

/**
 * Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
 *
 * The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.
 *
 * When the reboot is complete, a cluster event is created.
 *
 * Rebooting a cluster is currently supported on Memcached and Redis (cluster mode disabled) clusters. Rebooting is not supported on Redis (cluster mode enabled) clusters.
 *
 * If you make changes to parameters that require a Redis (cluster mode enabled) cluster reboot for the changes to be applied, see [Rebooting a Cluster](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes.rebooting.html) for an alternate process.
 */
public suspend inline fun ElastiCacheClient.rebootCacheCluster(crossinline block: RebootCacheClusterRequest.Builder.() -> Unit): RebootCacheClusterResponse = rebootCacheCluster(RebootCacheClusterRequest.Builder().apply(block).build())

/**
 * Removes the tags identified by the `TagKeys` list from the named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
 */
public suspend inline fun ElastiCacheClient.removeTagsFromResource(crossinline block: RemoveTagsFromResourceRequest.Builder.() -> Unit): RemoveTagsFromResourceResponse = removeTagsFromResource(RemoveTagsFromResourceRequest.Builder().apply(block).build())

/**
 * Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the `ResetAllParameters` and `CacheParameterGroupName` parameters.
 */
public suspend inline fun ElastiCacheClient.resetCacheParameterGroup(crossinline block: ResetCacheParameterGroupRequest.Builder.() -> Unit): ResetCacheParameterGroupResponse = resetCacheParameterGroup(ResetCacheParameterGroupRequest.Builder().apply(block).build())

/**
 * Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security group that had been previously authorized.
 */
public suspend inline fun ElastiCacheClient.revokeCacheSecurityGroupIngress(crossinline block: RevokeCacheSecurityGroupIngressRequest.Builder.() -> Unit): RevokeCacheSecurityGroupIngressResponse = revokeCacheSecurityGroupIngress(RevokeCacheSecurityGroupIngressRequest.Builder().apply(block).build())

/**
 * Start the migration of data.
 */
public suspend inline fun ElastiCacheClient.startMigration(crossinline block: StartMigrationRequest.Builder.() -> Unit): StartMigrationResponse = startMigration(StartMigrationRequest.Builder().apply(block).build())

/**
 * Represents the input of a `TestFailover` operation which test automatic failover on a specified node group (called shard in the console) in a replication group (called cluster in the console).
 *
 * This API is designed for testing the behavior of your application in case of ElastiCache failover. It is not designed to be an operational tool for initiating a failover to overcome a problem you may have with the cluster. Moreover, in certain conditions such as large-scale operational events, Amazon may block this API.
 *
 * **Note the following**
 * + A customer can use this operation to test automatic failover on up to 5 shards (called node groups in the ElastiCache API and Amazon CLI) in any rolling 24-hour period.
 * + If calling this operation on shards in different clusters (called replication groups in the API and CLI), the calls can be made concurrently.
 * + If calling this operation multiple times on different shards in the same Redis (cluster mode enabled) replication group, the first node replacement must complete before a subsequent call can be made.
 * + To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console, the Amazon CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in order of occurrance:
 *    + Replication group message: `Test Failover API called for node group <node-group-id>`
 *    + Cache cluster message: `Failover from primary node <primary-node-id> to replica node <node-id> completed`
 *    + Replication group message: `Failover from primary node <primary-node-id> to replica node <node-id> completed`
 *    + Cache cluster message: `Recovering cache nodes <node-id>`
 *    + Cache cluster message: `Finished recovery for cache nodes <node-id>`
 * For more information see:
 *    + [Viewing ElastiCache Events](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html) in the *ElastiCache User Guide*
 *    + [DescribeEvents](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html) in the ElastiCache API Reference
 *
 * Also see, [Testing Multi-AZ ](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test) in the *ElastiCache User Guide*.
 */
public suspend inline fun ElastiCacheClient.testFailover(crossinline block: TestFailoverRequest.Builder.() -> Unit): TestFailoverResponse = testFailover(TestFailoverRequest.Builder().apply(block).build())

/**
 * Async API to test connection between source and target replication group.
 */
public suspend inline fun ElastiCacheClient.testMigration(crossinline block: TestMigrationRequest.Builder.() -> Unit): TestMigrationResponse = testMigration(TestMigrationRequest.Builder().apply(block).build())
