// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.waiters

import aws.sdk.kotlin.services.elasticache.ElastiCacheClient
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheClustersResponse
import aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsRequest
import aws.sdk.kotlin.services.elasticache.model.DescribeReplicationGroupsResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until ElastiCache cluster is available.
 */
suspend fun ElastiCacheClient.waitUntilCacheClusterAvailable(request: DescribeCacheClustersRequest): Outcome<DescribeCacheClustersResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeCacheClustersRequest, DescribeCacheClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection?.any { it?.toString() == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection?.any { it?.toString() == "incompatible-network" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection?.any { it?.toString() == "restore-failed" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCacheClusters(request) }
}

/**
 * Wait until ElastiCache cluster is available.
 */
suspend fun ElastiCacheClient.waitUntilCacheClusterAvailable(block: DescribeCacheClustersRequest.Builder.() -> Unit): Outcome<DescribeCacheClustersResponse> =
    waitUntilCacheClusterAvailable(DescribeCacheClustersRequest.Builder().apply(block).build())

/**
 * Wait until ElastiCache cluster is deleted.
 */
suspend fun ElastiCacheClient.waitUntilCacheClusterDeleted(request: DescribeCacheClustersRequest): Outcome<DescribeCacheClustersResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeCacheClustersRequest, DescribeCacheClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "deleted" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "CacheClusterNotFound"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection?.any { it?.toString() == "available" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection?.any { it?.toString() == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection?.any { it?.toString() == "incompatible-network" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection?.any { it?.toString() == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection?.any { it?.toString() == "restore-failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val cacheClusters = it?.cacheClusters
            val cacheClustersOrEmpty = cacheClusters?.flattenIfPossible() ?: listOf()
            val projection = cacheClustersOrEmpty.flatMap {
                val cacheClusterStatus = it?.cacheClusterStatus
                listOfNotNull(cacheClusterStatus)
            }
            projection?.any { it?.toString() == "snapshotting" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCacheClusters(request) }
}

/**
 * Wait until ElastiCache cluster is deleted.
 */
suspend fun ElastiCacheClient.waitUntilCacheClusterDeleted(block: DescribeCacheClustersRequest.Builder.() -> Unit): Outcome<DescribeCacheClustersResponse> =
    waitUntilCacheClusterDeleted(DescribeCacheClustersRequest.Builder().apply(block).build())

/**
 * Wait until ElastiCache replication group is available.
 */
suspend fun ElastiCacheClient.waitUntilReplicationGroupAvailable(request: DescribeReplicationGroupsRequest): Outcome<DescribeReplicationGroupsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val replicationGroups = it?.replicationGroups
            val replicationGroupsOrEmpty = replicationGroups?.flattenIfPossible() ?: listOf()
            val projection = replicationGroupsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationGroups = it?.replicationGroups
            val replicationGroupsOrEmpty = replicationGroups?.flattenIfPossible() ?: listOf()
            val projection = replicationGroupsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "deleted" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeReplicationGroups(request) }
}

/**
 * Wait until ElastiCache replication group is available.
 */
suspend fun ElastiCacheClient.waitUntilReplicationGroupAvailable(block: DescribeReplicationGroupsRequest.Builder.() -> Unit): Outcome<DescribeReplicationGroupsResponse> =
    waitUntilReplicationGroupAvailable(DescribeReplicationGroupsRequest.Builder().apply(block).build())

/**
 * Wait until ElastiCache replication group is deleted.
 */
suspend fun ElastiCacheClient.waitUntilReplicationGroupDeleted(request: DescribeReplicationGroupsRequest): Outcome<DescribeReplicationGroupsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val replicationGroups = it?.replicationGroups
            val replicationGroupsOrEmpty = replicationGroups?.flattenIfPossible() ?: listOf()
            val projection = replicationGroupsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "deleted" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationGroups = it?.replicationGroups
            val replicationGroupsOrEmpty = replicationGroups?.flattenIfPossible() ?: listOf()
            val projection = replicationGroupsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection?.any { it?.toString() == "available" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ReplicationGroupNotFoundFault"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeReplicationGroups(request) }
}

/**
 * Wait until ElastiCache replication group is deleted.
 */
suspend fun ElastiCacheClient.waitUntilReplicationGroupDeleted(block: DescribeReplicationGroupsRequest.Builder.() -> Unit): Outcome<DescribeReplicationGroupsResponse> =
    waitUntilReplicationGroupDeleted(DescribeReplicationGroupsRequest.Builder().apply(block).build())
