// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticache.model.CacheSecurityGroup
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.RevokeCacheSecurityGroupIngressResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class RevokeCacheSecurityGroupIngressOperationDeserializer: HttpDeserialize<RevokeCacheSecurityGroupIngressResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RevokeCacheSecurityGroupIngressResponse {
        if (!response.status.isSuccess()) {
            throwRevokeCacheSecurityGroupIngressError(context, response)
        }
        val builder = RevokeCacheSecurityGroupIngressResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRevokeCacheSecurityGroupIngressOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRevokeCacheSecurityGroupIngressError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AuthorizationNotFound" -> AuthorizationNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "CacheSecurityGroupNotFound" -> CacheSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidCacheSecurityGroupState" -> InvalidCacheSecurityGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRevokeCacheSecurityGroupIngressOperationBody(builder: RevokeCacheSecurityGroupIngressResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("RevokeCacheSecurityGroupIngressResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("RevokeCacheSecurityGroupIngressResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap RevokeCacheSecurityGroupIngress response")
    }
    // end unwrap response wrapper

    val CACHESECURITYGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CacheSecurityGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("RevokeCacheSecurityGroupIngressResult"))
        field(CACHESECURITYGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CACHESECURITYGROUP_DESCRIPTOR.index -> builder.cacheSecurityGroup = deserializeCacheSecurityGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
