// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ModifyCacheParameterGroupResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ModifyCacheParameterGroupOperationDeserializer: HttpDeserialize<ModifyCacheParameterGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyCacheParameterGroupResponse {
        if (!response.status.isSuccess()) {
            throwModifyCacheParameterGroupError(context, response)
        }
        val builder = ModifyCacheParameterGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyCacheParameterGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifyCacheParameterGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CacheParameterGroupNotFound" -> CacheParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidCacheParameterGroupState" -> InvalidCacheParameterGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidGlobalReplicationGroupState" -> InvalidGlobalReplicationGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyCacheParameterGroupOperationBody(builder: ModifyCacheParameterGroupResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyCacheParameterGroupResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyCacheParameterGroupResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyCacheParameterGroup response")
    }
    // end unwrap response wrapper

    val CACHEPARAMETERGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("CacheParameterGroupName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("ModifyCacheParameterGroupResult"))
        field(CACHEPARAMETERGROUPNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CACHEPARAMETERGROUPNAME_DESCRIPTOR.index -> builder.cacheParameterGroupName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
