// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * A group of settings that are applied to the cluster in the future, or that are currently being applied.
 */
class PendingModifiedValues private constructor(builder: Builder) {
    /**
     * The auth token status
     */
    val authTokenStatus: aws.sdk.kotlin.services.elasticache.model.AuthTokenUpdateStatus? = builder.authTokenStatus
    /**
     * A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a 4-digit numeric identifier (0001, 0002, etc.).
     */
    val cacheNodeIdsToRemove: List<String>? = builder.cacheNodeIdsToRemove
    /**
     * The cache node type that this cluster or replication group is scaled to.
     */
    val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * The new cache engine version that the cluster runs.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The log delivery configurations being modified
     */
    val logDeliveryConfigurations: List<PendingLogDeliveryConfiguration>? = builder.logDeliveryConfigurations
    /**
     * The new number of cache nodes for the cluster.
     *
     * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
     */
    val numCacheNodes: kotlin.Int? = builder.numCacheNodes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PendingModifiedValues(")
        append("authTokenStatus=$authTokenStatus,")
        append("cacheNodeIdsToRemove=$cacheNodeIdsToRemove,")
        append("cacheNodeType=$cacheNodeType,")
        append("engineVersion=$engineVersion,")
        append("logDeliveryConfigurations=$logDeliveryConfigurations,")
        append("numCacheNodes=$numCacheNodes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authTokenStatus?.hashCode() ?: 0
        result = 31 * result + (cacheNodeIdsToRemove?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeType?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfigurations?.hashCode() ?: 0)
        result = 31 * result + (numCacheNodes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PendingModifiedValues

        if (authTokenStatus != other.authTokenStatus) return false
        if (cacheNodeIdsToRemove != other.cacheNodeIdsToRemove) return false
        if (cacheNodeType != other.cacheNodeType) return false
        if (engineVersion != other.engineVersion) return false
        if (logDeliveryConfigurations != other.logDeliveryConfigurations) return false
        if (numCacheNodes != other.numCacheNodes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues = Builder(this).apply(block).build()

    class Builder {
        /**
         * The auth token status
         */
        var authTokenStatus: aws.sdk.kotlin.services.elasticache.model.AuthTokenUpdateStatus? = null
        /**
         * A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a 4-digit numeric identifier (0001, 0002, etc.).
         */
        var cacheNodeIdsToRemove: List<String>? = null
        /**
         * The cache node type that this cluster or replication group is scaled to.
         */
        var cacheNodeType: kotlin.String? = null
        /**
         * The new cache engine version that the cluster runs.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The log delivery configurations being modified
         */
        var logDeliveryConfigurations: List<PendingLogDeliveryConfiguration>? = null
        /**
         * The new number of cache nodes for the cluster.
         *
         * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
         */
        var numCacheNodes: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues) : this() {
            this.authTokenStatus = x.authTokenStatus
            this.cacheNodeIdsToRemove = x.cacheNodeIdsToRemove
            this.cacheNodeType = x.cacheNodeType
            this.engineVersion = x.engineVersion
            this.logDeliveryConfigurations = x.logDeliveryConfigurations
            this.numCacheNodes = x.numCacheNodes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.PendingModifiedValues = PendingModifiedValues(this)
    }
}
