// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents an individual cache node in a snapshot of a cluster.
 */
class NodeSnapshot private constructor(builder: Builder) {
    /**
     * A unique identifier for the source cluster.
     */
    val cacheClusterId: kotlin.String? = builder.cacheClusterId
    /**
     * The date and time when the cache node was created in the source cluster.
     */
    val cacheNodeCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.cacheNodeCreateTime
    /**
     * The cache node identifier for the node in the source cluster.
     */
    val cacheNodeId: kotlin.String? = builder.cacheNodeId
    /**
     * The size of the cache on the source cache node.
     */
    val cacheSize: kotlin.String? = builder.cacheSize
    /**
     * The configuration for the source node group (shard).
     */
    val nodeGroupConfiguration: aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration? = builder.nodeGroupConfiguration
    /**
     * A unique identifier for the source node group (shard).
     */
    val nodeGroupId: kotlin.String? = builder.nodeGroupId
    /**
     * The date and time when the source node's metadata and cache data set was obtained for the snapshot.
     */
    val snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.snapshotCreateTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.NodeSnapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeSnapshot(")
        append("cacheClusterId=$cacheClusterId,")
        append("cacheNodeCreateTime=$cacheNodeCreateTime,")
        append("cacheNodeId=$cacheNodeId,")
        append("cacheSize=$cacheSize,")
        append("nodeGroupConfiguration=$nodeGroupConfiguration,")
        append("nodeGroupId=$nodeGroupId,")
        append("snapshotCreateTime=$snapshotCreateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheClusterId?.hashCode() ?: 0
        result = 31 * result + (cacheNodeCreateTime?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeId?.hashCode() ?: 0)
        result = 31 * result + (cacheSize?.hashCode() ?: 0)
        result = 31 * result + (nodeGroupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (nodeGroupId?.hashCode() ?: 0)
        result = 31 * result + (snapshotCreateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeSnapshot

        if (cacheClusterId != other.cacheClusterId) return false
        if (cacheNodeCreateTime != other.cacheNodeCreateTime) return false
        if (cacheNodeId != other.cacheNodeId) return false
        if (cacheSize != other.cacheSize) return false
        if (nodeGroupConfiguration != other.nodeGroupConfiguration) return false
        if (nodeGroupId != other.nodeGroupId) return false
        if (snapshotCreateTime != other.snapshotCreateTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.NodeSnapshot = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the source cluster.
         */
        var cacheClusterId: kotlin.String? = null
        /**
         * The date and time when the cache node was created in the source cluster.
         */
        var cacheNodeCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The cache node identifier for the node in the source cluster.
         */
        var cacheNodeId: kotlin.String? = null
        /**
         * The size of the cache on the source cache node.
         */
        var cacheSize: kotlin.String? = null
        /**
         * The configuration for the source node group (shard).
         */
        var nodeGroupConfiguration: aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration? = null
        /**
         * A unique identifier for the source node group (shard).
         */
        var nodeGroupId: kotlin.String? = null
        /**
         * The date and time when the source node's metadata and cache data set was obtained for the snapshot.
         */
        var snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.NodeSnapshot) : this() {
            this.cacheClusterId = x.cacheClusterId
            this.cacheNodeCreateTime = x.cacheNodeCreateTime
            this.cacheNodeId = x.cacheNodeId
            this.cacheSize = x.cacheSize
            this.nodeGroupConfiguration = x.nodeGroupConfiguration
            this.nodeGroupId = x.nodeGroupId
            this.snapshotCreateTime = x.snapshotCreateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.NodeSnapshot = NodeSnapshot(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration] inside the given [block]
         */
        fun nodeGroupConfiguration(block: aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration.Builder.() -> kotlin.Unit) {
            this.nodeGroupConfiguration = aws.sdk.kotlin.services.elasticache.model.NodeGroupConfiguration.invoke(block)
        }
    }
}
