// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a single occurrence of something interesting within the system. Some examples of events are creating a cluster, adding or removing a cache node, or rebooting a node.
 */
class Event private constructor(builder: Builder) {
    /**
     * The date and time when the event occurred.
     */
    val date: aws.smithy.kotlin.runtime.time.Instant? = builder.date
    /**
     * The text of the event.
     */
    val message: kotlin.String? = builder.message
    /**
     * The identifier for the source of the event. For example, if the event occurred at the cluster level, the identifier would be the name of the cluster.
     */
    val sourceIdentifier: kotlin.String? = builder.sourceIdentifier
    /**
     * Specifies the origin of this event - a cluster, a parameter group, a security group, etc.
     */
    val sourceType: aws.sdk.kotlin.services.elasticache.model.SourceType? = builder.sourceType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.Event = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Event(")
        append("date=$date,")
        append("message=$message,")
        append("sourceIdentifier=$sourceIdentifier,")
        append("sourceType=$sourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = date?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (sourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Event

        if (date != other.date) return false
        if (message != other.message) return false
        if (sourceIdentifier != other.sourceIdentifier) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.Event = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time when the event occurred.
         */
        var date: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The text of the event.
         */
        var message: kotlin.String? = null
        /**
         * The identifier for the source of the event. For example, if the event occurred at the cluster level, the identifier would be the name of the cluster.
         */
        var sourceIdentifier: kotlin.String? = null
        /**
         * Specifies the origin of this event - a cluster, a parameter group, a security group, etc.
         */
        var sourceType: aws.sdk.kotlin.services.elasticache.model.SourceType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.Event) : this() {
            this.date = x.date
            this.message = x.message
            this.sourceIdentifier = x.sourceIdentifier
            this.sourceType = x.sourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.Event = Event(this)
    }
}
