// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.elasticache.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.elasticache.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon ElastiCache
 * Amazon ElastiCache is a web service that makes it easier to set up, operate, and scale a distributed cache in the cloud.
 *
 * With ElastiCache, customers get all of the benefits of a high-performance, in-memory cache with less of the administrative burden involved in launching and managing a distributed cache. The service makes setup, scaling, and cluster failure handling much simpler than in a self-managed cache deployment.
 *
 * In addition, through integration with Amazon CloudWatch, customers get enhanced visibility into the key performance statistics associated with their cache and can receive alarms if a part of their cache runs hot.
 */
interface ElastiCacheClient : SdkClient {

    override val serviceName: String
        get() = "ElastiCache"
    /**
     * ElastiCacheClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ElastiCacheClient {
            val config = Config.Builder().apply(block).build()
            return DefaultElastiCacheClient(config)
        }

        operator fun invoke(config: Config): ElastiCacheClient = DefaultElastiCacheClient(config)

        /**
         * Construct a [ElastiCacheClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ElastiCacheClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultElastiCacheClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     *
     *  For example, you can use cost-allocation tags to your ElastiCache resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services.
     *
     * For more information, see [Using Cost Allocation Tags in Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html) in the *ElastiCache User Guide*.
     */
    suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     *
     *  For example, you can use cost-allocation tags to your ElastiCache resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services.
     *
     * For more information, see [Using Cost Allocation Tags in Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html) in the *ElastiCache User Guide*.
     */
    suspend fun addTagsToResource(block: AddTagsToResourceRequest.Builder.() -> Unit) = addTagsToResource(AddTagsToResourceRequest.Builder().apply(block).build())

    /**
     * Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2, and Amazon EC2 security groups are used as the authorization mechanism.
     *
     * You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another region.
     */
    suspend fun authorizeCacheSecurityGroupIngress(input: AuthorizeCacheSecurityGroupIngressRequest): AuthorizeCacheSecurityGroupIngressResponse

    /**
     * Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2, and Amazon EC2 security groups are used as the authorization mechanism.
     *
     * You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another region.
     */
    suspend fun authorizeCacheSecurityGroupIngress(block: AuthorizeCacheSecurityGroupIngressRequest.Builder.() -> Unit) = authorizeCacheSecurityGroupIngress(AuthorizeCacheSecurityGroupIngressRequest.Builder().apply(block).build())

    /**
     * Apply the service update. For more information on service updates and applying them, see [Applying Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html).
     */
    suspend fun batchApplyUpdateAction(input: BatchApplyUpdateActionRequest): BatchApplyUpdateActionResponse

    /**
     * Apply the service update. For more information on service updates and applying them, see [Applying Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html).
     */
    suspend fun batchApplyUpdateAction(block: BatchApplyUpdateActionRequest.Builder.() -> Unit) = batchApplyUpdateAction(BatchApplyUpdateActionRequest.Builder().apply(block).build())

    /**
     * Stop the service update. For more information on service updates and stopping them, see [Stopping Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html).
     */
    suspend fun batchStopUpdateAction(input: BatchStopUpdateActionRequest): BatchStopUpdateActionResponse

    /**
     * Stop the service update. For more information on service updates and stopping them, see [Stopping Service Updates](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html).
     */
    suspend fun batchStopUpdateAction(block: BatchStopUpdateActionRequest.Builder.() -> Unit) = batchStopUpdateAction(BatchStopUpdateActionRequest.Builder().apply(block).build())

    /**
     * Complete the migration of data.
     */
    suspend fun completeMigration(input: CompleteMigrationRequest): CompleteMigrationResponse

    /**
     * Complete the migration of data.
     */
    suspend fun completeMigration(block: CompleteMigrationRequest.Builder.() -> Unit) = completeMigration(CompleteMigrationRequest.Builder().apply(block).build())

    /**
     * Makes a copy of an existing snapshot.
     *
     * This operation is valid for Redis only.
     *
     * Users or groups that have permissions to use the `CopySnapshot` operation can create their own Amazon S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has the ability to use the `CopySnapshot` operation. For more information about using IAM to control the use of ElastiCache operations, see [Exporting Snapshots](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html) and [Authentication & Access Control](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html).
     *
     * You could receive the following error messages.
     *
     * **Error Messages**
     * + **Error Message:** The S3 bucket %s is outside of the region.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The S3 bucket %s does not exist.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The S3 bucket %s is not owned by the authenticated user.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The authenticated user does not have sufficient permissions to perform the desired activity.**Solution:** Contact your system administrator to get the needed permissions.
     * + **Error Message:** The S3 bucket %s already contains an object with key %s.**Solution:** Give the `TargetSnapshotName` a new and unique value. If exporting a snapshot, you could alternatively create a new Amazon S3 bucket and use this same value for `TargetSnapshotName`.
     * + **Error Message: ** ElastiCache has not been granted READ permissions %s on the S3 Bucket.**Solution:** Add List and Read permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     * + **Error Message: ** ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.**Solution:** Add Upload/Delete permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     * + **Error Message: ** ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.**Solution:** Add View Permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     */
    suspend fun copySnapshot(input: CopySnapshotRequest): CopySnapshotResponse

    /**
     * Makes a copy of an existing snapshot.
     *
     * This operation is valid for Redis only.
     *
     * Users or groups that have permissions to use the `CopySnapshot` operation can create their own Amazon S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has the ability to use the `CopySnapshot` operation. For more information about using IAM to control the use of ElastiCache operations, see [Exporting Snapshots](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html) and [Authentication & Access Control](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html).
     *
     * You could receive the following error messages.
     *
     * **Error Messages**
     * + **Error Message:** The S3 bucket %s is outside of the region.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The S3 bucket %s does not exist.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The S3 bucket %s is not owned by the authenticated user.**Solution:** Create an Amazon S3 bucket in the same region as your snapshot. For more information, see [Step 1: Create an Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket) in the ElastiCache User Guide.
     * + **Error Message:** The authenticated user does not have sufficient permissions to perform the desired activity.**Solution:** Contact your system administrator to get the needed permissions.
     * + **Error Message:** The S3 bucket %s already contains an object with key %s.**Solution:** Give the `TargetSnapshotName` a new and unique value. If exporting a snapshot, you could alternatively create a new Amazon S3 bucket and use this same value for `TargetSnapshotName`.
     * + **Error Message: ** ElastiCache has not been granted READ permissions %s on the S3 Bucket.**Solution:** Add List and Read permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     * + **Error Message: ** ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.**Solution:** Add Upload/Delete permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     * + **Error Message: ** ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.**Solution:** Add View Permissions on the bucket. For more information, see [Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access) in the ElastiCache User Guide.
     */
    suspend fun copySnapshot(block: CopySnapshotRequest.Builder.() -> Unit) = copySnapshot(CopySnapshotRequest.Builder().apply(block).build())

    /**
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either Memcached or Redis.
     *
     * This operation is not supported for Redis (cluster mode enabled) clusters.
     */
    suspend fun createCacheCluster(input: CreateCacheClusterRequest): CreateCacheClusterResponse

    /**
     * Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either Memcached or Redis.
     *
     * This operation is not supported for Redis (cluster mode enabled) clusters.
     */
    suspend fun createCacheCluster(block: CreateCacheClusterRequest.Builder.() -> Unit) = createCacheCluster(CreateCacheClusterRequest.Builder().apply(block).build())

    /**
     * Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster or replication group using the CacheParameterGroup.
     *
     * A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of specific parameters. For more information, see:
     * + [ModifyCacheParameterGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html) in the ElastiCache API Reference.
     * + [Parameters and Parameter Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html) in the ElastiCache User Guide.
     */
    suspend fun createCacheParameterGroup(input: CreateCacheParameterGroupRequest): CreateCacheParameterGroupResponse

    /**
     * Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster or replication group using the CacheParameterGroup.
     *
     * A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of specific parameters. For more information, see:
     * + [ModifyCacheParameterGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html) in the ElastiCache API Reference.
     * + [Parameters and Parameter Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html) in the ElastiCache User Guide.
     */
    suspend fun createCacheParameterGroup(block: CreateCacheParameterGroupRequest.Builder.() -> Unit) = createCacheParameterGroup(CreateCacheParameterGroupRequest.Builder().apply(block).build())

    /**
     * Creates a new cache security group. Use a cache security group to control access to one or more clusters.
     *
     * Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more information, see [CreateCacheSubnetGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html).
     */
    suspend fun createCacheSecurityGroup(input: CreateCacheSecurityGroupRequest): CreateCacheSecurityGroupResponse

    /**
     * Creates a new cache security group. Use a cache security group to control access to one or more clusters.
     *
     * Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more information, see [CreateCacheSubnetGroup](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html).
     */
    suspend fun createCacheSecurityGroup(block: CreateCacheSecurityGroupRequest.Builder.() -> Unit) = createCacheSecurityGroup(CreateCacheSecurityGroupRequest.Builder().apply(block).build())

    /**
     * Creates a new cache subnet group.
     *
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    suspend fun createCacheSubnetGroup(input: CreateCacheSubnetGroupRequest): CreateCacheSubnetGroupResponse

    /**
     * Creates a new cache subnet group.
     *
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    suspend fun createCacheSubnetGroup(block: CreateCacheSubnetGroupRequest.Builder.() -> Unit) = createCacheSubnetGroup(CreateCacheSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable low-latency reads and disaster recovery across regions. For more information, see [Replication Across Regions Using Global Datastore](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html).
     * + The **GlobalReplicationGroupIdSuffix** is the name of the Global datastore.
     * + The **PrimaryReplicationGroupId** represents the name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.
     */
    suspend fun createGlobalReplicationGroup(input: CreateGlobalReplicationGroupRequest): CreateGlobalReplicationGroupResponse

    /**
     * Global Datastore for Redis offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore for Redis, you can create cross-region read replica clusters for ElastiCache for Redis to enable low-latency reads and disaster recovery across regions. For more information, see [Replication Across Regions Using Global Datastore](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html).
     * + The **GlobalReplicationGroupIdSuffix** is the name of the Global datastore.
     * + The **PrimaryReplicationGroupId** represents the name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.
     */
    suspend fun createGlobalReplicationGroup(block: CreateGlobalReplicationGroupRequest.Builder.() -> Unit) = createGlobalReplicationGroup(CreateGlobalReplicationGroupRequest.Builder().apply(block).build())

    /**
     * Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.
     *
     * This API can be used to create a standalone regional replication group or a secondary replication group associated with a Global datastore.
     *
     * A Redis (cluster mode disabled) replication group is a collection of clusters, where one of the clusters is a read/write primary and the others are read-only replicas. Writes to the primary are asynchronously propagated to the replicas.
     *
     * A Redis cluster-mode enabled cluster is comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas to 15 shards and 5 replicas, which is the maximum number or replicas allowed.
     *
     * The node or shard limit can be increased to a maximum of 500 per cluster if the Redis engine version is 5.0.6 or higher. For example, you can choose to configure a 500 node cluster that ranges between 83 shards (one primary and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there are enough available IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet group have too small a CIDR range or the subnets are shared and heavily used by other clusters. For more information, see [Creating a Subnet Group](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html). For versions below 5.0.6, the limit is 250 per cluster.
     *
     * To request a limit increase, see [Amazon Service Limits](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) and choose the limit type **Nodes per cluster per instance type**.
     *
     * When a Redis (cluster mode disabled) replication group has been successfully created, you can add one or more read replicas to it, up to a total of 5 read replicas. If you need to increase or decrease the number of node groups (console: shards), you can avail yourself of ElastiCache for Redis' scaling. For more information, see [Scaling ElastiCache for Redis Clusters](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html) in the *ElastiCache User Guide*.
     *
     * This operation is valid for Redis only.
     */
    suspend fun createReplicationGroup(input: CreateReplicationGroupRequest): CreateReplicationGroupResponse

    /**
     * Creates a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group.
     *
     * This API can be used to create a standalone regional replication group or a secondary replication group associated with a Global datastore.
     *
     * A Redis (cluster mode disabled) replication group is a collection of clusters, where one of the clusters is a read/write primary and the others are read-only replicas. Writes to the primary are asynchronously propagated to the replicas.
     *
     * A Redis cluster-mode enabled cluster is comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas to 15 shards and 5 replicas, which is the maximum number or replicas allowed.
     *
     * The node or shard limit can be increased to a maximum of 500 per cluster if the Redis engine version is 5.0.6 or higher. For example, you can choose to configure a 500 node cluster that ranges between 83 shards (one primary and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there are enough available IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet group have too small a CIDR range or the subnets are shared and heavily used by other clusters. For more information, see [Creating a Subnet Group](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html). For versions below 5.0.6, the limit is 250 per cluster.
     *
     * To request a limit increase, see [Amazon Service Limits](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) and choose the limit type **Nodes per cluster per instance type**.
     *
     * When a Redis (cluster mode disabled) replication group has been successfully created, you can add one or more read replicas to it, up to a total of 5 read replicas. If you need to increase or decrease the number of node groups (console: shards), you can avail yourself of ElastiCache for Redis' scaling. For more information, see [Scaling ElastiCache for Redis Clusters](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html) in the *ElastiCache User Guide*.
     *
     * This operation is valid for Redis only.
     */
    suspend fun createReplicationGroup(block: CreateReplicationGroupRequest.Builder.() -> Unit) = createReplicationGroup(CreateReplicationGroupRequest.Builder().apply(block).build())

    /**
     * Creates a copy of an entire cluster or replication group at a specific moment in time.
     *
     * This operation is valid for Redis only.
     */
    suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Creates a copy of an entire cluster or replication group at a specific moment in time.
     *
     * This operation is valid for Redis only.
     */
    suspend fun createSnapshot(block: CreateSnapshotRequest.Builder.() -> Unit) = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

    /**
     * For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * For Redis engine version 6.0 onwards: Creates a Redis user. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    suspend fun createUser(block: CreateUserRequest.Builder.() -> Unit) = createUser(CreateUserRequest.Builder().apply(block).build())

    /**
     * For Redis engine version 6.0 onwards: Creates a Redis user group. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html)
     */
    suspend fun createUserGroup(input: CreateUserGroupRequest): CreateUserGroupResponse

    /**
     * For Redis engine version 6.0 onwards: Creates a Redis user group. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html)
     */
    suspend fun createUserGroup(block: CreateUserGroupRequest.Builder.() -> Unit) = createUserGroup(CreateUserGroupRequest.Builder().apply(block).build())

    /**
     * Decreases the number of node groups in a Global datastore
     */
    suspend fun decreaseNodeGroupsInGlobalReplicationGroup(input: DecreaseNodeGroupsInGlobalReplicationGroupRequest): DecreaseNodeGroupsInGlobalReplicationGroupResponse

    /**
     * Decreases the number of node groups in a Global datastore
     */
    suspend fun decreaseNodeGroupsInGlobalReplicationGroup(block: DecreaseNodeGroupsInGlobalReplicationGroupRequest.Builder.() -> Unit) = decreaseNodeGroupsInGlobalReplicationGroup(DecreaseNodeGroupsInGlobalReplicationGroupRequest.Builder().apply(block).build())

    /**
     * Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
     */
    suspend fun decreaseReplicaCount(input: DecreaseReplicaCountRequest): DecreaseReplicaCountResponse

    /**
     * Dynamically decreases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
     */
    suspend fun decreaseReplicaCount(block: DecreaseReplicaCountRequest.Builder.() -> Unit) = decreaseReplicaCount(DecreaseReplicaCountRequest.Builder().apply(block).build())

    /**
     * Deletes a previously provisioned cluster. `DeleteCacheCluster` deletes all associated cache nodes, node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.
     *
     * This operation is not valid for:
     * + Redis (cluster mode enabled) clusters
     * + Redis (cluster mode disabled) clusters
     * + A cluster that is the last read replica of a replication group
     * + A cluster that is the primary node of a replication group
     * + A node group (shard) that has Multi-AZ mode enabled
     * + A cluster from a Redis (cluster mode enabled) replication group
     * + A cluster that is not in the `available` state
     */
    suspend fun deleteCacheCluster(input: DeleteCacheClusterRequest): DeleteCacheClusterResponse

    /**
     * Deletes a previously provisioned cluster. `DeleteCacheCluster` deletes all associated cache nodes, node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.
     *
     * This operation is not valid for:
     * + Redis (cluster mode enabled) clusters
     * + Redis (cluster mode disabled) clusters
     * + A cluster that is the last read replica of a replication group
     * + A cluster that is the primary node of a replication group
     * + A node group (shard) that has Multi-AZ mode enabled
     * + A cluster from a Redis (cluster mode enabled) replication group
     * + A cluster that is not in the `available` state
     */
    suspend fun deleteCacheCluster(block: DeleteCacheClusterRequest.Builder.() -> Unit) = deleteCacheCluster(DeleteCacheClusterRequest.Builder().apply(block).build())

    /**
     * Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with any cache clusters. You cannot delete the default cache parameter groups in your account.
     */
    suspend fun deleteCacheParameterGroup(input: DeleteCacheParameterGroupRequest): DeleteCacheParameterGroupResponse

    /**
     * Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with any cache clusters. You cannot delete the default cache parameter groups in your account.
     */
    suspend fun deleteCacheParameterGroup(block: DeleteCacheParameterGroupRequest.Builder.() -> Unit) = deleteCacheParameterGroup(DeleteCacheParameterGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a cache security group.
     *
     * You cannot delete a cache security group if it is associated with any clusters.
     */
    suspend fun deleteCacheSecurityGroup(input: DeleteCacheSecurityGroupRequest): DeleteCacheSecurityGroupResponse

    /**
     * Deletes a cache security group.
     *
     * You cannot delete a cache security group if it is associated with any clusters.
     */
    suspend fun deleteCacheSecurityGroup(block: DeleteCacheSecurityGroupRequest.Builder.() -> Unit) = deleteCacheSecurityGroup(DeleteCacheSecurityGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a cache subnet group.
     *
     * You cannot delete a default cache subnet group or one that is associated with any clusters.
     */
    suspend fun deleteCacheSubnetGroup(input: DeleteCacheSubnetGroupRequest): DeleteCacheSubnetGroupResponse

    /**
     * Deletes a cache subnet group.
     *
     * You cannot delete a default cache subnet group or one that is associated with any clusters.
     */
    suspend fun deleteCacheSubnetGroup(block: DeleteCacheSubnetGroupRequest.Builder.() -> Unit) = deleteCacheSubnetGroup(DeleteCacheSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Deleting a Global datastore is a two-step process:
     * + First, you must DisassociateGlobalReplicationGroup to remove the secondary clusters in the Global datastore.
     * + Once the Global datastore contains only the primary cluster, you can use the `DeleteGlobalReplicationGroup` API to delete the Global datastore while retainining the primary cluster using `RetainPrimaryReplicationGroup=true`.
     *
     * Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the primary by setting `RetainPrimaryReplicationGroup=true`. The primary cluster is never deleted when deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore.
     *
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.
     */
    suspend fun deleteGlobalReplicationGroup(input: DeleteGlobalReplicationGroupRequest): DeleteGlobalReplicationGroupResponse

    /**
     * Deleting a Global datastore is a two-step process:
     * + First, you must DisassociateGlobalReplicationGroup to remove the secondary clusters in the Global datastore.
     * + Once the Global datastore contains only the primary cluster, you can use the `DeleteGlobalReplicationGroup` API to delete the Global datastore while retainining the primary cluster using `RetainPrimaryReplicationGroup=true`.
     *
     * Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the primary by setting `RetainPrimaryReplicationGroup=true`. The primary cluster is never deleted when deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore.
     *
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.
     */
    suspend fun deleteGlobalReplicationGroup(block: DeleteGlobalReplicationGroupRequest.Builder.() -> Unit) = deleteGlobalReplicationGroup(DeleteGlobalReplicationGroupRequest.Builder().apply(block).build())

    /**
     * Deletes an existing replication group. By default, this operation deletes the entire replication group, including the primary/primaries and all of the read replicas. If the replication group has only one primary, you can optionally delete only the read replicas, while retaining the primary by setting `RetainPrimaryCluster=true`.
     *
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.
     *
     * This operation is valid for Redis only.
     */
    suspend fun deleteReplicationGroup(input: DeleteReplicationGroupRequest): DeleteReplicationGroupResponse

    /**
     * Deletes an existing replication group. By default, this operation deletes the entire replication group, including the primary/primaries and all of the read replicas. If the replication group has only one primary, you can optionally delete only the read replicas, while retaining the primary by setting `RetainPrimaryCluster=true`.
     *
     * When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.
     *
     * This operation is valid for Redis only.
     */
    suspend fun deleteReplicationGroup(block: DeleteReplicationGroupRequest.Builder.() -> Unit) = deleteReplicationGroup(DeleteReplicationGroupRequest.Builder().apply(block).build())

    /**
     * Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately begins deleting the snapshot; you cannot cancel or revert this operation.
     *
     * This operation is valid for Redis only.
     */
    suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse

    /**
     * Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately begins deleting the snapshot; you cannot cancel or revert this operation.
     *
     * This operation is valid for Redis only.
     */
    suspend fun deleteSnapshot(block: DeleteSnapshotRequest.Builder.() -> Unit) = deleteSnapshot(DeleteSnapshotRequest.Builder().apply(block).build())

    /**
     * For Redis engine version 6.0 onwards: Deletes a user. The user will be removed from all user groups and in turn removed from all replication groups. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * For Redis engine version 6.0 onwards: Deletes a user. The user will be removed from all user groups and in turn removed from all replication groups. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    suspend fun deleteUser(block: DeleteUserRequest.Builder.() -> Unit) = deleteUser(DeleteUserRequest.Builder().apply(block).build())

    /**
     * For Redis engine version 6.0 onwards: Deletes a user group. The user group must first be disassociated from the replication group before it can be deleted. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    suspend fun deleteUserGroup(input: DeleteUserGroupRequest): DeleteUserGroupResponse

    /**
     * For Redis engine version 6.0 onwards: Deletes a user group. The user group must first be disassociated from the replication group before it can be deleted. For more information, see [Using Role Based Access Control (RBAC)](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html).
     */
    suspend fun deleteUserGroup(block: DeleteUserGroupRequest.Builder.() -> Unit) = deleteUserGroup(DeleteUserGroupRequest.Builder().apply(block).build())

    /**
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cache cluster if a cluster identifier is supplied.
     *
     * By default, abbreviated information about the clusters is returned. You can use the optional *ShowCacheNodeInfo* flag to retrieve detailed information about the cache nodes associated with the clusters. These details include the DNS address and port for the cache node endpoint.
     *
     * If the cluster is in the *creating* state, only cluster-level information is displayed until all of the nodes are successfully provisioned.
     *
     * If the cluster is in the *deleting* state, only cluster-level information is displayed.
     *
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the additional nodes are not displayed until they are completely provisioned. When the cluster state is *available*, the cluster is ready for use.
     *
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is displayed.
     */
    suspend fun describeCacheClusters(input: DescribeCacheClustersRequest = DescribeCacheClustersRequest {}): DescribeCacheClustersResponse

    /**
     * Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cache cluster if a cluster identifier is supplied.
     *
     * By default, abbreviated information about the clusters is returned. You can use the optional *ShowCacheNodeInfo* flag to retrieve detailed information about the cache nodes associated with the clusters. These details include the DNS address and port for the cache node endpoint.
     *
     * If the cluster is in the *creating* state, only cluster-level information is displayed until all of the nodes are successfully provisioned.
     *
     * If the cluster is in the *deleting* state, only cluster-level information is displayed.
     *
     * If cache nodes are currently being added to the cluster, node endpoint information and creation time for the additional nodes are not displayed until they are completely provisioned. When the cluster state is *available*, the cluster is ready for use.
     *
     * If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is displayed.
     */
    suspend fun describeCacheClusters(block: DescribeCacheClustersRequest.Builder.() -> Unit) = describeCacheClusters(DescribeCacheClustersRequest.Builder().apply(block).build())

    /**
     * Returns a list of the available cache engines and their versions.
     */
    suspend fun describeCacheEngineVersions(input: DescribeCacheEngineVersionsRequest = DescribeCacheEngineVersionsRequest {}): DescribeCacheEngineVersionsResponse

    /**
     * Returns a list of the available cache engines and their versions.
     */
    suspend fun describeCacheEngineVersions(block: DescribeCacheEngineVersionsRequest.Builder.() -> Unit) = describeCacheEngineVersions(DescribeCacheEngineVersionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list contains only the descriptions for that group.
     */
    suspend fun describeCacheParameterGroups(input: DescribeCacheParameterGroupsRequest = DescribeCacheParameterGroupsRequest {}): DescribeCacheParameterGroupsResponse

    /**
     * Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list contains only the descriptions for that group.
     */
    suspend fun describeCacheParameterGroups(block: DescribeCacheParameterGroupsRequest.Builder.() -> Unit) = describeCacheParameterGroups(DescribeCacheParameterGroupsRequest.Builder().apply(block).build())

    /**
     * Returns the detailed parameter list for a particular cache parameter group.
     */
    suspend fun describeCacheParameters(input: DescribeCacheParametersRequest): DescribeCacheParametersResponse

    /**
     * Returns the detailed parameter list for a particular cache parameter group.
     */
    suspend fun describeCacheParameters(block: DescribeCacheParametersRequest.Builder.() -> Unit) = describeCacheParameters(DescribeCacheParametersRequest.Builder().apply(block).build())

    /**
     * Returns a list of cache security group descriptions. If a cache security group name is specified, the list contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
     */
    suspend fun describeCacheSecurityGroups(input: DescribeCacheSecurityGroupsRequest = DescribeCacheSecurityGroupsRequest {}): DescribeCacheSecurityGroupsResponse

    /**
     * Returns a list of cache security group descriptions. If a cache security group name is specified, the list contains only the description of that group. This applicable only when you have ElastiCache in Classic setup
     */
    suspend fun describeCacheSecurityGroups(block: DescribeCacheSecurityGroupsRequest.Builder.() -> Unit) = describeCacheSecurityGroups(DescribeCacheSecurityGroupsRequest.Builder().apply(block).build())

    /**
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache clusters now launch in VPC by default.
     */
    suspend fun describeCacheSubnetGroups(input: DescribeCacheSubnetGroupsRequest = DescribeCacheSubnetGroupsRequest {}): DescribeCacheSubnetGroupsResponse

    /**
     * Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache clusters now launch in VPC by default.
     */
    suspend fun describeCacheSubnetGroups(block: DescribeCacheSubnetGroupsRequest.Builder.() -> Unit) = describeCacheSubnetGroups(DescribeCacheSubnetGroupsRequest.Builder().apply(block).build())

    /**
     * Returns the default engine and system parameter information for the specified cache engine.
     */
    suspend fun describeEngineDefaultParameters(input: DescribeEngineDefaultParametersRequest): DescribeEngineDefaultParametersResponse

    /**
     * Returns the default engine and system parameter information for the specified cache engine.
     */
    suspend fun describeEngineDefaultParameters(block: DescribeEngineDefaultParametersRequest.Builder.() -> Unit) = describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest.Builder().apply(block).build())

    /**
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events specific to a particular cluster, cache security group, or cache parameter group by providing the name as a parameter.
     *
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.
     */
    suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest {}): DescribeEventsResponse

    /**
     * Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events specific to a particular cluster, cache security group, or cache parameter group by providing the name as a parameter.
     *
     * By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days' worth of events if necessary.
     */
    suspend fun describeEvents(block: DescribeEventsRequest.Builder.() -> Unit) = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

    /**
     * Returns information about a particular global replication group. If no identifier is specified, returns information about all Global datastores.
     */
    suspend fun describeGlobalReplicationGroups(input: DescribeGlobalReplicationGroupsRequest = DescribeGlobalReplicationGroupsRequest {}): DescribeGlobalReplicationGroupsResponse

    /**
     * Returns information about a particular global replication group. If no identifier is specified, returns information about all Global datastores.
     */
    suspend fun describeGlobalReplicationGroups(block: DescribeGlobalReplicationGroupsRequest.Builder.() -> Unit) = describeGlobalReplicationGroups(DescribeGlobalReplicationGroupsRequest.Builder().apply(block).build())

    /**
     * Returns information about a particular replication group. If no identifier is specified, `DescribeReplicationGroups` returns information about all replication groups.
     *
     * This operation is valid for Redis only.
     */
    suspend fun describeReplicationGroups(input: DescribeReplicationGroupsRequest = DescribeReplicationGroupsRequest {}): DescribeReplicationGroupsResponse

    /**
     * Returns information about a particular replication group. If no identifier is specified, `DescribeReplicationGroups` returns information about all replication groups.
     *
     * This operation is valid for Redis only.
     */
    suspend fun describeReplicationGroups(block: DescribeReplicationGroupsRequest.Builder.() -> Unit) = describeReplicationGroups(DescribeReplicationGroupsRequest.Builder().apply(block).build())

    /**
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     */
    suspend fun describeReservedCacheNodes(input: DescribeReservedCacheNodesRequest = DescribeReservedCacheNodesRequest {}): DescribeReservedCacheNodesResponse

    /**
     * Returns information about reserved cache nodes for this account, or about a specified reserved cache node.
     */
    suspend fun describeReservedCacheNodes(block: DescribeReservedCacheNodesRequest.Builder.() -> Unit) = describeReservedCacheNodes(DescribeReservedCacheNodesRequest.Builder().apply(block).build())

    /**
     * Lists available reserved cache node offerings.
     */
    suspend fun describeReservedCacheNodesOfferings(input: DescribeReservedCacheNodesOfferingsRequest = DescribeReservedCacheNodesOfferingsRequest {}): DescribeReservedCacheNodesOfferingsResponse

    /**
     * Lists available reserved cache node offerings.
     */
    suspend fun describeReservedCacheNodesOfferings(block: DescribeReservedCacheNodesOfferingsRequest.Builder.() -> Unit) = describeReservedCacheNodesOfferings(DescribeReservedCacheNodesOfferingsRequest.Builder().apply(block).build())

    /**
     * Returns details of the service updates
     */
    suspend fun describeServiceUpdates(input: DescribeServiceUpdatesRequest = DescribeServiceUpdatesRequest {}): DescribeServiceUpdatesResponse

    /**
     * Returns details of the service updates
     */
    suspend fun describeServiceUpdates(block: DescribeServiceUpdatesRequest.Builder.() -> Unit) = describeServiceUpdates(DescribeServiceUpdatesRequest.Builder().apply(block).build())

    /**
     * Returns information about cluster or replication group snapshots. By default, `DescribeSnapshots` lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cache cluster.
     *
     * This operation is valid for Redis only.
     */
    suspend fun describeSnapshots(input: DescribeSnapshotsRequest = DescribeSnapshotsRequest {}): DescribeSnapshotsResponse

    /**
     * Returns information about cluster or replication group snapshots. By default, `DescribeSnapshots` lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cache cluster.
     *
     * This operation is valid for Redis only.
     */
    suspend fun describeSnapshots(block: DescribeSnapshotsRequest.Builder.() -> Unit) = describeSnapshots(DescribeSnapshotsRequest.Builder().apply(block).build())

    /**
     * Returns details of the update actions
     */
    suspend fun describeUpdateActions(input: DescribeUpdateActionsRequest = DescribeUpdateActionsRequest {}): DescribeUpdateActionsResponse

    /**
     * Returns details of the update actions
     */
    suspend fun describeUpdateActions(block: DescribeUpdateActionsRequest.Builder.() -> Unit) = describeUpdateActions(DescribeUpdateActionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of user groups.
     */
    suspend fun describeUserGroups(input: DescribeUserGroupsRequest = DescribeUserGroupsRequest {}): DescribeUserGroupsResponse

    /**
     * Returns a list of user groups.
     */
    suspend fun describeUserGroups(block: DescribeUserGroupsRequest.Builder.() -> Unit) = describeUserGroups(DescribeUserGroupsRequest.Builder().apply(block).build())

    /**
     * Returns a list of users.
     */
    suspend fun describeUsers(input: DescribeUsersRequest = DescribeUsersRequest {}): DescribeUsersResponse

    /**
     * Returns a list of users.
     */
    suspend fun describeUsers(block: DescribeUsersRequest.Builder.() -> Unit) = describeUsers(DescribeUsersRequest.Builder().apply(block).build())

    /**
     * Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon region.
     */
    suspend fun disassociateGlobalReplicationGroup(input: DisassociateGlobalReplicationGroupRequest): DisassociateGlobalReplicationGroupResponse

    /**
     * Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon region.
     */
    suspend fun disassociateGlobalReplicationGroup(block: DisassociateGlobalReplicationGroupRequest.Builder.() -> Unit) = disassociateGlobalReplicationGroup(DisassociateGlobalReplicationGroupRequest.Builder().apply(block).build())

    /**
     * Used to failover the primary region to a selected secondary region. The selected secondary region will become primary, and all other clusters will become secondary.
     */
    suspend fun failoverGlobalReplicationGroup(input: FailoverGlobalReplicationGroupRequest): FailoverGlobalReplicationGroupResponse

    /**
     * Used to failover the primary region to a selected secondary region. The selected secondary region will become primary, and all other clusters will become secondary.
     */
    suspend fun failoverGlobalReplicationGroup(block: FailoverGlobalReplicationGroupRequest.Builder.() -> Unit) = failoverGlobalReplicationGroup(FailoverGlobalReplicationGroupRequest.Builder().apply(block).build())

    /**
     * Increase the number of node groups in the Global datastore
     */
    suspend fun increaseNodeGroupsInGlobalReplicationGroup(input: IncreaseNodeGroupsInGlobalReplicationGroupRequest): IncreaseNodeGroupsInGlobalReplicationGroupResponse

    /**
     * Increase the number of node groups in the Global datastore
     */
    suspend fun increaseNodeGroupsInGlobalReplicationGroup(block: IncreaseNodeGroupsInGlobalReplicationGroupRequest.Builder.() -> Unit) = increaseNodeGroupsInGlobalReplicationGroup(IncreaseNodeGroupsInGlobalReplicationGroupRequest.Builder().apply(block).build())

    /**
     * Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
     */
    suspend fun increaseReplicaCount(input: IncreaseReplicaCountRequest): IncreaseReplicaCountResponse

    /**
     * Dynamically increases the number of replicas in a Redis (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis (cluster mode enabled) replication group. This operation is performed with no cluster down time.
     */
    suspend fun increaseReplicaCount(block: IncreaseReplicaCountRequest.Builder.() -> Unit) = increaseReplicaCount(IncreaseReplicaCountRequest.Builder().apply(block).build())

    /**
     * Lists all available node types that you can scale your Redis cluster's or replication group's current node type.
     *
     * When you use the `ModifyCacheCluster` or `ModifyReplicationGroup` operations to scale your cluster or replication group, the value of the `CacheNodeType` parameter must be one of the node types returned by this operation.
     */
    suspend fun listAllowedNodeTypeModifications(input: ListAllowedNodeTypeModificationsRequest = ListAllowedNodeTypeModificationsRequest {}): ListAllowedNodeTypeModificationsResponse

    /**
     * Lists all available node types that you can scale your Redis cluster's or replication group's current node type.
     *
     * When you use the `ModifyCacheCluster` or `ModifyReplicationGroup` operations to scale your cluster or replication group, the value of the `CacheNodeType` parameter must be one of the node types returned by this operation.
     */
    suspend fun listAllowedNodeTypeModifications(block: ListAllowedNodeTypeModificationsRequest.Builder.() -> Unit) = listAllowedNodeTypeModifications(ListAllowedNodeTypeModificationsRequest.Builder().apply(block).build())

    /**
     * Lists all tags currently on a named resource.
     *
     *  A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     *
     * If the cluster is not in the *available* state, `ListTagsForResource` returns an error.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all tags currently on a named resource.
     *
     *  A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     *
     * If the cluster is not in the *available* state, `ListTagsForResource` returns an error.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration parameters by specifying the parameters and the new values.
     */
    suspend fun modifyCacheCluster(input: ModifyCacheClusterRequest): ModifyCacheClusterResponse

    /**
     * Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration parameters by specifying the parameters and the new values.
     */
    suspend fun modifyCacheCluster(block: ModifyCacheClusterRequest.Builder.() -> Unit) = modifyCacheCluster(ModifyCacheClusterRequest.Builder().apply(block).build())

    /**
     * Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
     */
    suspend fun modifyCacheParameterGroup(input: ModifyCacheParameterGroupRequest): ModifyCacheParameterGroupResponse

    /**
     * Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.
     */
    suspend fun modifyCacheParameterGroup(block: ModifyCacheParameterGroupRequest.Builder.() -> Unit) = modifyCacheParameterGroup(ModifyCacheParameterGroupRequest.Builder().apply(block).build())

    /**
     * Modifies an existing cache subnet group.
     */
    suspend fun modifyCacheSubnetGroup(input: ModifyCacheSubnetGroupRequest): ModifyCacheSubnetGroupResponse

    /**
     * Modifies an existing cache subnet group.
     */
    suspend fun modifyCacheSubnetGroup(block: ModifyCacheSubnetGroupRequest.Builder.() -> Unit) = modifyCacheSubnetGroup(ModifyCacheSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Modifies the settings for a Global datastore.
     */
    suspend fun modifyGlobalReplicationGroup(input: ModifyGlobalReplicationGroupRequest): ModifyGlobalReplicationGroupResponse

    /**
     * Modifies the settings for a Global datastore.
     */
    suspend fun modifyGlobalReplicationGroup(block: ModifyGlobalReplicationGroupRequest.Builder.() -> Unit) = modifyGlobalReplicationGroup(ModifyGlobalReplicationGroupRequest.Builder().apply(block).build())

    /**
     * Modifies the settings for a replication group.
     * + [Scaling for Amazon ElastiCache for Redis (cluster mode enabled)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html) in the ElastiCache User Guide
     * + [ModifyReplicationGroupShardConfiguration](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html) in the ElastiCache API Reference
     *
     * This operation is valid for Redis only.
     */
    suspend fun modifyReplicationGroup(input: ModifyReplicationGroupRequest): ModifyReplicationGroupResponse

    /**
     * Modifies the settings for a replication group.
     * + [Scaling for Amazon ElastiCache for Redis (cluster mode enabled)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html) in the ElastiCache User Guide
     * + [ModifyReplicationGroupShardConfiguration](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html) in the ElastiCache API Reference
     *
     * This operation is valid for Redis only.
     */
    suspend fun modifyReplicationGroup(block: ModifyReplicationGroupRequest.Builder.() -> Unit) = modifyReplicationGroup(ModifyReplicationGroupRequest.Builder().apply(block).build())

    /**
     * Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance the keyspaces among existing shards.
     */
    suspend fun modifyReplicationGroupShardConfiguration(input: ModifyReplicationGroupShardConfigurationRequest): ModifyReplicationGroupShardConfigurationResponse

    /**
     * Modifies a replication group's shards (node groups) by allowing you to add shards, remove shards, or rebalance the keyspaces among existing shards.
     */
    suspend fun modifyReplicationGroupShardConfiguration(block: ModifyReplicationGroupShardConfigurationRequest.Builder.() -> Unit) = modifyReplicationGroupShardConfiguration(ModifyReplicationGroupShardConfigurationRequest.Builder().apply(block).build())

    /**
     * Changes user password(s) and/or access string.
     */
    suspend fun modifyUser(input: ModifyUserRequest): ModifyUserResponse

    /**
     * Changes user password(s) and/or access string.
     */
    suspend fun modifyUser(block: ModifyUserRequest.Builder.() -> Unit) = modifyUser(ModifyUserRequest.Builder().apply(block).build())

    /**
     * Changes the list of users that belong to the user group.
     */
    suspend fun modifyUserGroup(input: ModifyUserGroupRequest): ModifyUserGroupResponse

    /**
     * Changes the list of users that belong to the user group.
     */
    suspend fun modifyUserGroup(block: ModifyUserGroupRequest.Builder.() -> Unit) = modifyUserGroup(ModifyUserGroupRequest.Builder().apply(block).build())

    /**
     * Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are non-refundable. For more information, see [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/reserved-nodes.html) for Redis or [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/reserved-nodes.html) for Memcached.
     */
    suspend fun purchaseReservedCacheNodesOffering(input: PurchaseReservedCacheNodesOfferingRequest): PurchaseReservedCacheNodesOfferingResponse

    /**
     * Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are non-refundable. For more information, see [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/reserved-nodes.html) for Redis or [Managing Costs with Reserved Nodes](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/reserved-nodes.html) for Memcached.
     */
    suspend fun purchaseReservedCacheNodesOffering(block: PurchaseReservedCacheNodesOfferingRequest.Builder.() -> Unit) = purchaseReservedCacheNodesOffering(PurchaseReservedCacheNodesOfferingRequest.Builder().apply(block).build())

    /**
     * Redistribute slots to ensure uniform distribution across existing shards in the cluster.
     */
    suspend fun rebalanceSlotsInGlobalReplicationGroup(input: RebalanceSlotsInGlobalReplicationGroupRequest): RebalanceSlotsInGlobalReplicationGroupResponse

    /**
     * Redistribute slots to ensure uniform distribution across existing shards in the cluster.
     */
    suspend fun rebalanceSlotsInGlobalReplicationGroup(block: RebalanceSlotsInGlobalReplicationGroupRequest.Builder.() -> Unit) = rebalanceSlotsInGlobalReplicationGroup(RebalanceSlotsInGlobalReplicationGroupRequest.Builder().apply(block).build())

    /**
     * Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
     *
     * The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.
     *
     * When the reboot is complete, a cluster event is created.
     *
     * Rebooting a cluster is currently supported on Memcached and Redis (cluster mode disabled) clusters. Rebooting is not supported on Redis (cluster mode enabled) clusters.
     *
     * If you make changes to parameters that require a Redis (cluster mode enabled) cluster reboot for the changes to be applied, see [Rebooting a Cluster](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes.rebooting.html) for an alternate process.
     */
    suspend fun rebootCacheCluster(input: RebootCacheClusterRequest): RebootCacheClusterResponse

    /**
     * Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary outage to the cluster. During the reboot, the cluster status is set to REBOOTING.
     *
     * The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.
     *
     * When the reboot is complete, a cluster event is created.
     *
     * Rebooting a cluster is currently supported on Memcached and Redis (cluster mode disabled) clusters. Rebooting is not supported on Redis (cluster mode enabled) clusters.
     *
     * If you make changes to parameters that require a Redis (cluster mode enabled) cluster reboot for the changes to be applied, see [Rebooting a Cluster](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes.rebooting.html) for an alternate process.
     */
    suspend fun rebootCacheCluster(block: RebootCacheClusterRequest.Builder.() -> Unit) = rebootCacheCluster(RebootCacheClusterRequest.Builder().apply(block).build())

    /**
     * Removes the tags identified by the `TagKeys` list from the named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     */
    suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * Removes the tags identified by the `TagKeys` list from the named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see [Resource-level permissions](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html).
     */
    suspend fun removeTagsFromResource(block: RemoveTagsFromResourceRequest.Builder.() -> Unit) = removeTagsFromResource(RemoveTagsFromResourceRequest.Builder().apply(block).build())

    /**
     * Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the `ResetAllParameters` and `CacheParameterGroupName` parameters.
     */
    suspend fun resetCacheParameterGroup(input: ResetCacheParameterGroupRequest): ResetCacheParameterGroupResponse

    /**
     * Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the `ResetAllParameters` and `CacheParameterGroupName` parameters.
     */
    suspend fun resetCacheParameterGroup(block: ResetCacheParameterGroupRequest.Builder.() -> Unit) = resetCacheParameterGroup(ResetCacheParameterGroupRequest.Builder().apply(block).build())

    /**
     * Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security group that had been previously authorized.
     */
    suspend fun revokeCacheSecurityGroupIngress(input: RevokeCacheSecurityGroupIngressRequest): RevokeCacheSecurityGroupIngressResponse

    /**
     * Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security group that had been previously authorized.
     */
    suspend fun revokeCacheSecurityGroupIngress(block: RevokeCacheSecurityGroupIngressRequest.Builder.() -> Unit) = revokeCacheSecurityGroupIngress(RevokeCacheSecurityGroupIngressRequest.Builder().apply(block).build())

    /**
     * Start the migration of data.
     */
    suspend fun startMigration(input: StartMigrationRequest): StartMigrationResponse

    /**
     * Start the migration of data.
     */
    suspend fun startMigration(block: StartMigrationRequest.Builder.() -> Unit) = startMigration(StartMigrationRequest.Builder().apply(block).build())

    /**
     * Represents the input of a `TestFailover` operation which test automatic failover on a specified node group (called shard in the console) in a replication group (called cluster in the console).
     *
     * This API is designed for testing the behavior of your application in case of ElastiCache failover. It is not designed to be an operational tool for initiating a failover to overcome a problem you may have with the cluster. Moreover, in certain conditions such as large-scale operational events, Amazon may block this API.
     *
     * **Note the following**
     * + A customer can use this operation to test automatic failover on up to 5 shards (called node groups in the ElastiCache API and Amazon CLI) in any rolling 24-hour period.
     * + If calling this operation on shards in different clusters (called replication groups in the API and CLI), the calls can be made concurrently.
     * + If calling this operation multiple times on different shards in the same Redis (cluster mode enabled) replication group, the first node replacement must complete before a subsequent call can be made.
     * + To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console, the Amazon CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in order of occurrance:
     *    + Replication group message: `Test Failover API called for node group <node-group-id>`
     *    + Cache cluster message: `Failover from primary node <primary-node-id> to replica node <node-id> completed`
     *    + Replication group message: `Failover from primary node <primary-node-id> to replica node <node-id> completed`
     *    + Cache cluster message: `Recovering cache nodes <node-id>`
     *    + Cache cluster message: `Finished recovery for cache nodes <node-id>`
     * For more information see:
     *    + [Viewing ElastiCache Events](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html) in the *ElastiCache User Guide*
     *    + [DescribeEvents](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html) in the ElastiCache API Reference
     *
     * Also see, [Testing Multi-AZ ](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test) in the *ElastiCache User Guide*.
     */
    suspend fun testFailover(input: TestFailoverRequest): TestFailoverResponse

    /**
     * Represents the input of a `TestFailover` operation which test automatic failover on a specified node group (called shard in the console) in a replication group (called cluster in the console).
     *
     * This API is designed for testing the behavior of your application in case of ElastiCache failover. It is not designed to be an operational tool for initiating a failover to overcome a problem you may have with the cluster. Moreover, in certain conditions such as large-scale operational events, Amazon may block this API.
     *
     * **Note the following**
     * + A customer can use this operation to test automatic failover on up to 5 shards (called node groups in the ElastiCache API and Amazon CLI) in any rolling 24-hour period.
     * + If calling this operation on shards in different clusters (called replication groups in the API and CLI), the calls can be made concurrently.
     * + If calling this operation multiple times on different shards in the same Redis (cluster mode enabled) replication group, the first node replacement must complete before a subsequent call can be made.
     * + To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console, the Amazon CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in order of occurrance:
     *    + Replication group message: `Test Failover API called for node group <node-group-id>`
     *    + Cache cluster message: `Failover from primary node <primary-node-id> to replica node <node-id> completed`
     *    + Replication group message: `Failover from primary node <primary-node-id> to replica node <node-id> completed`
     *    + Cache cluster message: `Recovering cache nodes <node-id>`
     *    + Cache cluster message: `Finished recovery for cache nodes <node-id>`
     * For more information see:
     *    + [Viewing ElastiCache Events](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html) in the *ElastiCache User Guide*
     *    + [DescribeEvents](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html) in the ElastiCache API Reference
     *
     * Also see, [Testing Multi-AZ ](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test) in the *ElastiCache User Guide*.
     */
    suspend fun testFailover(block: TestFailoverRequest.Builder.() -> Unit) = testFailover(TestFailoverRequest.Builder().apply(block).build())
}
