// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eksauth.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Amazon EKS Pod Identity associations provide the ability to manage credentials for your applications, similar to the way that Amazon EC2 instance profiles provide credentials to Amazon EC2 instances.
 */
public class PodIdentityAssociation private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the EKS Pod Identity association.
     */
    public val associationArn: kotlin.String = requireNotNull(builder.associationArn) { "A non-null value must be provided for associationArn" }
    /**
     * The ID of the association.
     */
    public val associationId: kotlin.String = requireNotNull(builder.associationId) { "A non-null value must be provided for associationId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eksauth.model.PodIdentityAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PodIdentityAssociation(")
        append("associationArn=$associationArn,")
        append("associationId=$associationId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationArn.hashCode()
        result = 31 * result + (associationId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PodIdentityAssociation

        if (associationArn != other.associationArn) return false
        if (associationId != other.associationId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eksauth.model.PodIdentityAssociation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the EKS Pod Identity association.
         */
        public var associationArn: kotlin.String? = null
        /**
         * The ID of the association.
         */
        public var associationId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eksauth.model.PodIdentityAssociation) : this() {
            this.associationArn = x.associationArn
            this.associationId = x.associationId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eksauth.model.PodIdentityAssociation = PodIdentityAssociation(this)

        internal fun correctErrors(): Builder {
            if (associationArn == null) associationArn = ""
            if (associationId == null) associationId = ""
            return this
        }
    }
}
