// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eksauth.model

import aws.smithy.kotlin.runtime.SdkDsl

public class AssumeRoleForPodIdentityResponse private constructor(builder: Builder) {
    /**
     * An object with the permanent IAM role identity and the temporary session name.
     *
     * The ARN of the IAM role that the temporary credentials authenticate to.
     *
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the role ID, a colon (`:`), and the role session name of the role that is being assumed. The role ID is generated by IAM when the role is created. The role session name part of the value follows this format: `eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> `
     */
    public val assumedRoleUser: aws.sdk.kotlin.services.eksauth.model.AssumedRoleUser? = builder.assumedRoleUser
    /**
     * The identity that is allowed to use the credentials. This value is always `pods.eks.amazonaws.com`.
     */
    public val audience: kotlin.String = requireNotNull(builder.audience) { "A non-null value must be provided for audience" }
    /**
     * The *Amazon Web Services Signature Version 4* type of temporary credentials.
     */
    public val credentials: aws.sdk.kotlin.services.eksauth.model.Credentials? = builder.credentials
    /**
     * The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
     */
    public val podIdentityAssociation: aws.sdk.kotlin.services.eksauth.model.PodIdentityAssociation? = builder.podIdentityAssociation
    /**
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     */
    public val subject: aws.sdk.kotlin.services.eksauth.model.Subject? = builder.subject

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eksauth.model.AssumeRoleForPodIdentityResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssumeRoleForPodIdentityResponse(")
        append("assumedRoleUser=$assumedRoleUser,")
        append("audience=$audience,")
        append("credentials=*** Sensitive Data Redacted ***,")
        append("podIdentityAssociation=$podIdentityAssociation,")
        append("subject=$subject")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assumedRoleUser?.hashCode() ?: 0
        result = 31 * result + (audience.hashCode())
        result = 31 * result + (credentials?.hashCode() ?: 0)
        result = 31 * result + (podIdentityAssociation?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssumeRoleForPodIdentityResponse

        if (assumedRoleUser != other.assumedRoleUser) return false
        if (audience != other.audience) return false
        if (credentials != other.credentials) return false
        if (podIdentityAssociation != other.podIdentityAssociation) return false
        if (subject != other.subject) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eksauth.model.AssumeRoleForPodIdentityResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An object with the permanent IAM role identity and the temporary session name.
         *
         * The ARN of the IAM role that the temporary credentials authenticate to.
         *
         * The session name of the temporary session requested to STS. The value is a unique identifier that contains the role ID, a colon (`:`), and the role session name of the role that is being assumed. The role ID is generated by IAM when the role is created. The role session name part of the value follows this format: `eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> `
         */
        public var assumedRoleUser: aws.sdk.kotlin.services.eksauth.model.AssumedRoleUser? = null
        /**
         * The identity that is allowed to use the credentials. This value is always `pods.eks.amazonaws.com`.
         */
        public var audience: kotlin.String? = null
        /**
         * The *Amazon Web Services Signature Version 4* type of temporary credentials.
         */
        public var credentials: aws.sdk.kotlin.services.eksauth.model.Credentials? = null
        /**
         * The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
         */
        public var podIdentityAssociation: aws.sdk.kotlin.services.eksauth.model.PodIdentityAssociation? = null
        /**
         * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
         */
        public var subject: aws.sdk.kotlin.services.eksauth.model.Subject? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eksauth.model.AssumeRoleForPodIdentityResponse) : this() {
            this.assumedRoleUser = x.assumedRoleUser
            this.audience = x.audience
            this.credentials = x.credentials
            this.podIdentityAssociation = x.podIdentityAssociation
            this.subject = x.subject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eksauth.model.AssumeRoleForPodIdentityResponse = AssumeRoleForPodIdentityResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.eksauth.model.AssumedRoleUser] inside the given [block]
         */
        public fun assumedRoleUser(block: aws.sdk.kotlin.services.eksauth.model.AssumedRoleUser.Builder.() -> kotlin.Unit) {
            this.assumedRoleUser = aws.sdk.kotlin.services.eksauth.model.AssumedRoleUser.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eksauth.model.Credentials] inside the given [block]
         */
        public fun credentials(block: aws.sdk.kotlin.services.eksauth.model.Credentials.Builder.() -> kotlin.Unit) {
            this.credentials = aws.sdk.kotlin.services.eksauth.model.Credentials.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eksauth.model.PodIdentityAssociation] inside the given [block]
         */
        public fun podIdentityAssociation(block: aws.sdk.kotlin.services.eksauth.model.PodIdentityAssociation.Builder.() -> kotlin.Unit) {
            this.podIdentityAssociation = aws.sdk.kotlin.services.eksauth.model.PodIdentityAssociation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eksauth.model.Subject] inside the given [block]
         */
        public fun subject(block: aws.sdk.kotlin.services.eksauth.model.Subject.Builder.() -> kotlin.Unit) {
            this.subject = aws.sdk.kotlin.services.eksauth.model.Subject.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (audience == null) audience = ""
            return this
        }
    }
}
