// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eksauth.serde

import aws.sdk.kotlin.services.eksauth.model.AssumeRoleForPodIdentityResponse
import aws.sdk.kotlin.services.eksauth.model.AssumedRoleUser
import aws.sdk.kotlin.services.eksauth.model.Credentials
import aws.sdk.kotlin.services.eksauth.model.EksAuthException
import aws.sdk.kotlin.services.eksauth.model.PodIdentityAssociation
import aws.sdk.kotlin.services.eksauth.model.Subject
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AssumeRoleForPodIdentityOperationDeserializer: HttpDeserializer.NonStreaming<AssumeRoleForPodIdentityResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AssumeRoleForPodIdentityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAssumeRoleForPodIdentityError(context, call, payload)
        }
        val builder = AssumeRoleForPodIdentityResponse.Builder()

        if (payload != null) {
            deserializeAssumeRoleForPodIdentityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAssumeRoleForPodIdentityError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EksAuthException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ExpiredTokenException" -> ExpiredTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTokenException" -> InvalidTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EksAuthException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssumeRoleForPodIdentityOperationBody(builder: AssumeRoleForPodIdentityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSUMEDROLEUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("assumedRoleUser"))
    val AUDIENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("audience"))
    val CREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("credentials"))
    val PODIDENTITYASSOCIATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("podIdentityAssociation"))
    val SUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("subject"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSUMEDROLEUSER_DESCRIPTOR)
        field(AUDIENCE_DESCRIPTOR)
        field(CREDENTIALS_DESCRIPTOR)
        field(PODIDENTITYASSOCIATION_DESCRIPTOR)
        field(SUBJECT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSUMEDROLEUSER_DESCRIPTOR.index -> builder.assumedRoleUser = deserializeAssumedRoleUserDocument(deserializer)
                AUDIENCE_DESCRIPTOR.index -> builder.audience = deserializeString()
                CREDENTIALS_DESCRIPTOR.index -> builder.credentials = deserializeCredentialsDocument(deserializer)
                PODIDENTITYASSOCIATION_DESCRIPTOR.index -> builder.podIdentityAssociation = deserializePodIdentityAssociationDocument(deserializer)
                SUBJECT_DESCRIPTOR.index -> builder.subject = deserializeSubjectDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
