// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eksauth.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object containing the name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
 */
public class Subject private constructor(builder: Builder) {
    /**
     * The name of the Kubernetes namespace inside the cluster to create the association in. The service account and the pods that use the service account must be in this namespace.
     */
    public val namespace: kotlin.String = requireNotNull(builder.namespace) { "A non-null value must be provided for namespace" }
    /**
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     */
    public val serviceAccount: kotlin.String = requireNotNull(builder.serviceAccount) { "A non-null value must be provided for serviceAccount" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eksauth.model.Subject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Subject(")
        append("namespace=$namespace,")
        append("serviceAccount=$serviceAccount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = namespace.hashCode()
        result = 31 * result + (serviceAccount.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Subject

        if (namespace != other.namespace) return false
        if (serviceAccount != other.serviceAccount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eksauth.model.Subject = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Kubernetes namespace inside the cluster to create the association in. The service account and the pods that use the service account must be in this namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
         */
        public var serviceAccount: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eksauth.model.Subject) : this() {
            this.namespace = x.namespace
            this.serviceAccount = x.serviceAccount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eksauth.model.Subject = Subject(this)

        internal fun correctErrors(): Builder {
            if (namespace == null) namespace = ""
            if (serviceAccount == null) serviceAccount = ""
            return this
        }
    }
}
