// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eksauth.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object with the permanent IAM role identity and the temporary session name.
 */
public class AssumedRoleUser private constructor(builder: Builder) {
    /**
     * The ARN of the IAM role that the temporary credentials authenticate to.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the role ID, a colon (`:`), and the role session name of the role that is being assumed. The role ID is generated by IAM when the role is created. The role session name part of the value follows this format: `eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> `
     */
    public val assumeRoleId: kotlin.String = requireNotNull(builder.assumeRoleId) { "A non-null value must be provided for assumeRoleId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eksauth.model.AssumedRoleUser = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssumedRoleUser(")
        append("arn=$arn,")
        append("assumeRoleId=$assumeRoleId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (assumeRoleId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssumedRoleUser

        if (arn != other.arn) return false
        if (assumeRoleId != other.assumeRoleId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eksauth.model.AssumedRoleUser = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the IAM role that the temporary credentials authenticate to.
         */
        public var arn: kotlin.String? = null
        /**
         * The session name of the temporary session requested to STS. The value is a unique identifier that contains the role ID, a colon (`:`), and the role session name of the role that is being assumed. The role ID is generated by IAM when the role is created. The role session name part of the value follows this format: `eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> `
         */
        public var assumeRoleId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eksauth.model.AssumedRoleUser) : this() {
            this.arn = x.arn
            this.assumeRoleId = x.assumeRoleId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eksauth.model.AssumedRoleUser = AssumedRoleUser(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (assumeRoleId == null) assumeRoleId = ""
            return this
        }
    }
}
