// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specify granular overrides for specific repair actions. These overrides control the repair action and the repair delay time before a node is considered eligible for repair. If you use this, you must specify all the values.
 */
public class NodeRepairConfigOverrides private constructor(builder: Builder) {
    /**
     * Specify the minimum time in minutes to wait before attempting to repair a node with this specific `nodeMonitoringCondition` and `nodeUnhealthyReason`.
     */
    public val minRepairWaitTimeMins: kotlin.Int? = builder.minRepairWaitTimeMins
    /**
     * Specify an unhealthy condition reported by the node monitoring agent that this override would apply to.
     */
    public val nodeMonitoringCondition: kotlin.String? = builder.nodeMonitoringCondition
    /**
     * Specify a reason reported by the node monitoring agent that this override would apply to.
     */
    public val nodeUnhealthyReason: kotlin.String? = builder.nodeUnhealthyReason
    /**
     * Specify the repair action to take for nodes when all of the specified conditions are met.
     */
    public val repairAction: aws.sdk.kotlin.services.eks.model.RepairAction? = builder.repairAction

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.NodeRepairConfigOverrides = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeRepairConfigOverrides(")
        append("minRepairWaitTimeMins=$minRepairWaitTimeMins,")
        append("nodeMonitoringCondition=$nodeMonitoringCondition,")
        append("nodeUnhealthyReason=$nodeUnhealthyReason,")
        append("repairAction=$repairAction")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = minRepairWaitTimeMins ?: 0
        result = 31 * result + (nodeMonitoringCondition?.hashCode() ?: 0)
        result = 31 * result + (nodeUnhealthyReason?.hashCode() ?: 0)
        result = 31 * result + (repairAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeRepairConfigOverrides

        if (minRepairWaitTimeMins != other.minRepairWaitTimeMins) return false
        if (nodeMonitoringCondition != other.nodeMonitoringCondition) return false
        if (nodeUnhealthyReason != other.nodeUnhealthyReason) return false
        if (repairAction != other.repairAction) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.NodeRepairConfigOverrides = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify the minimum time in minutes to wait before attempting to repair a node with this specific `nodeMonitoringCondition` and `nodeUnhealthyReason`.
         */
        public var minRepairWaitTimeMins: kotlin.Int? = null
        /**
         * Specify an unhealthy condition reported by the node monitoring agent that this override would apply to.
         */
        public var nodeMonitoringCondition: kotlin.String? = null
        /**
         * Specify a reason reported by the node monitoring agent that this override would apply to.
         */
        public var nodeUnhealthyReason: kotlin.String? = null
        /**
         * Specify the repair action to take for nodes when all of the specified conditions are met.
         */
        public var repairAction: aws.sdk.kotlin.services.eks.model.RepairAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.NodeRepairConfigOverrides) : this() {
            this.minRepairWaitTimeMins = x.minRepairWaitTimeMins
            this.nodeMonitoringCondition = x.nodeMonitoringCondition
            this.nodeUnhealthyReason = x.nodeUnhealthyReason
            this.repairAction = x.repairAction
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.NodeRepairConfigOverrides = NodeRepairConfigOverrides(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
